/*
 * Decompiled with CFR 0.152.
 */
package floetteroed.cadyts.interfaces.sumo;

import floetteroed.cadyts.demand.ODRelation;
import floetteroed.utilities.DynamicData;
import floetteroed.utilities.math.Matrix;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;

class SumoODWriter {
    SumoODWriter() {
    }

    private List<String> extractZones(DynamicData<ODRelation<String>> od) {
        TreeSet<String> zones = new TreeSet<String>();
        for (ODRelation<String> key : od.keySet()) {
            zones.add(key.getFromTAZ());
            zones.add(key.getToTAZ());
        }
        return new ArrayList<String>(zones);
    }

    private Matrix tripMatrix(DynamicData<ODRelation<String>> od, int bin, List<String> zones) {
        Matrix result = new Matrix(zones.size(), zones.size());
        for (int i = 0; i < zones.size(); ++i) {
            for (int j = 0; j < zones.size(); ++j) {
                ODRelation<String> key = new ODRelation<String>(zones.get(i), zones.get(j));
                result.getRow(i).set(j, od.getBinValue(key, bin));
            }
        }
        return result;
    }

    void write(DynamicData<ODRelation<String>> od, String filePrefix) throws FileNotFoundException {
        List<String> zones = this.extractZones(od);
        for (int bin = 0; bin < od.getBinCnt(); ++bin) {
            Matrix tripMatrix = this.tripMatrix(od, bin, zones);
            if (!(tripMatrix.frobeniusNorm() > 0.0)) continue;
            int h_start = od.binStart_s(bin) / 3600;
            int m_start = (od.binStart_s(bin) - h_start * 3600) / 60;
            int h_end = od.binStart_s(bin + 1) / 3600;
            int m_end = (od.binStart_s(bin + 1) - h_end * 3600) / 60;
            PrintWriter writer = new PrintWriter(filePrefix + "_" + h_start + "h" + m_start + "m-" + h_end + "h" + m_end + "m.fma");
            writer.println("$VMR");
            writer.println("* vehicle type");
            writer.println("0");
            writer.println("* from-time to-time");
            writer.println(h_start + "." + m_start + " " + h_end + "." + m_end);
            writer.println("* factor");
            writer.println("1.0");
            writer.println("* district number");
            writer.println(zones.size());
            writer.println("* names");
            for (String zone : zones) {
                writer.print("\t" + zone);
            }
            writer.println();
            writer.println("*");
            for (int i = 0; i < zones.size(); ++i) {
                writer.println("* district " + zones.get(i) + " sum = " + tripMatrix.getRow(i).sum());
                for (int j = 0; j < zones.size(); ++j) {
                    writer.print("\t" + tripMatrix.getRow(i).get(j));
                }
                writer.println();
            }
            writer.flush();
            writer.close();
        }
    }
}

