/*
 * Decompiled with CFR 0.152.
 */
package floetteroed.cadyts.measurements;

import floetteroed.cadyts.calibrators.Calibrator;
import floetteroed.cadyts.calibrators.TimedElement;
import floetteroed.cadyts.demand.Demand;
import floetteroed.cadyts.demand.PlanStep;
import floetteroed.cadyts.measurements.SingleLinkMeasurement;
import floetteroed.cadyts.supply.LinkLoading;
import floetteroed.cadyts.supply.SimResults;
import floetteroed.utilities.math.SignalSmoother;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;

public class MultiLinkMeasurement<L>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final int value_veh;
    private final double eta;
    private double sensitivity;
    private List<L> tempLinkList = new ArrayList<L>();
    private List<TimedElement> tempTimes = new ArrayList<TimedElement>();
    private Calibrator<L> calibrator = null;
    private SignalSmoother avgMatches_veh = null;
    private List<LinkLoading<L>> loadings = null;
    private Set<L> observedLinks = null;

    public MultiLinkMeasurement(int value_veh, double detectionRate) {
        if (value_veh < 0) {
            throw new IllegalArgumentException("count must not be negative");
        }
        if (detectionRate <= 0.0 || detectionRate > 1.0) {
            throw new IllegalArgumentException("detection rate of " + detectionRate + " is not in (0,1]");
        }
        this.value_veh = value_veh;
        this.eta = detectionRate;
        this.sensitivity = 0.0;
    }

    public void init(Calibrator<L> calibrator) {
        if (calibrator == null) {
            throw new IllegalArgumentException("calibrator must not be null");
        }
        if (this.calibrator != null) {
            Logger.getLogger(this.getClass().getName()).warning("init(..) has already been called; this call is ignored");
        } else {
            this.calibrator = calibrator;
            this.avgMatches_veh = new SignalSmoother(1.0 - calibrator.getRegressionInertia());
            this.loadings = new ArrayList<LinkLoading<L>>();
            this.observedLinks = new LinkedHashSet<L>();
            for (int i = 0; i < this.tempLinkList.size(); ++i) {
                LinkLoading<L> loading = calibrator.newLinkLoading(this.tempLinkList.get(i), this.tempTimes.get(i).getStartTime_s(), this.tempTimes.get(i).getEndTime_s(), SingleLinkMeasurement.TYPE.COUNT_VEH);
                this.loadings.add(loading);
                this.observedLinks.add(loading.getLink());
            }
            this.tempLinkList = null;
            this.tempTimes = null;
        }
    }

    public void addObservation(L link, int start_s, int end_s) {
        this.tempLinkList.add(link);
        this.tempTimes.add(new TimedElement(start_s, end_s));
    }

    public int getCount() {
        return this.value_veh;
    }

    public double getDetectionRate() {
        return this.eta;
    }

    public int size() {
        return this.loadings.size();
    }

    public Set<L> getObservedLinks() {
        return this.observedLinks;
    }

    public void freeze() {
        this.avgMatches_veh.freeze();
        for (LinkLoading<L> loading : this.loadings) {
            loading.freeze();
        }
    }

    public boolean appliesTo(int observationIndex, PlanStep<L> planStep) {
        LinkLoading<L> loading = this.loadings.get(observationIndex);
        if (loading.getLink().equals(planStep.getLink())) {
            int entry_s = planStep.getEntryTime_s();
            return loading.getStartTime_s() <= entry_s && loading.getEndTime_s() > entry_s;
        }
        return false;
    }

    public void update(double matches_veh, Demand<L> demand, SimResults<L> simResults) {
        this.avgMatches_veh.addValue(matches_veh);
        this.sensitivity = 1.0;
        for (LinkLoading<L> loading : this.loadings) {
            L link = loading.getLink();
            double flow_veh = simResults.getSimValue(link, loading.getStartTime_s(), loading.getEndTime_s(), SingleLinkMeasurement.TYPE.COUNT_VEH);
            loading.update(demand, flow_veh);
            this.sensitivity = Math.min(this.sensitivity, loading.get_dLinkFeature_dDemand(link));
        }
        this.sensitivity = Math.max(0.0, this.sensitivity);
    }

    private double var_veh2() {
        return this.calibrator.getVarianceScale() * (double)this.value_veh * (1.0 - this.eta) + this.eta * this.eta * this.calibrator.getMinStddev(SingleLinkMeasurement.TYPE.COUNT_VEH) * this.calibrator.getMinStddev(SingleLinkMeasurement.TYPE.COUNT_VEH);
    }

    public double ll(double matches_veh) {
        double e_veh = (double)this.value_veh - this.eta * matches_veh;
        return -1.0 * e_veh * e_veh / 2.0 / this.var_veh2();
    }

    public double dll_dMatches() {
        double e_veh = (double)this.value_veh - this.eta * this.avgMatches_veh.getSmoothedValue();
        return this.sensitivity * e_veh / this.var_veh2() * this.eta;
    }

    public String toString() {
        StringBuffer result = new StringBuffer(this.getClass().getSimpleName());
        result.append("(");
        for (LinkLoading<L> loading : this.loadings) {
            result.append(loading.getLink());
            result.append(", ");
        }
        result.append("count=");
        result.append(this.value_veh);
        result.append(", detectionRate=");
        result.append(this.eta);
        result.append(")");
        return result.toString();
    }
}

