/*
 * Decompiled with CFR 0.152.
 */
package floetteroed.utilities;

import floetteroed.utilities.FractionalIterator;
import java.util.ArrayList;
import java.util.Iterator;

public class FractionalIterable<T>
implements Iterable<T> {
    private final Iterable<T> iterable;
    private final double fraction;

    public FractionalIterable(Iterable<T> iterable, double fraction) {
        this.iterable = iterable;
        this.fraction = fraction;
    }

    @Override
    public Iterator<T> iterator() {
        return new FractionalIterator<T>(this.iterable.iterator(), this.fraction);
    }

    public static void main(String[] args) {
        ArrayList<Integer> all = new ArrayList<Integer>();
        for (int i = 0; i < 100; ++i) {
            all.add(i);
        }
        for (double f = 0.0; f <= 1.0; f += 0.1) {
            double cnt = 0.0;
            for (Integer element : new FractionalIterable(all, f)) {
                cnt += 1.0;
            }
            System.out.println(" should be: " + f + "; is " + cnt / (double)all.size());
        }
    }
}

