/*
 * Decompiled with CFR 0.152.
 */
package floetteroed.utilities;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class SimpleLogFormatter
extends Formatter {
    private final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private final String prefix;

    public SimpleLogFormatter(String prefix) {
        this.prefix = prefix;
    }

    @Override
    public String format(LogRecord rec) {
        StringBuffer buf = new StringBuffer(512);
        if (this.prefix != null) {
            buf.append(this.prefix);
        }
        buf.append(this.sdf.format(new Date(rec.getMillis())));
        buf.append(" ");
        buf.append(rec.getLevel());
        buf.append(" ");
        buf.append(this.formatMessage(rec));
        if (rec.getLevel().intValue() >= Level.WARNING.intValue() || rec.getLevel().intValue() <= Level.FINE.intValue()) {
            buf.append(" -> ");
            buf.append(rec.getSourceClassName());
            buf.append(".");
            buf.append(rec.getSourceMethodName());
        }
        buf.append("\n");
        return buf.toString();
    }
}

