/*
 * Decompiled with CFR 0.152.
 */
package floetteroed.utilities.config;

import floetteroed.utilities.config.ConfigPaths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class Config {
    private final String element;
    private final LinkedList<String> values = new LinkedList();
    private Map<String, Config> element2child = new LinkedHashMap<String, Config>();
    private final ConfigPaths configPaths;

    public Config(String element, String configPath) {
        if (element == null) {
            throw new IllegalArgumentException("element is null");
        }
        if ("".equals(element)) {
            throw new IllegalArgumentException("element is an empty string");
        }
        this.element = element;
        this.configPaths = configPath == null ? null : new ConfigPaths(configPath);
    }

    private List<String> key(String ... keysAndValue) {
        ArrayList<String> result = new ArrayList<String>(keysAndValue.length - 1);
        for (int i = 0; i < keysAndValue.length - 1; ++i) {
            result.add(keysAndValue[i]);
        }
        return result;
    }

    private String value(String ... keysAndValue) {
        return keysAndValue[keysAndValue.length - 1];
    }

    public void clear() {
        this.element2child.clear();
        this.values.clear();
    }

    public boolean add(List<String> key, String value) {
        if (key.size() > 0 && this.element.equals(key.get(0))) {
            if (key.size() == 1) {
                this.values.addLast(value);
                return true;
            }
            List<String> subKey = key.subList(1, key.size());
            Config child = this.element2child.get(subKey.get(0));
            if (child == null) {
                child = new Config(subKey.get(0), this.getConfigPath());
                this.element2child.put(subKey.get(0), child);
            }
            return child.add(subKey, value);
        }
        return false;
    }

    public void add(String ... keysAndValue) {
        this.add(this.key(keysAndValue), this.value(keysAndValue));
    }

    public String getConfigPath() {
        if (this.configPaths == null) {
            return null;
        }
        return this.configPaths.getAbsolutePathToConfig();
    }

    public String absolutePath(String fileName) {
        if (this.configPaths == null) {
            return fileName;
        }
        return this.configPaths.getAbsoluteFileName(fileName);
    }

    public int size() {
        int result = this.values.size();
        for (Config child : this.element2child.values()) {
            result += child.size();
        }
        return result;
    }

    public List<String> getList(List<String> keys) {
        if (keys.size() > 0 && this.element.equals(keys.get(0))) {
            if (keys.size() == 1) {
                return this.values;
            }
            Config child = this.element2child.get(keys.get(1));
            if (child != null) {
                return child.getList(keys.subList(1, keys.size()));
            }
        }
        return new ArrayList<String>(0);
    }

    public List<String> getList(String ... keys) {
        return this.getList(Arrays.asList(keys));
    }

    public boolean containsKeys(String ... keys) {
        return this.getList(keys) != null;
    }

    public String get(int index, List<String> keys) {
        List<String> list = this.getList(keys);
        if (list != null && index < list.size()) {
            return list.get(index);
        }
        return null;
    }

    public String get(int index, String ... keys) {
        return this.get(index, Arrays.asList(keys));
    }

    public String get(List<String> keys) {
        return this.get(0, keys);
    }

    public String get(String ... keys) {
        return this.get(0, keys);
    }

    public Config newSubConfig(List<String> keys) {
        if (keys.size() > 0 && this.element.equals(keys.get(0))) {
            if (keys.size() == 1) {
                return this;
            }
            Config child = this.element2child.get(keys.get(1));
            if (child != null) {
                return child.newSubConfig(keys.subList(1, keys.size()));
            }
        }
        return null;
    }

    public Config newSubConfig(String ... parentKeys) {
        return this.newSubConfig(Arrays.asList(parentKeys));
    }

    public List<String> toXML(String prefix, String indent) {
        ArrayList<String> result = new ArrayList<String>();
        if (this.values.size() == 0) {
            result.add(prefix + "<" + this.element + ">");
            for (Config child : this.element2child.values()) {
                result.addAll(child.toXML(prefix + indent, indent));
            }
            result.add(prefix + "</" + this.element + ">");
        } else {
            for (String value : this.values) {
                result.add(prefix + "<" + this.element + " value=\"" + value + "\">");
                for (Config child : this.element2child.values()) {
                    result.addAll(child.toXML(prefix + indent, indent));
                }
                result.add(prefix + "</" + this.element + ">");
            }
        }
        return result;
    }

    public List<String> toXML() {
        return this.toXML("", "");
    }
}

