/*
 * Decompiled with CFR 0.152.
 */
package floetteroed.utilities.config;

import java.io.File;

public class ConfigPaths {
    private final File pathToConfig;

    public ConfigPaths(String pathToConfig) {
        if (pathToConfig == null) {
            throw new IllegalArgumentException("path to config is null");
        }
        File absoluteFile = new File(pathToConfig).getAbsoluteFile();
        if (absoluteFile.isDirectory()) {
            this.pathToConfig = absoluteFile;
        } else if (absoluteFile.isFile()) {
            this.pathToConfig = absoluteFile.getParentFile();
        } else {
            throw new IllegalArgumentException("path to config neither is neither an existing file nor an existing directory");
        }
    }

    public String getAbsolutePathToConfig() {
        return this.pathToConfig.getAbsolutePath();
    }

    public String getAbsoluteFileName(String fileName) {
        File originalFile = new File(fileName);
        if (originalFile.isAbsolute()) {
            return fileName;
        }
        return new File(this.pathToConfig, fileName).getAbsolutePath();
    }
}

