/*
 * Decompiled with CFR 0.152.
 */
package floetteroed.utilities.math;

import java.util.Arrays;

public class Histogram {
    private final double[] bounds;
    private final int[] bins;
    private int totalCount;

    public Histogram(double ... bounds) {
        if (bounds == null) {
            throw new IllegalArgumentException("bounds array must not be null");
        }
        for (int i = 1; i < bounds.length; ++i) {
            if (!(bounds[i - 1] >= bounds[i])) continue;
            throw new IllegalArgumentException("bounds are not in ascending order");
        }
        this.bounds = bounds;
        this.bins = new int[bounds.length + 1];
        this.clear();
    }

    public static Histogram newHistogramWithUniformBins(double startValue, double binSize, int binCnt) {
        double[] bounds = new double[binCnt + 1];
        for (int bin = 0; bin <= binCnt; ++bin) {
            bounds[bin] = startValue + (double)bin * binSize;
        }
        return new Histogram(bounds);
    }

    public void clear() {
        Arrays.fill(this.bins, 0);
        this.totalCount = 0;
    }

    public void add(double value) {
        int i;
        for (i = 0; i < this.bounds.length && value >= this.bounds[i]; ++i) {
        }
        int n = i;
        this.bins[n] = this.bins[n] + 1;
        ++this.totalCount;
    }

    public void makeNonZero() {
        for (int i = 0; i < this.bins.length; ++i) {
            if (this.bins[i] != 0) continue;
            int n = i;
            this.bins[n] = this.bins[n] + 1;
            ++this.totalCount;
        }
    }

    public int binCnt() {
        return this.bins.length;
    }

    public double lowerBound(int bin) {
        if (bin == 0) {
            return Double.NEGATIVE_INFINITY;
        }
        return this.bounds[bin - 1];
    }

    public double upperBound(int bin) {
        if (bin == this.binCnt() - 1) {
            return Double.POSITIVE_INFINITY;
        }
        return this.bounds[bin];
    }

    public int cnt() {
        return this.totalCount;
    }

    public int cnt(int bin) {
        return this.bins[bin];
    }

    public double freq(int bin) {
        double cnt = this.cnt(bin);
        if (cnt > 0.0) {
            return cnt / (double)this.totalCount;
        }
        return 0.0;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        if (this.binCnt() == 1) {
            result.append("(-oo, +oo) : 1.0 (" + this.totalCount + " of " + this.totalCount + ")");
        } else {
            result.append("(-oo, " + this.bounds[0] + ") : " + this.freq(0) + " (" + this.bins[0] + " of " + this.totalCount + ")\n");
            for (int i = 1; i < this.bounds.length; ++i) {
                result.append("[" + this.bounds[i - 1] + ", " + this.bounds[i] + ") : " + this.freq(i) + " (" + this.bins[i] + " of " + this.totalCount + ")\n");
            }
            result.append("[" + this.bounds[this.bounds.length - 1] + ", +oo) : " + this.freq(this.bounds.length) + " (" + this.bins[this.bounds.length] + " of " + this.totalCount + ")");
        }
        return result.toString();
    }
}

