/*
 * Decompiled with CFR 0.152.
 */
package floetteroed.utilities.math;

import floetteroed.utilities.math.Matrix;
import floetteroed.utilities.math.Vector;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;

public class MathHelpers {
    private MathHelpers() {
    }

    public static Double parseDouble(String s) {
        if (s == null) {
            return null;
        }
        return Double.parseDouble(s);
    }

    public static Integer parseInteger(String s) {
        if (s == null) {
            return null;
        }
        return Integer.parseInt(s);
    }

    public static Long parseLong(String s) {
        if (s == null) {
            return null;
        }
        return Long.parseLong(s);
    }

    public static Boolean parseBoolean(String s) {
        if (s == null) {
            return null;
        }
        return Boolean.parseBoolean(s);
    }

    public static double length(double x1, double y1, double x2, double y2) {
        double dx = x2 - x1;
        double dy = y2 - y1;
        return Math.sqrt(dx * dx + dy * dy);
    }

    public static double overlap(double start1, double end1, double start2, double end2) {
        return Math.max(0.0, Math.min(end1, end2) - Math.max(start1, start2));
    }

    public static double round(double x, int digits) {
        double fact = Math.pow(10.0, digits);
        return (double)Math.round(x * fact) / fact;
    }

    public static int round(double x) {
        return (int)MathHelpers.round(x, 0);
    }

    public static int draw(Vector probs, Random rnd) {
        double x = rnd.nextDouble();
        int result = -1;
        double pSum = 0.0;
        while ((pSum += probs.get(++result)) < x && result < probs.size() - 1) {
        }
        return result;
    }

    public static synchronized <T> Set<T> drawWithoutReplacement(int n, Collection<T> collection, Random rnd) {
        LinkedHashSet<T> result = new LinkedHashSet<T>();
        while (result.size() < n && result.size() < collection.size()) {
            result.add(MathHelpers.draw(collection, rnd));
        }
        return result;
    }

    public static <T> T draw(Collection<T> collection, Random rnd) {
        int index = rnd.nextInt(collection.size());
        Iterator<T> it = collection.iterator();
        for (int i = 0; i < index; ++i) {
            it.next();
        }
        return it.next();
    }

    public static <T> T drawAndRemove(Collection<T> collection, Random rnd) {
        T result = MathHelpers.draw(collection, rnd);
        collection.remove(result);
        return result;
    }

    public static double draw(double lower, double upper, Random rnd) {
        return lower + rnd.nextDouble() * (upper - lower);
    }

    public static double[] override(double[] dest, double[] source, boolean overrideWithZeros) {
        if (source == null) {
            if (overrideWithZeros) {
                return null;
            }
            return dest;
        }
        if (dest == null) {
            double[] result = new double[source.length];
            System.arraycopy(source, 0, result, 0, source.length);
            return result;
        }
        for (int i = 0; i < source.length; ++i) {
            if (!overrideWithZeros && source[i] == 0.0) continue;
            dest[i] = source[i];
        }
        return dest;
    }

    public static boolean equal(Vector v1, Vector v2, double tol) {
        if (v1 == null || v2 == null || v1.size() != v2.size()) {
            return false;
        }
        for (int i = 0; i < v1.size(); ++i) {
            if (!(Math.abs(v1.get(i) - v2.get(i)) > tol)) continue;
            return false;
        }
        return true;
    }

    public static boolean equal(Matrix m1, Matrix m2, double tol) {
        if (m1 == null || m2 == null || m1.rowSize() != m2.rowSize()) {
            return false;
        }
        for (int i = 0; i < m1.rowSize(); ++i) {
            if (MathHelpers.equal(m1.getRow(i), m2.getRow(i), tol)) continue;
            return false;
        }
        return true;
    }

    public static <E> E draw(Map<E, Double> event2proba, Random rnd) {
        Map.Entry<E, Double> next;
        double x = rnd.nextDouble();
        double pSum = 0.0;
        Iterator<Map.Entry<E, Double>> it = event2proba.entrySet().iterator();
        E result = null;
        do {
            next = it.next();
            result = next.getKey();
        } while ((pSum += next.getValue().doubleValue()) < x && it.hasNext());
        return result;
    }

    public static <E> E draw(Map<E, Double> event2weight, double weightSum, Random rnd) {
        Map.Entry<E, Double> next;
        double x = weightSum * rnd.nextDouble();
        double cumulativeWeight = 0.0;
        Iterator<Map.Entry<E, Double>> it = event2weight.entrySet().iterator();
        E result = null;
        do {
            next = it.next();
            result = next.getKey();
        } while ((cumulativeWeight += next.getValue().doubleValue()) < x && it.hasNext());
        return result;
    }

    public static double projectOnInterval(double value, double bound1, double bound2) {
        double halfBounded = Math.max(value, Math.min(bound1, bound2));
        return Math.min(halfBounded, Math.max(bound1, bound2));
    }

    public static Vector hadamardProduct(Vector x, Vector y) {
        Vector result = x.copy();
        for (int i = 0; i < y.size(); ++i) {
            result.mult(i, y.get(i));
        }
        return result;
    }

    public static void main(String[] test) {
        LinkedHashMap<String, Double> m = new LinkedHashMap<String, Double>();
        m.put("A", 1.0);
        m.put("B", 2.0);
        m.put("C", 0.0);
        double aFreq = 0.0;
        double bFreq = 0.0;
        double cFreq = 0.0;
        for (int i = 0; i < 1000; ++i) {
            String draw = (String)MathHelpers.draw(m, 3.0, new Random());
            if ("A".equals(draw)) {
                aFreq += 1.0;
                continue;
            }
            if ("B".equals(draw)) {
                bFreq += 1.0;
                continue;
            }
            if (!"C".equals(draw)) continue;
            cFreq += 1.0;
        }
        System.out.println(aFreq + "\t" + bFreq + "\t" + cFreq);
    }
}

