/*
 * Decompiled with CFR 0.152.
 */
package floetteroed.utilities.math;

import floetteroed.utilities.math.Vector;
import java.io.Serializable;

public class Matrix
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Vector[] rows;

    private Matrix(Vector[] rows) {
        this.rows = rows;
    }

    public Matrix(Vector row) {
        this(new Vector[]{row.copy()});
    }

    public Matrix(int rowCnt, int colCnt) {
        if (rowCnt < 1) {
            throw new IllegalArgumentException("matrix must have at least one row");
        }
        this.rows = new Vector[rowCnt];
        for (int i = 0; i < rowCnt; ++i) {
            this.rows[i] = new Vector(colCnt);
        }
    }

    public static Matrix newDiagonal(int dim, double val) {
        Matrix result = new Matrix(dim, dim);
        for (int i = 0; i < dim; ++i) {
            result.getRow(i).set(i, val);
        }
        return result;
    }

    public static Matrix newDiagonal(Vector diagonal) {
        Matrix result = new Matrix(diagonal.size(), diagonal.size());
        for (int i = 0; i < diagonal.size(); ++i) {
            result.getRow(i).set(i, diagonal.get(i));
        }
        return result;
    }

    public Matrix copyEnlarged(int rowEnlargement, int columnEnlargement) {
        int row;
        if (rowEnlargement < 0) {
            throw new IllegalArgumentException("row enlargement must not be negative");
        }
        if (columnEnlargement < 0) {
            throw new IllegalArgumentException("column enlargement must not be negative");
        }
        Vector[] newRows = new Vector[this.rows.length + rowEnlargement];
        for (row = 0; row < this.rows.length; ++row) {
            newRows[row] = this.rows[row].copyEnlarged(columnEnlargement);
        }
        for (row = this.rows.length; row < newRows.length; ++row) {
            newRows[row] = new Vector(newRows[0].size());
        }
        return new Matrix(newRows);
    }

    public Matrix copy() {
        return this.copyEnlarged(0, 0);
    }

    public Matrix newImmutableView() {
        Matrix result = new Matrix(new Vector[this.rowSize()]);
        for (int i = 0; i < this.rowSize(); ++i) {
            result.rows[i] = this.rows[i].newImmutableView();
        }
        return result;
    }

    public int rowSize() {
        return this.rows.length;
    }

    public int columnSize() {
        return this.rows[0].size();
    }

    public Vector getRow(int i) {
        return this.rows[i];
    }

    public double frobeniusNorm() {
        double result = 0.0;
        for (Vector row : this.rows) {
            result += row.innerProd(row);
        }
        return Math.sqrt(result);
    }

    public void mult(double value) {
        for (Vector row : this.rows) {
            row.mult(value);
        }
    }

    public void add(Matrix other, double weight) {
        for (int i = 0; i < this.rowSize(); ++i) {
            this.rows[i].add(other.rows[i], weight);
        }
    }

    public void clear() {
        for (Vector row : this.rows) {
            row.clear();
        }
    }

    public void addOuterProduct(Vector other1, Vector other2, double weight) {
        if (other1.size() != this.rowSize()) {
            throw new IllegalArgumentException("size of first vector must equal matrix row dimension");
        }
        if (other2.size() != this.columnSize()) {
            throw new IllegalArgumentException("size of second vector must equal matrix column dimension");
        }
        for (int i = 0; i < other1.size(); ++i) {
            this.getRow(i).add(other2, other1.get(i) * weight);
        }
    }

    public Vector timesVectorFromLeft(Vector other, Vector result) {
        if (other.size() != this.rowSize()) {
            throw new IllegalArgumentException("other vector must have same size as row dimension of this matrix");
        }
        if (result.size() != this.columnSize()) {
            throw new IllegalArgumentException("result vector must be of same dimension as column dimension of this matrix");
        }
        for (int l = 0; l < other.size(); ++l) {
            result.add(this.getRow(l), other.get(l));
        }
        return result;
    }

    public Vector timesVectorFromLeft(Vector other) {
        return this.timesVectorFromLeft(other, new Vector(this.columnSize()));
    }

    public void round(int decimals) {
        for (Vector row : this.rows) {
            row.round(decimals);
        }
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < this.rowSize() - 1; ++i) {
            result.append(this.rows[i].toString());
            result.append("\n");
        }
        result.append(this.rows[this.rowSize() - 1].toString());
        return result.toString();
    }

    public void symmetrize() {
        for (int i = 0; i < this.rowSize(); ++i) {
            Vector iRow = this.getRow(i);
            for (int j = 0; j < i; ++j) {
                Vector jRow = this.getRow(j);
                double cov = 0.5 * (iRow.get(j) + jRow.get(i));
                iRow.set(j, cov);
                jRow.set(i, cov);
            }
        }
    }

    public void setColumn(int j, Vector column) {
        for (int i = 0; i < this.rowSize(); ++i) {
            this.getRow(i).set(j, column.get(i));
        }
    }

    public boolean isAllZeros() {
        for (Vector row : this.rows) {
            if (row.isAllZeros()) continue;
            return false;
        }
        return true;
    }

    public String toSingleLineString() {
        StringBuffer result = new StringBuffer();
        result.append("[");
        for (int i = 0; i < this.rowSize(); ++i) {
            result.append(this.rows[i].toString());
        }
        result.append("]");
        return result.toString();
    }

    public Vector timesVectorFromRight(Vector other, Vector result) {
        for (int i = 0; i < this.rowSize(); ++i) {
            result.set(i, this.getRow(i).innerProd(other));
        }
        return result;
    }

    public Vector timesVectorFromRight(Vector other) {
        return this.timesVectorFromRight(other, new Vector(this.rowSize()));
    }

    public Matrix newTransposed() {
        Matrix result = new Matrix(this.columnSize(), this.rowSize());
        for (int i = 0; i < this.rowSize(); ++i) {
            Vector fromRow_i = this.getRow(i);
            for (int j = 0; j < this.columnSize(); ++j) {
                result.getRow(j).set(i, fromRow_i.get(j));
            }
        }
        return result;
    }

    public static Matrix product(Matrix _A, Matrix _B) {
        if (_A.columnSize() != _B.rowSize()) {
            throw new IllegalArgumentException("column size of first argument does not equal row size of second argument");
        }
        Matrix _C = new Matrix(_A.rowSize(), _B.columnSize());
        for (int i = 0; i < _C.rowSize(); ++i) {
            Vector _A_row_i = _A.getRow(i);
            Vector _C_row_i = _C.getRow(i);
            for (int k = 0; k < _A.columnSize(); ++k) {
                _C_row_i.add(_B.getRow(k), _A_row_i.get(k));
            }
        }
        return _C;
    }

    public boolean isNaN() {
        for (Vector row : this.rows) {
            if (!row.isNaN()) continue;
            return true;
        }
        return false;
    }

    public double absValueSum() {
        double result = 0.0;
        for (Vector row : this.rows) {
            result += row.absValueSum();
        }
        return result;
    }

    public double max() {
        double result = Double.NEGATIVE_INFINITY;
        for (Vector row : this.rows) {
            result = Math.max(result, row.max());
        }
        return result;
    }

    public void makeProbability() {
        double sum = 0.0;
        for (Vector row : this.rows) {
            for (int i = 0; i < row.size(); ++i) {
                if (row.get(i) < 0.0) {
                    row.set(i, 0.0);
                    continue;
                }
                if (row.get(i) > 1.0) {
                    row.set(i, 1.0);
                    sum += 1.0;
                    continue;
                }
                sum += row.get(i);
            }
        }
        this.mult(1.0 / sum);
    }

    public static double maxAbsDiff(Matrix a, Matrix b) {
        double result = 0.0;
        for (int i = 0; i < a.rowSize(); ++i) {
            result = Math.max(result, Vector.maxAbsDiff(a.getRow(i), b.getRow(i)));
        }
        return result;
    }

    public double get(int row, int column) {
        return this.getRow(row).get(column);
    }

    public Matrix newLeaveOneRowOut(int leaveOutRowIndex) {
        Vector[] newRows = new Vector[this.rowSize() - 1];
        int iTo = 0;
        for (int iFrom = 0; iFrom < this.rowSize(); ++iFrom) {
            if (iFrom == leaveOutRowIndex) continue;
            newRows[iTo++] = this.rows[iFrom].copy();
        }
        return new Matrix(newRows);
    }

    public Matrix newLeaveOneColumnOut(int leaveOutColumnIndex) {
        Vector[] newRows = new Vector[this.rowSize()];
        for (int i = 0; i < this.rowSize(); ++i) {
            newRows[i] = this.rows[i].newLeaveOneOut(leaveOutColumnIndex);
        }
        return new Matrix(newRows);
    }
}

