/*
 * Decompiled with CFR 0.152.
 */
package floetteroed.utilities.math;

import floetteroed.utilities.math.Matrix;
import floetteroed.utilities.math.Vector;
import floetteroed.utilities.tabularfileparser.TabularFileHandler;
import floetteroed.utilities.tabularfileparser.TabularFileParser;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class MatrixReader
implements TabularFileHandler {
    private List<Vector> currentRows = null;
    private List<Matrix> matrixList = null;

    public List<Matrix> read(String fileName) throws IOException {
        this.matrixList = null;
        this.currentRows = null;
        TabularFileParser parser = new TabularFileParser();
        parser.setDelimiterRegex("\\s");
        parser.parse(fileName, this);
        return this.matrixList;
    }

    public List<Matrix> getResult() {
        return this.matrixList;
    }

    @Override
    public void startDocument() {
        this.currentRows = new ArrayList<Vector>();
        this.matrixList = new ArrayList<Matrix>();
    }

    @Override
    public String preprocess(String line) {
        return line;
    }

    private Matrix currentRowsToMatrix() {
        Matrix result = new Matrix(this.currentRows.size(), this.currentRows.get(0).size());
        for (int i = 0; i < result.rowSize(); ++i) {
            result.getRow(i).copy(this.currentRows.get(i));
        }
        return result;
    }

    @Override
    public void startRow(String[] row) {
        if (row.length == 0) {
            if (this.currentRows.size() > 0) {
                this.matrixList.add(this.currentRowsToMatrix());
                this.currentRows = new ArrayList<Vector>();
            }
        } else {
            try {
                Vector newRow = new Vector(row.length);
                for (int i = 0; i < row.length; ++i) {
                    newRow.set(i, Double.parseDouble(row[i]));
                }
                this.currentRows.add(newRow);
            }
            catch (NumberFormatException e) {
                if (this.currentRows.size() == 0) {
                    this.matrixList.add(null);
                } else {
                    this.matrixList.add(this.currentRowsToMatrix());
                }
                this.currentRows = new ArrayList<Vector>();
            }
        }
    }

    @Override
    public void endDocument() {
        if (this.currentRows.size() > 0) {
            this.matrixList.add(this.currentRowsToMatrix());
        }
        this.currentRows = null;
    }
}

