/*
 * Decompiled with CFR 0.152.
 */
package floetteroed.utilities.math;

import floetteroed.utilities.math.Matrix;
import floetteroed.utilities.math.SignalSmoother;
import floetteroed.utilities.math.Vector;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class Regression
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final List<SignalSmoother> avgInputs;
    private double offset = 0.0;
    private Vector coefficients;
    private Matrix precisionMatrix;
    private double inertia;

    public Regression(double inertia, Vector coefficients, Matrix precisionMatrix) {
        if (coefficients == null) {
            throw new IllegalArgumentException("initial coefficent vector is null");
        }
        if (precisionMatrix == null) {
            throw new IllegalArgumentException("precisionMatrix is null");
        }
        if (precisionMatrix.rowSize() != coefficients.size() || precisionMatrix.columnSize() != coefficients.size()) {
            throw new IllegalArgumentException("dimension of precision matrix is inconsistent with size of coefficient vector");
        }
        this.avgInputs = new ArrayList<SignalSmoother>(coefficients.size());
        for (int i = 0; i < coefficients.size(); ++i) {
            this.avgInputs.add(null);
        }
        this.setInertia(inertia);
        this.coefficients = coefficients;
        this.precisionMatrix = precisionMatrix;
    }

    public Regression(double inertia, int dim) {
        this(inertia, new Vector(dim), Matrix.newDiagonal(dim, 1000000.0));
    }

    public void appendParameters(int enlargement) {
        this.coefficients = this.coefficients.copyEnlarged(enlargement);
        this.precisionMatrix = this.precisionMatrix.copyEnlarged(enlargement, enlargement);
        for (int i = this.coefficients.size() - enlargement; i < this.coefficients.size(); ++i) {
            this.precisionMatrix.getRow(i).set(i, 1000000.0);
        }
    }

    public void enableInputCentering(int i) {
        SignalSmoother avgInput = new SignalSmoother(1.0 - this.inertia);
        if (this.inertia == 1.0) {
            avgInput.freeze();
        }
        this.avgInputs.set(i, avgInput);
    }

    public Vector getCoefficients() {
        return this.coefficients;
    }

    public Matrix getPrecisionMatrix() {
        return this.precisionMatrix;
    }

    public void setInertia(double inertia) {
        if (inertia <= 0.0 || inertia > 1.0) {
            throw new IllegalArgumentException("lambda must be in (0,1]");
        }
        this.inertia = inertia;
        for (int i = 0; i < this.avgInputs.size(); ++i) {
            SignalSmoother avgInput = this.avgInputs.get(i);
            if (avgInput == null) continue;
            if (inertia < 1.0) {
                avgInput.setInnovationWeight(1.0 - inertia);
                continue;
            }
            avgInput.freeze();
        }
    }

    public double getInertia() {
        return this.inertia;
    }

    public int getDimension() {
        return this.getCoefficients().size();
    }

    private Vector input(Vector x, boolean update) {
        Vector result = x.copy();
        for (int i = 0; i < this.avgInputs.size(); ++i) {
            SignalSmoother avgInput = this.avgInputs.get(i);
            if (avgInput == null) continue;
            if (update) {
                double oldAvgInput = avgInput.getSmoothedValue();
                avgInput.addValue(x.get(i));
                this.offset += this.coefficients.get(i) * (avgInput.getSmoothedValue() - oldAvgInput);
            }
            result.add(i, -avgInput.getSmoothedValue());
        }
        return result;
    }

    public double predict(Vector x) {
        return this.input(x, false).innerProd(this.getCoefficients()) + this.offset;
    }

    public void update(Vector x, double y) {
        Vector xCentered = this.input(x, true);
        Vector xP = this.precisionMatrix.timesVectorFromLeft(xCentered);
        double gScale = 1.0 / (this.inertia + xP.innerProd(xCentered));
        this.getCoefficients().add(xP, ((y -= this.offset) - xCentered.innerProd(this.getCoefficients())) * gScale);
        this.precisionMatrix.addOuterProduct(xP, xP, -gScale);
        this.precisionMatrix.mult(1.0 / this.inertia);
        this.precisionMatrix.symmetrize();
    }
}

