/*
 * Decompiled with CFR 0.152.
 */
package floetteroed.utilities.math;

import floetteroed.utilities.math.SignalSmoothingWeight;
import java.io.Serializable;

public class SignalSmoother
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final SignalSmoothingWeight smoothingWeight;
    private double smoothedValue = 0.0;

    public SignalSmoother(double innovationWeight) {
        this.smoothingWeight = new SignalSmoothingWeight(innovationWeight);
    }

    public void setInnovationWeight(double innovationWeight) {
        this.smoothingWeight.setInnovationWeight(innovationWeight);
    }

    public void freeze() {
        this.smoothingWeight.freeze();
    }

    public boolean isFrozen() {
        return this.smoothingWeight.isFrozen();
    }

    public double getLastInnovationWeight() {
        return this.smoothingWeight.getLastInnovationWeight();
    }

    public double addValue(double value) {
        double w = this.smoothingWeight.getNextInnovationWeight();
        this.smoothedValue = (1.0 - w) * this.smoothedValue + w * value;
        return this.getSmoothedValue();
    }

    public double getSmoothedValue() {
        return this.smoothedValue;
    }
}

