/*
 * Decompiled with CFR 0.152.
 */
package floetteroed.utilities.math;

import floetteroed.utilities.math.MathHelpers;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;

public class Vector
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final double[] data;
    private final boolean immutable;

    private Vector(double[] data, boolean immutable) {
        if (data == null) {
            throw new IllegalArgumentException("data must not be null");
        }
        if (data.length < 1) {
            throw new IllegalArgumentException("dimension must be strictly positive");
        }
        this.data = data;
        this.immutable = immutable;
    }

    public Vector(int dim) {
        this(dim < 0 ? null : new double[dim], false);
    }

    public Vector(double ... data) {
        this(data, false);
    }

    public Vector(List<Double> data) {
        this(data == null ? null : new double[data.size()], false);
        if (data != null) {
            for (int i = 0; i < data.size(); ++i) {
                this.data[i] = data.get(i);
            }
        }
    }

    public Vector(int[] data) {
        this(data.length);
        for (int i = 0; i < data.length; ++i) {
            this.set(i, data[i]);
        }
    }

    public static Vector newGaussian(int dim, Random rnd) {
        if (rnd == null) {
            rnd = new Random();
        }
        Vector result = new Vector(dim);
        for (int i = 0; i < dim; ++i) {
            result.set(i, rnd.nextGaussian());
        }
        return result;
    }

    public static Vector newGaussian(int dim) {
        return Vector.newGaussian(dim, null);
    }

    public static Vector newBernoulli(int dim, Random rnd) {
        Vector result = new Vector(dim);
        for (int i = 0; i < dim; ++i) {
            result.set(i, rnd.nextBoolean() ? 1.0 : -1.0);
        }
        return result;
    }

    public static Vector newBernoulli(int dim) {
        return Vector.newBernoulli(dim, new Random());
    }

    public Vector copyEnlarged(int enlargement) {
        if (enlargement < 0) {
            throw new IllegalArgumentException("negative enlargment is not possible");
        }
        Vector result = new Vector(this.data.length + enlargement);
        System.arraycopy(this.data, 0, result.data, 0, this.data.length);
        return result;
    }

    public Vector copy() {
        return this.copyEnlarged(0);
    }

    public Vector newImmutableView() {
        return new Vector(this.data, true);
    }

    private void checkImmutable() {
        if (this.immutable) {
            throw new UnsupportedOperationException("immutable Vector cannot be changed");
        }
    }

    public void copy(Vector other) {
        this.checkImmutable();
        System.arraycopy(other.data, 0, this.data, 0, Math.min(this.size(), other.size()));
    }

    public void fill(double value) {
        this.checkImmutable();
        Arrays.fill(this.data, value);
    }

    public void clear() {
        this.checkImmutable();
        this.fill(0.0);
    }

    public void set(int pos, double value) {
        this.checkImmutable();
        this.data[pos] = value;
    }

    public void add(int pos, double value) {
        this.checkImmutable();
        int n = pos;
        this.data[n] = this.data[n] + value;
    }

    public void add(Vector other, double weight) {
        this.checkImmutable();
        if (this.size() != other.size()) {
            throw new IllegalArgumentException("vectors must be of same dimensions: this.size()=" + this.size() + ", other.size()=" + other.size());
        }
        for (int i = 0; i < this.size(); ++i) {
            this.add(i, weight * other.get(i));
        }
    }

    public void mult(int pos, double value) {
        this.checkImmutable();
        int n = pos;
        this.data[n] = this.data[n] * value;
    }

    public void mult(double value) {
        this.checkImmutable();
        for (int i = 0; i < this.size(); ++i) {
            this.mult(i, value);
        }
    }

    public void normalize() {
        this.checkImmutable();
        this.mult(1.0 / this.euclNorm());
    }

    public void round(int decimals) {
        this.checkImmutable();
        double scale = Math.pow(10.0, decimals);
        for (int i = 0; i < this.size(); ++i) {
            this.data[i] = (double)Math.round(this.data[i] * scale) / scale;
        }
    }

    public void enforceBounds(double lower, double upper) {
        this.checkImmutable();
        for (int i = 0; i < this.size(); ++i) {
            this.data[i] = Math.max(lower, Math.min(upper, this.data[i]));
        }
    }

    public boolean isImmutable() {
        return this.immutable;
    }

    public int size() {
        return this.data.length;
    }

    public double get(int pos) {
        return this.data[pos];
    }

    public double min() {
        double result = Double.POSITIVE_INFINITY;
        for (double x : this.data) {
            result = Math.min(result, x);
        }
        return result;
    }

    public double max() {
        double result = Double.NEGATIVE_INFINITY;
        for (double x : this.data) {
            result = Math.max(result, x);
        }
        return result;
    }

    public double innerProd(Vector other) {
        if (this.size() != other.size()) {
            throw new IllegalArgumentException("vectors must be of same dimensions");
        }
        double result = 0.0;
        for (int i = 0; i < this.size(); ++i) {
            result += this.get(i) * other.get(i);
        }
        return result;
    }

    public double euclNorm() {
        return Math.sqrt(this.innerProd(this));
    }

    public double sum() {
        double result = 0.0;
        for (double a : this.data) {
            result += a;
        }
        return result;
    }

    public double absValueSum() {
        double result = 0.0;
        for (int i = 0; i < this.data.length; ++i) {
            result += Math.abs(this.data[i]);
        }
        return result;
    }

    public boolean isAllZeros() {
        for (int i = 0; i < this.data.length; ++i) {
            if (this.data[i] == 0.0) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("[ ");
        for (int i = 0; i < this.size(); ++i) {
            result.append(this.get(i) + " ");
        }
        result.append("]");
        return result.toString();
    }

    public boolean isNaN() {
        for (int i = 0; i < this.data.length; ++i) {
            if (!Double.isNaN(this.data[i])) continue;
            return true;
        }
        return false;
    }

    public List<Double> asList() {
        ArrayList<Double> result = new ArrayList<Double>(this.size());
        double[] dArray = this.data;
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            Double x = dArray[i];
            result.add(x);
        }
        return result;
    }

    public void add(Vector addend) {
        this.add(addend, 1.0);
    }

    public Vector subVector(int from, int to) {
        double[] newData = new double[to - from];
        System.arraycopy(this.data, from, newData, 0, to - from);
        return new Vector(newData, false);
    }

    public static Vector newUniformLowerUpper(Vector lower, Vector upper, Random rnd) {
        Vector result = new Vector(lower.size());
        for (int i = 0; i < result.size(); ++i) {
            double u = rnd.nextDouble();
            result.set(i, (1.0 - u) * lower.get(i) + u * upper.get(i));
        }
        return result;
    }

    public static Vector newUniformCenterWidth(Vector center, Vector width, Random rnd) {
        Vector result = new Vector(center.size());
        for (int i = 0; i < result.size(); ++i) {
            result.set(i, center.get(i) + (rnd.nextDouble() - 0.5) * width.get(i));
        }
        return result;
    }

    public void makeProbability() {
        double sum = 0.0;
        for (int i = 0; i < this.size(); ++i) {
            if (this.data[i] < 0.0) {
                this.data[i] = 0.0;
                continue;
            }
            if (this.data[i] > 1.0) {
                this.data[i] = 1.0;
                sum += 1.0;
                continue;
            }
            sum += this.data[i];
        }
        this.mult(1.0 / sum);
    }

    public static double maxAbsDiff(Vector a, Vector b) {
        double result = 0.0;
        for (int i = 0; i < a.size(); ++i) {
            result = Math.max(result, Math.abs(a.get(i) - b.get(i)));
        }
        return result;
    }

    public static final double cov(Vector a, Vector b) {
        double n = a.size();
        return a.innerProd(b) / (n - 1.0) - a.sum() * b.sum() / n / (n - 1.0);
    }

    public Vector akf(int maxShift) {
        maxShift = Math.min(maxShift, this.size() - 2);
        Vector result = new Vector(maxShift + 1);
        for (int shift = 0; shift <= maxShift; ++shift) {
            Vector a = this.subVector(0, this.size() - shift);
            Vector b = this.subVector(shift, this.size());
            result.set(shift, Vector.cov(a, b));
        }
        return result;
    }

    public Vector newSample(double rate) {
        ArrayList<Double> resultList = new ArrayList<Double>();
        for (int i = 0; i < this.data.length; ++i) {
            if (!(Math.random() < rate)) continue;
            resultList.add(this.data[i]);
        }
        return new Vector(resultList);
    }

    public static Vector newUniformDistr(int dim) {
        Vector result = new Vector(dim);
        result.fill(1.0 / (double)dim);
        return result;
    }

    public Vector newLeaveOneOut(int leaveOutIndex) {
        double[] newData = new double[this.size() - 1];
        System.arraycopy(this.data, 0, newData, 0, leaveOutIndex);
        System.arraycopy(this.data, leaveOutIndex + 1, newData, leaveOutIndex, this.size() - (leaveOutIndex + 1));
        return new Vector(newData);
    }

    public static Vector concat(List<Vector> elements) {
        int size = 0;
        for (Vector element : elements) {
            size += element.size();
        }
        double[] newData = new double[size];
        int i = 0;
        for (Vector element : elements) {
            System.arraycopy(element.data, 0, newData, i, element.size());
            i += element.size();
        }
        return new Vector(newData);
    }

    public static Vector concat(Vector ... elements) {
        return Vector.concat(Arrays.asList(elements));
    }

    public double mean() {
        return this.sum() / (double)this.size();
    }

    public static Vector sum(Vector ... addends) {
        Vector result = addends[0].copy();
        for (int i = 1; i < addends.length; ++i) {
            result.add(addends[i]);
        }
        return result;
    }

    public static Vector diff(Vector a, Vector b) {
        Vector result = a.copy();
        result.add(b, -1.0);
        return result;
    }

    public static Vector min(Vector ... args) {
        Vector result = args[0].copy();
        for (int argIndex = 1; argIndex < args.length; ++argIndex) {
            for (int i = 0; i < result.size(); ++i) {
                result.data[i] = Math.min(result.data[i], args[argIndex].data[i]);
            }
        }
        return result;
    }

    public static Vector max(Vector ... args) {
        Vector result = args[0].copy();
        for (int argIndex = 1; argIndex < args.length; ++argIndex) {
            for (int i = 0; i < result.size(); ++i) {
                result.data[i] = Math.max(result.data[i], args[argIndex].data[i]);
            }
        }
        return result;
    }

    public void constrain(Vector min, Vector max) {
        for (int i = 0; i < this.size(); ++i) {
            this.data[i] = MathHelpers.projectOnInterval(this.data[i], min.data[i], max.data[i]);
        }
    }

    public String toStringCSV() {
        StringBuffer result = new StringBuffer(Double.toString(this.data[0]));
        for (int i = 1; i < this.data.length; ++i) {
            result.append(",");
            result.append(Double.toString(this.data[i]));
        }
        return result.toString();
    }

    public double[] toArray() {
        double[] result = new double[this.data.length];
        System.arraycopy(this.data, 0, result, 0, this.data.length);
        return result;
    }
}

