/*
 * Decompiled with CFR 0.152.
 */
package floetteroed.utilities.networks.basic;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.xml.sax.Attributes;

public class BasicNetworkElement {
    private final String id;
    private final int hashCode;
    private final Map<String, String> key2key = new LinkedHashMap<String, String>();
    private final Map<String, String> key2attr = new LinkedHashMap<String, String>();

    public BasicNetworkElement(String id) {
        if (id == null) {
            throw new IllegalArgumentException("id is null");
        }
        this.id = id;
        this.hashCode = id.hashCode();
    }

    BasicNetworkElement(BasicNetworkElement parent) {
        this.id = parent.id;
        this.hashCode = parent.hashCode;
        this.key2key.putAll(parent.key2key);
        this.key2attr.putAll(parent.key2attr);
    }

    private String finalKey(String key) {
        while (this.key2key.containsKey(key)) {
            key = this.key2key.get(key);
        }
        return key;
    }

    public void setAttrs(Attributes attrs, String ... exceptionKeys) {
        List<String> exceptionKeyList = exceptionKeys == null ? new ArrayList<String>(0) : Arrays.asList(exceptionKeys);
        for (int i = 0; i < attrs.getLength(); ++i) {
            String key = attrs.getQName(i);
            if (exceptionKeyList.contains(key)) continue;
            this.setAttr(key, attrs.getValue(i));
        }
    }

    public void setAttr(String key, String value) {
        this.key2attr.put(this.finalKey(key), value);
    }

    public void redirectKey(String newKey, String existingKey) {
        this.key2key.put(newKey, existingKey);
    }

    public Map<String, String> getKey2AttributeView() {
        return Collections.unmodifiableMap(this.key2attr);
    }

    public String getId() {
        return this.id;
    }

    public String getAttr(String key) {
        return this.key2attr.get(this.finalKey(key));
    }

    public boolean equals(Object o) {
        try {
            if (o == null || !o.getClass().equals(this.getClass())) {
                return false;
            }
            BasicNetworkElement other = (BasicNetworkElement)o;
            return this.id.equals(other.id);
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append(this.getClass().getSimpleName());
        result.append("(id = ");
        result.append(this.id);
        result.append(", attributes = ");
        result.append(this.key2attr.toString());
        result.append(")");
        return result.toString();
    }
}

