/*
 * Decompiled with CFR 0.152.
 */
package floetteroed.utilities.networks.construction;

import floetteroed.utilities.networks.construction.AbstractLink;
import floetteroed.utilities.networks.construction.AbstractNetwork;
import floetteroed.utilities.networks.construction.AbstractNode;
import floetteroed.utilities.networks.construction.AttributeContainer;
import floetteroed.utilities.networks.construction.NetworkContainer;
import floetteroed.utilities.networks.construction.NetworkPostprocessor;
import java.util.Map;

public abstract class AbstractNetworkFactory<N extends AbstractNode<N, L>, L extends AbstractLink<N, L>, NET extends AbstractNetwork<N, L>> {
    private NetworkPostprocessor<NET> postProcessor;

    protected abstract NET newNetwork(String var1, String var2);

    protected abstract N newNode(String var1);

    protected abstract L newLink(String var1);

    public void setNetworkPostprocessor(NetworkPostprocessor<NET> postProcessor) {
        this.postProcessor = postProcessor;
    }

    public NetworkPostprocessor<NET> getNetworkPostprocessor() {
        return this.postProcessor;
    }

    public NET newNetwork(NetworkContainer container) {
        NET newNetwork = this.newNetwork(container.networkId, container.networkType);
        ((AttributeContainer)newNetwork).setAttributes(container.networkAttributes);
        ((AbstractNetwork)newNetwork).setNodesAttributes(container.nodeSetAttributes);
        ((AbstractNetwork)newNetwork).setLinksAttributes(container.linkSetAttributes);
        for (Map.Entry<String, Map<String, String>> nodeId2Attributes : container.nodeId2Attributes.entrySet()) {
            N newNode = this.newNode(nodeId2Attributes.getKey());
            ((AttributeContainer)newNode).setAttributes(nodeId2Attributes.getValue());
            ((AbstractNetwork)newNetwork).addNode(newNode);
        }
        for (Map.Entry<String, Map<String, String>> linkId2Attributes : container.linkId2Attributes.entrySet()) {
            String linkId = linkId2Attributes.getKey();
            L newLink = this.newLink(linkId);
            ((AttributeContainer)newLink).setAttributes(linkId2Attributes.getValue());
            ((AbstractNetwork)newNetwork).addLink(newLink);
            Object fromNode = ((AbstractNetwork)newNetwork).getNode(container.linkId2fromNodeId.get(linkId));
            Object toNode = ((AbstractNetwork)newNetwork).getNode(container.linkId2toNodeId.get(linkId));
            AbstractNetwork.connect(fromNode, toNode, newLink);
        }
        if (this.postProcessor != null) {
            this.postProcessor.run(newNetwork);
        }
        return newNetwork;
    }
}

