/*
 * Decompiled with CFR 0.152.
 */
package floetteroed.utilities.networks.construction;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class NetworkContainer {
    protected final String networkId;
    protected final String networkType;
    protected final Map<String, String> networkAttributes = new LinkedHashMap<String, String>();
    protected final Map<String, String> nodeSetAttributes = new LinkedHashMap<String, String>();
    protected final Map<String, String> linkSetAttributes = new LinkedHashMap<String, String>();
    protected final Map<String, Map<String, String>> nodeId2Attributes = new HashMap<String, Map<String, String>>();
    protected final Map<String, Map<String, String>> linkId2Attributes = new HashMap<String, Map<String, String>>();
    protected final Map<String, String> linkId2fromNodeId = new LinkedHashMap<String, String>();
    protected final Map<String, String> linkId2toNodeId = new LinkedHashMap<String, String>();

    public NetworkContainer(String networkId, String networkType) {
        this.networkId = networkId;
        this.networkType = networkType;
    }

    public void putNetworkAttribute(String key, String value) {
        this.networkAttributes.put(key, value);
    }

    public void putNodeSetAttribute(String key, String value) {
        this.nodeSetAttributes.put(key, value);
    }

    public void putLinkSetAttribute(String key, String value) {
        this.linkSetAttributes.put(key, value);
    }

    public void putNode(String nodeId) {
        if (!this.nodeId2Attributes.containsKey(nodeId)) {
            this.nodeId2Attributes.put(nodeId, new LinkedHashMap());
        }
    }

    public void putLink(String linkId) {
        if (!this.linkId2Attributes.containsKey(linkId)) {
            this.linkId2Attributes.put(linkId, new LinkedHashMap());
        }
    }

    public void putNodeAttribute(String nodeId, String key, String value) {
        Map<String, String> attributes = this.nodeId2Attributes.get(nodeId);
        if (attributes == null) {
            attributes = new LinkedHashMap<String, String>();
            this.nodeId2Attributes.put(nodeId, attributes);
        }
        attributes.put(key, value);
    }

    public void putLinkAttribute(String linkId, String key, String value) {
        Map<String, String> attributes = this.linkId2Attributes.get(linkId);
        if (attributes == null) {
            attributes = new LinkedHashMap<String, String>();
            this.linkId2Attributes.put(linkId, attributes);
        }
        attributes.put(key, value);
    }

    public void setFromNode(String linkId, String fromNodeId) {
        this.linkId2fromNodeId.put(linkId, fromNodeId);
    }

    public void setToNode(String linkId, String toNodeId) {
        this.linkId2toNodeId.put(linkId, toNodeId);
    }

    public String getNetworkId() {
        return this.networkId;
    }

    public String getNetworkType() {
        return this.networkType;
    }

    public String getFromNodeId(String linkId) {
        return this.linkId2fromNodeId.get(linkId);
    }

    public String getToNodeId(String linkId) {
        return this.linkId2toNodeId.get(linkId);
    }

    public String getNodeAttribute(String nodeId, String key) {
        return this.nodeId2Attributes.get(nodeId).get(key);
    }

    public String getLinkAttribute(String linkId, String key) {
        return this.linkId2Attributes.get(linkId).get(key);
    }

    public boolean containsLink(String linkId) {
        return this.linkId2Attributes.containsKey(linkId);
    }
}

