/*
 * Decompiled with CFR 0.152.
 */
package floetteroed.utilities.networks.containerloaders;

import floetteroed.utilities.IdentifiedElementParser;
import floetteroed.utilities.networks.construction.NetworkContainer;
import java.util.Map;
import org.xml.sax.Attributes;

public class SUMONetworkContainerLoader {
    public static final String SUMO_NETWORK_TYPE = "SUMO";
    public static final String NODE_ELEMENT = "node";
    public static final String NODE_ID_ATTRIBUTE = "id";
    public static final String EDGE_ELEMENT = "edge";
    public static final String EDGE_ID_ATTRIBUTE = "id";
    public static final String EDGE_FROMNODE_ATTRIBUTE = "fromnode";
    public static final String EDGE_TONODE_ATTRIBUTE = "tonode";
    public static final String CONNECTION_ELEMENT = "connection";
    public static final String CONNECTION_FROM_ATTRIBUTE = "from";
    public static final String CONNECTION_TO_ATTRIBUTE = "to";

    public NetworkContainer loadNetworkContainer(String nodeFile, String edgeFile, String connectionFile) {
        if (nodeFile == null) {
            throw new IllegalArgumentException("node file is null");
        }
        if (edgeFile == null) {
            throw new IllegalArgumentException("edge file is null");
        }
        NetworkContainer container = new NetworkContainer("SUMO-Network", SUMO_NETWORK_TYPE);
        Map<String, Attributes> nodeId2Attrs = new IdentifiedElementParser(NODE_ELEMENT, "id").readId2AttrsMap(nodeFile);
        for (Map.Entry<String, Attributes> entry : nodeId2Attrs.entrySet()) {
            String string = entry.getKey();
            Attributes attrs = entry.getValue();
            container.putNode(string);
            for (int i = 0; i < attrs.getLength(); ++i) {
                container.putNodeAttribute(string, attrs.getQName(i), attrs.getValue(i));
            }
        }
        Map<String, Attributes> edgeId2Attrs = new IdentifiedElementParser(EDGE_ELEMENT, "id").readId2AttrsMap(edgeFile);
        for (Map.Entry<String, Attributes> entry : edgeId2Attrs.entrySet()) {
            String linkId = entry.getKey();
            Attributes attrs = entry.getValue();
            container.putLink(linkId);
            container.setFromNode(linkId, attrs.getValue(EDGE_FROMNODE_ATTRIBUTE));
            container.setToNode(linkId, attrs.getValue(EDGE_TONODE_ATTRIBUTE));
            for (int i = 0; i < attrs.getLength(); ++i) {
                container.putLinkAttribute(linkId, attrs.getQName(i), attrs.getValue(i));
            }
        }
        if (connectionFile != null) {
            Map<String, Attributes> map = new IdentifiedElementParser(CONNECTION_ELEMENT, null).readId2AttrsMap(connectionFile);
            for (Attributes attrs : map.values()) {
                String fromLinkId;
                String oldSuccessors = container.getLinkAttribute(fromLinkId = attrs.getValue(CONNECTION_FROM_ATTRIBUTE), "successors");
                container.putLinkAttribute(fromLinkId, "successors", (String)(oldSuccessors == null ? "" : oldSuccessors + " ") + attrs.getValue(CONNECTION_TO_ATTRIBUTE));
            }
        }
        return container;
    }
}

