/*
 * Decompiled with CFR 0.152.
 */
package floetteroed.utilities.networks.shortestpaths;

import floetteroed.utilities.networks.basic.BasicLink;
import floetteroed.utilities.networks.basic.BasicNode;
import floetteroed.utilities.networks.shortestpaths.LinkCost;
import java.util.Collection;

public class LinkCostExcludingNodes
implements LinkCost {
    private final LinkCost linkCost;
    private final Collection<BasicNode> excludedNodes;

    public LinkCostExcludingNodes(LinkCost linkCost, Collection<BasicNode> excludedNodes) {
        if (linkCost == null) {
            throw new IllegalArgumentException("linkCost is null");
        }
        if (excludedNodes == null) {
            throw new IllegalArgumentException("excludedNodes is null");
        }
        this.linkCost = linkCost;
        this.excludedNodes = excludedNodes;
    }

    @Override
    public double getCost(BasicLink link) {
        if (this.excludedNodes.contains(link.getFromNode()) || this.excludedNodes.contains(link.getToNode())) {
            return Double.POSITIVE_INFINITY;
        }
        return this.linkCost.getCost(link);
    }
}

