/*
 * Decompiled with CFR 0.152.
 */
package floetteroed.utilities.statisticslogging;

import floetteroed.utilities.statisticslogging.Statistic;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class StatisticsWriter<D> {
    private final String fileName;
    private final List<Statistic<D>> statistics = new ArrayList<Statistic<D>>();
    private boolean wroteHeader = false;

    public StatisticsWriter(String fileName, boolean append) {
        this.fileName = fileName;
        this.wroteHeader = append;
    }

    public void addSearchStatistic(Statistic<D> statistic) {
        this.statistics.add(statistic);
    }

    public String getFileName() {
        return this.fileName;
    }

    public void writeToFile(D data, String ... labelOverrideValueSequence) {
        LinkedHashMap<String, String> label2overrideValue = new LinkedHashMap<String, String>();
        if (labelOverrideValueSequence != null) {
            for (int i = 0; i < labelOverrideValueSequence.length; i += 2) {
                label2overrideValue.put(labelOverrideValueSequence[i], labelOverrideValueSequence[i + 1]);
            }
        }
        this.writeToFile(data, label2overrideValue);
    }

    public void writeToFile(D data, Map<String, String> label2overrideValue) {
        try {
            BufferedWriter writer;
            if (!this.wroteHeader) {
                writer = new BufferedWriter(new FileWriter(this.fileName, false));
                for (Statistic<D> stat : this.statistics) {
                    writer.write(stat.label() + "\t");
                }
                writer.newLine();
                this.wroteHeader = true;
            } else {
                writer = new BufferedWriter(new FileWriter(this.fileName, true));
            }
            for (Statistic<D> stat : this.statistics) {
                if (label2overrideValue.containsKey(stat.label())) {
                    writer.write(label2overrideValue.get(stat.label()));
                } else {
                    String value;
                    try {
                        value = stat.value(data);
                    }
                    catch (Exception e) {
                        value = "";
                    }
                    writer.write(value);
                }
                writer.write("\t");
            }
            writer.newLine();
            writer.flush();
            writer.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

