/*
 * Decompiled with CFR 0.152.
 */
package floetteroed.utilities.visualization;

import floetteroed.utilities.visualization.NetJComponent;
import floetteroed.utilities.visualization.VisConfig;
import floetteroed.utilities.visualization.VisNetwork;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;

abstract class AbstractRenderer {
    private final VisConfig visConfig;
    private final VisNetwork net;
    private NetJComponent component;
    private AbstractRenderer prev;

    AbstractRenderer(VisConfig visConfig, VisNetwork net) {
        this.visConfig = visConfig;
        this.net = net;
        this.component = null;
        this.prev = null;
    }

    void append(AbstractRenderer rendererBelow) {
        if (this.prev == null) {
            this.prev = rendererBelow;
        } else {
            this.prev.append(rendererBelow);
        }
    }

    void render(Graphics2D display, AffineTransform boxTransform) {
        if (this.prev != null) {
            this.prev.render(display, boxTransform);
        }
        if (this.component != null) {
            this.myRendering(display, boxTransform);
        }
    }

    void setComponent(NetJComponent component) {
        if (this.prev != null) {
            this.prev.setComponent(component);
        }
        this.component = component;
    }

    NetJComponent getComponent() {
        return this.component;
    }

    VisConfig getVisConfig() {
        return this.visConfig;
    }

    VisNetwork getNetwork() {
        return this.net;
    }

    abstract void myRendering(Graphics2D var1, AffineTransform var2);
}

