/*
 * Decompiled with CFR 0.152.
 */
package floetteroed.utilities.visualization;

import floetteroed.utilities.visualization.AbstractRenderer;
import floetteroed.utilities.visualization.NetJComponent;
import floetteroed.utilities.visualization.VisConfig;
import floetteroed.utilities.visualization.VisLink;
import floetteroed.utilities.visualization.VisNetwork;
import floetteroed.utilities.visualization.VisNode;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;

class LabelRenderer
extends AbstractRenderer {
    private final VisNetwork network;
    private final int textHeight = 12;

    LabelRenderer(VisConfig visConfig, VisNetwork network) {
        super(visConfig, network);
        this.network = network;
    }

    @Override
    void myRendering(Graphics2D display, AffineTransform boxTransform) {
        AffineTransform originalTransform = display.getTransform();
        NetJComponent comp = this.getComponent();
        if (this.getVisConfig().getShowNodeLabels()) {
            for (VisNode node : this.network.getNodes()) {
                double y;
                double x = node.getEasting();
                if (comp.checkViewClip(x, y = node.getNorthing()) != 5) continue;
                Point2D.Double point = new Point2D.Double(x, y);
                AffineTransform nodeTransform = new AffineTransform(boxTransform);
                nodeTransform.transform(point, point);
                nodeTransform = new AffineTransform(originalTransform);
                nodeTransform.translate(((Point2D)point).getX(), ((Point2D)point).getY());
                display.setTransform(nodeTransform);
                display.setFont(new Font(display.getFont().getName(), 0, 12));
                display.setColor(Color.BLACK);
                String label = node.getId().toString();
                if (label == null || "".equals(label)) continue;
                display.drawString(label, 0, 0);
            }
        }
        display.setTransform(originalTransform);
        if (this.getVisConfig().getShowLinkLabels()) {
            for (VisLink link : this.network.getLinks()) {
                double endNorthing;
                double ypos;
                double startEasting = ((VisNode)link.getFromNode()).getEasting();
                double startNorthing = ((VisNode)link.getFromNode()).getNorthing();
                double endEasting = ((VisNode)link.getToNode()).getEasting();
                double xpos = startEasting + (endEasting - startEasting) * 0.42;
                if (comp.checkViewClip(xpos, ypos = startNorthing + ((endNorthing = ((VisNode)link.getToNode()).getNorthing()) - startNorthing) * 0.42) != 5) continue;
                Point2D.Double point = new Point2D.Double(xpos, ypos);
                AffineTransform linkTransform = new AffineTransform(boxTransform);
                linkTransform.transform(point, point);
                AffineTransform linkTransform2 = new AffineTransform(originalTransform);
                linkTransform2.translate(((Point2D)point).getX(), ((Point2D)point).getY());
                double dx = endEasting - startEasting;
                double dy = endNorthing - startNorthing;
                double theta = Math.atan2(dx, dy);
                if (theta <= 0.0) {
                    linkTransform2.rotate(theta + 1.5707963267948966);
                } else {
                    linkTransform2.rotate(theta - 1.5707963267948966);
                }
                display.setTransform(linkTransform2);
                display.setFont(new Font(display.getFont().getName(), 0, 12));
                display.setColor(Color.BLACK);
                String label = link.getId().toString();
                if (label == null || "".equals(label)) continue;
                int textWidth = display.getFontMetrics().stringWidth(label);
                int yoffset = theta <= 0.0 ? -6 : 12;
                display.drawString(label, -textWidth / 2, yoffset);
            }
        }
        display.setTransform(originalTransform);
    }
}

