/*
 * Decompiled with CFR 0.152.
 */
package floetteroed.utilities.visualization;

import floetteroed.utilities.networks.construction.NetworkPostprocessor;
import floetteroed.utilities.visualization.NetVis;
import floetteroed.utilities.visualization.VisLink;
import floetteroed.utilities.visualization.VisNetwork;
import floetteroed.utilities.visualization.VisNode;

public class MATSim2VisNetwork
implements NetworkPostprocessor<VisNetwork> {
    public static final String EASTING_ATTRIBUTE = "x";
    public static final String NORTHING_ATTRIBUTE = "y";
    public static final String LANES_ATTRIBUTE = "permlanes";
    public static final String LENGTH_ATTRIBUTE = "length";
    public static final String CAPPERIOD_ATTRIBUTE = "capperiod";
    public static final String CAPACITY_PER_CAPPERIOD_ATTRIBUTE = "capacity";

    @Override
    public void run(VisNetwork network) {
        network.setMinEasting(Double.POSITIVE_INFINITY);
        network.setMaxEasting(Double.NEGATIVE_INFINITY);
        network.setMinNorthing(Double.POSITIVE_INFINITY);
        network.setMaxNorthing(Double.NEGATIVE_INFINITY);
        for (VisNode node : network.getNodes()) {
            node.setEasting(Double.parseDouble(node.getAttr(EASTING_ATTRIBUTE)));
            node.setNorthing(Double.parseDouble(node.getAttr(NORTHING_ATTRIBUTE)));
            network.setMinEasting(Math.min(network.getMinEasting(), node.getEasting()));
            network.setMaxEasting(Math.max(network.getMaxEasting(), node.getEasting()));
            network.setMinNorthing(Math.min(network.getMinNorthing(), node.getNorthing()));
            network.setMaxNorthing(Math.max(network.getMaxNorthing(), node.getNorthing()));
        }
        for (VisLink link : network.getLinks()) {
            link.setLanes((int)Math.round(Double.parseDouble(link.getAttr(LANES_ATTRIBUTE))));
            link.setLength_m(Double.parseDouble(link.getAttr(LENGTH_ATTRIBUTE)));
            link.setVisible(link.getLength_m() > 1.0);
            link.setTransform(NetVis.newLinear2PlaneTransform(link));
        }
    }
}

