/*
 * Decompiled with CFR 0.152.
 */
package floetteroed.utilities.visualization;

import floetteroed.utilities.visualization.AbstractRenderer;
import floetteroed.utilities.visualization.VisConfig;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import javax.swing.JComponent;

class NetJComponent
extends JComponent {
    private static final long serialVersionUID = 1L;
    private static final double BORDER_FACTOR = 0.0;
    private final AbstractRenderer networkRenderer;
    private final VisConfig visconfig;
    private final int frameDefaultWidth;
    private final int frameDefaultHeight;
    private double viewMinX;
    private double viewMinY;
    private double viewMaxX;
    private double viewMaxY;

    NetJComponent(AbstractRenderer networkRenderer, VisConfig visconfig) {
        this.networkRenderer = networkRenderer;
        this.visconfig = visconfig;
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        double factor = screenSize.getWidth() / this.networkClippingWidth();
        factor = Math.min(factor, screenSize.getHeight() / this.networkClippingHeight());
        this.frameDefaultWidth = (int)Math.floor(this.networkClippingWidth() * (factor *= 0.8));
        this.frameDefaultHeight = (int)Math.floor(this.networkClippingHeight() * factor);
        this.scale(1.0);
        this.setViewClipCoords(0.0, 0.0, 1.0, 1.0);
    }

    void setViewClipCoords(double minX, double minY, double maxX, double maxY) {
        this.viewMinX = this.networkClippingMinEasting() + minX * this.networkClippingWidth();
        this.viewMaxX = this.networkClippingMinEasting() + maxX * this.networkClippingWidth();
        this.viewMinY = this.networkClippingMinNorthing() + (1.0 - maxY) * this.networkClippingHeight();
        this.viewMaxY = this.networkClippingMinNorthing() + (1.0 - minY) * this.networkClippingHeight();
    }

    void moveViewClipCoords(double deltaX, double deltaY) {
        this.viewMinX += deltaX * this.networkClippingWidth();
        this.viewMaxX += deltaX * this.networkClippingWidth();
        this.viewMinY -= deltaY * this.networkClippingHeight();
        this.viewMaxY -= deltaY * this.networkClippingHeight();
    }

    int checkViewClip(double x, double y) {
        int xquart;
        int n = x < this.viewMinX ? 0 : (xquart = x > this.viewMaxX ? 2 : 1);
        int yquart = y < this.viewMinY ? 0 : (y > this.viewMaxY ? 2 : 1);
        return xquart + 4 * yquart;
    }

    boolean checkLineInClip(double sx, double sy, double ex, double ey) {
        int qend;
        int qstart = this.checkViewClip(sx, sy);
        if (qstart == (qend = this.checkViewClip(ex, ey)) && qstart != 5) {
            return false;
        }
        if (qstart % 4 == qend % 4 && qstart % 4 != 1) {
            return false;
        }
        return qstart / 4 != qend / 4 || qstart / 4 == 1;
    }

    void scale(double factor) {
        if (factor > 0.0) {
            int scaledWidth = (int)Math.round(factor * (double)this.frameDefaultWidth);
            int scaledHeight = (int)Math.round(factor * (double)this.frameDefaultHeight);
            this.setPreferredSize(new Dimension(scaledWidth, scaledHeight));
        }
    }

    private double additionalBorder() {
        return 0.1 * Math.max(this.networkRenderer.getNetwork().getMaxEasting() - this.networkRenderer.getNetwork().getMinEasting(), this.networkRenderer.getNetwork().getMaxNorthing() - this.networkRenderer.getNetwork().getMinNorthing());
    }

    private double networkClippingEastingBorder() {
        return Math.max(1.0, 0.0 * (this.networkRenderer.getNetwork().getMaxEasting() - this.networkRenderer.getNetwork().getMinEasting())) + this.additionalBorder();
    }

    private double networkClippingNorthingBorder() {
        return Math.max(1.0, 0.0 * (this.networkRenderer.getNetwork().getMaxNorthing() - this.networkRenderer.getNetwork().getMinNorthing())) + this.additionalBorder();
    }

    private double networkClippingMinEasting() {
        return this.networkRenderer.getNetwork().getMinEasting() - this.networkClippingEastingBorder();
    }

    private double networkClippingMaxEasting() {
        return this.networkRenderer.getNetwork().getMaxEasting() + this.networkClippingEastingBorder();
    }

    private double networkClippingMinNorthing() {
        return this.networkRenderer.getNetwork().getMinNorthing() - this.networkClippingNorthingBorder();
    }

    private double networkClippingMaxNorthing() {
        return this.networkRenderer.getNetwork().getMaxNorthing() + this.networkClippingNorthingBorder();
    }

    private double networkClippingWidth() {
        return this.networkClippingMaxEasting() - this.networkClippingMinEasting();
    }

    private double networkClippingHeight() {
        return this.networkClippingMaxNorthing() - this.networkClippingMinNorthing();
    }

    private AffineTransform getBoxTransform() {
        double v1 = this.networkClippingMinEasting();
        double w1 = this.networkClippingMinNorthing();
        double v2 = this.networkClippingMaxEasting();
        double w2 = this.networkClippingMaxNorthing();
        Dimension prefSize = this.getPreferredSize();
        double x1 = 0.0;
        double y1 = (int)prefSize.getHeight();
        double x2 = (int)prefSize.getWidth();
        double y2 = 0.0;
        double m00 = (0.0 - x2) / (v1 - v2);
        double m02 = 0.0 - m00 * v1;
        double m11 = (y1 - 0.0) / (w1 - w2);
        double m12 = y1 - m11 * w1;
        return new AffineTransform(m00, 0.0, 0.0, m11, m02, m12);
    }

    Point2D.Double getNetCoord(double x, double y) {
        Point2D.Double result = new Point2D.Double();
        Dimension prefSize = this.getPreferredSize();
        result.x = x / (double)prefSize.width;
        result.y = 1.0 - y / (double)prefSize.height;
        result.x *= this.networkRenderer.getNetwork().getMaxEasting() - this.networkRenderer.getNetwork().getMinEasting();
        result.y *= this.networkRenderer.getNetwork().getMaxNorthing() - this.networkRenderer.getNetwork().getMinNorthing();
        result.x += this.networkRenderer.getNetwork().getMinEasting();
        result.y += this.networkRenderer.getNetwork().getMinNorthing();
        return result;
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        if (this.visconfig.getUseAntiAliasing()) {
            g2.addRenderingHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        } else {
            g2.addRenderingHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF));
        }
        this.networkRenderer.render(g2, this.getBoxTransform());
    }
}

