/*
 * Decompiled with CFR 0.152.
 */
package floetteroed.utilities.visualization;

import floetteroed.utilities.DynamicData;
import floetteroed.utilities.ErrorMsgPrinter;
import floetteroed.utilities.config.Config;
import floetteroed.utilities.config.ConfigReader;
import floetteroed.utilities.networks.construction.NetworkContainer;
import floetteroed.utilities.networks.construction.NetworkPostprocessor;
import floetteroed.utilities.networks.containerloaders.MATSimNetworkContainerLoader;
import floetteroed.utilities.networks.containerloaders.OpenStreetMapNetworkContainerLoader;
import floetteroed.utilities.networks.containerloaders.SUMONetworkContainerLoader;
import floetteroed.utilities.visualization.LinkDataIO;
import floetteroed.utilities.visualization.MATSim2VisNetwork;
import floetteroed.utilities.visualization.NetVis;
import floetteroed.utilities.visualization.OpenStreetMap2VisNetwork;
import floetteroed.utilities.visualization.RenderableDynamicData;
import floetteroed.utilities.visualization.SUMO2VisNetwork;
import floetteroed.utilities.visualization.VisConfig;
import floetteroed.utilities.visualization.VisNetwork;
import floetteroed.utilities.visualization.VisNetworkFactory;
import java.awt.FileDialog;
import java.awt.Frame;

public class NetvisFromFileRunner {
    public static final String NETVISCONFIG_ELEMENT = "config";
    public static final String NETWORKTYPE_ELEMENT = "networktype";
    public static final String NETWORKFILENAME_ELEMENT = "networkfile";
    public static final String NODEFILE_ELEMENT = "nodefile";
    public static final String EDGEFILE_ELEMENT = "edgefile";
    public static final String CONNECTIONFILE_ELEMENT = "connectionfile";
    public static final String COLOR_ELEMENT = "color";
    public static final String DELAY_ELEMENT = "delay";
    public static final String LINKDATAFILE_ELEMENT = "linkdatafile";
    public static final String LINKWIDTH_ELEMENT = "linkwidth";
    public static final String LOGO_ELEMENT = "logo";
    public static final String MULTILANE_ELEMENT = "multilane";
    public static final String SHOWLINKLABELS_ELEMENT = "showlinklabels";
    public static final String SHOWNODELABELS_ELEMENT = "shownodelabels";
    public static final String ANTIALIASING_ELEMENT = "antialiasing";

    protected NetvisFromFileRunner() {
    }

    protected void run(String[] args) {
        try {
            RenderableDynamicData renderData;
            NetworkContainer container;
            Object configFile;
            if (args.length == 0) {
                FileDialog fileDialog = new FileDialog(new Frame(), "Select visualization configuration file.");
                fileDialog.setMode(0);
                fileDialog.setVisible(true);
                if (fileDialog.getFile() == null) {
                    return;
                }
                configFile = (fileDialog.getDirectory() == null ? "" : fileDialog.getDirectory()) + fileDialog.getFile();
            } else {
                configFile = args[0];
            }
            Config config = new ConfigReader().read((String)configFile);
            String netType = config.get(NETVISCONFIG_ELEMENT, NETWORKTYPE_ELEMENT);
            if ("OpenStreetMap".equals(netType)) {
                container = new OpenStreetMapNetworkContainerLoader().load(config.absolutePath(config.get(NETVISCONFIG_ELEMENT, NETWORKFILENAME_ELEMENT)));
            } else if ("MATSim".equals(netType)) {
                container = new MATSimNetworkContainerLoader().load(config.absolutePath(config.get(NETVISCONFIG_ELEMENT, NETWORKFILENAME_ELEMENT)));
            } else if ("SUMO".equals(netType)) {
                String nodeFile = config.absolutePath(config.get(NETVISCONFIG_ELEMENT, NODEFILE_ELEMENT));
                String edgeFile = config.absolutePath(config.get(NETVISCONFIG_ELEMENT, EDGEFILE_ELEMENT));
                String connectionFile = config.get(NETVISCONFIG_ELEMENT, CONNECTIONFILE_ELEMENT);
                if (connectionFile != null) {
                    connectionFile = config.absolutePath(connectionFile);
                }
                container = new SUMONetworkContainerLoader().loadNetworkContainer(nodeFile, edgeFile, connectionFile);
            } else {
                container = this.loadUnknownNetworkContainer(netType, config);
                if (container == null) {
                    throw new IllegalArgumentException("unknown network type");
                }
            }
            VisNetworkFactory factory = new VisNetworkFactory();
            if ("MATSim".equals(container.getNetworkType())) {
                factory.setNetworkPostprocessor(new MATSim2VisNetwork());
            } else if ("OpenStreetMap".equals(container.getNetworkType())) {
                factory.setNetworkPostprocessor(new OpenStreetMap2VisNetwork());
            } else if ("SUMO".equals(container.getNetworkType())) {
                factory.setNetworkPostprocessor(new SUMO2VisNetwork());
            } else {
                NetworkPostprocessor<VisNetwork> postprocessor = this.getUnknownNetworkPostprocessorHook();
                if (postprocessor != null) {
                    factory.setNetworkPostprocessor(postprocessor);
                } else {
                    throw new RuntimeException("unknown network type: " + container.getNetworkType());
                }
            }
            VisNetwork net = (VisNetwork)factory.newNetwork(container);
            VisConfig visConfig = new VisConfig();
            visConfig.setColorDef(config.get(NETVISCONFIG_ELEMENT, COLOR_ELEMENT));
            visConfig.setDelay_ms(Integer.parseInt(config.get(NETVISCONFIG_ELEMENT, DELAY_ELEMENT)));
            if (config.containsKeys(NETVISCONFIG_ELEMENT, LINKDATAFILE_ELEMENT)) {
                visConfig.setLinkDataFile(config.absolutePath(config.get(NETVISCONFIG_ELEMENT, LINKDATAFILE_ELEMENT)));
            }
            visConfig.setLinkWidthFactor(Integer.parseInt(config.get(NETVISCONFIG_ELEMENT, LINKWIDTH_ELEMENT)));
            visConfig.setLogo(config.get(NETVISCONFIG_ELEMENT, LOGO_ELEMENT));
            visConfig.setMultiLane(Boolean.parseBoolean(config.get(NETVISCONFIG_ELEMENT, MULTILANE_ELEMENT)));
            visConfig.setShowLinkLabels(Boolean.parseBoolean(config.get(NETVISCONFIG_ELEMENT, SHOWLINKLABELS_ELEMENT)));
            visConfig.setShowLinkLabels(Boolean.parseBoolean(config.get(NETVISCONFIG_ELEMENT, SHOWNODELABELS_ELEMENT)));
            visConfig.setUseAntiAliasing(Boolean.parseBoolean(config.get(NETVISCONFIG_ELEMENT, ANTIALIASING_ELEMENT)));
            if (visConfig.getLinkDataFile() != null) {
                LinkDataIO linkDataLoader = new LinkDataIO(net);
                DynamicData linkData = linkDataLoader.read(visConfig.getLinkDataFile());
                renderData = new RenderableDynamicData(linkData);
            } else {
                renderData = null;
            }
            NetVis vis = new NetVis(visConfig, net, renderData);
            vis.run();
        }
        catch (Exception e) {
            ErrorMsgPrinter.toStdOut(e);
            ErrorMsgPrinter.toErrOut(e);
        }
    }

    protected NetworkContainer loadUnknownNetworkContainer(String networkType, Config config) {
        return null;
    }

    protected NetworkPostprocessor<VisNetwork> getUnknownNetworkPostprocessorHook() {
        return null;
    }

    public static void main(String[] args) {
        NetvisFromFileRunner runner = new NetvisFromFileRunner();
        runner.run(args);
    }
}

