/*
 * Decompiled with CFR 0.152.
 */
package floetteroed.utilities.visualization;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.swing.JViewport;

class Printer
implements Printable {
    private final Component frame;
    private final JViewport viewPort;

    Printer(Component frame, JViewport viewPort) {
        this.frame = frame;
        this.viewPort = viewPort;
    }

    void run() {
        PrinterJob job = PrinterJob.getPrinterJob();
        job.setPrintable(this);
        boolean ok = job.printDialog();
        if (ok) {
            try {
                job.print();
            }
            catch (PrinterException printerException) {
                // empty catch block
            }
        }
    }

    @Override
    public int print(Graphics g, PageFormat pf, int page) throws PrinterException {
        if (page > 0) {
            return 1;
        }
        Graphics2D g2d = (Graphics2D)g;
        Rectangle viewRect = this.viewPort.getViewRect();
        double scale = Math.min(pf.getWidth() / (double)viewRect.width, pf.getHeight() / (double)viewRect.height);
        g2d.scale(scale, scale);
        g2d.translate(pf.getImageableX() - (double)viewRect.x, pf.getImageableY() - (double)viewRect.y);
        this.frame.printAll(g);
        return 0;
    }
}

