/*
 * Decompiled with CFR 0.152.
 */
package floetteroed.utilities.visualization;

import floetteroed.utilities.math.MathHelpers;
import floetteroed.utilities.networks.construction.NetworkPostprocessor;
import floetteroed.utilities.visualization.NetVis;
import floetteroed.utilities.visualization.VisLink;
import floetteroed.utilities.visualization.VisNetwork;
import floetteroed.utilities.visualization.VisNode;

public class SUMO2VisNetwork
implements NetworkPostprocessor<VisNetwork> {
    public static final String X_ATTRIBUTE = "x";
    public static final String Y_ATTRIBUTE = "y";
    public static final String NOLANES_ATTRIBUTE = "nolanes";

    @Override
    public void run(VisNetwork network) {
        network.setMinEasting(Double.POSITIVE_INFINITY);
        network.setMaxEasting(Double.NEGATIVE_INFINITY);
        network.setMinNorthing(Double.POSITIVE_INFINITY);
        network.setMaxNorthing(Double.NEGATIVE_INFINITY);
        for (VisNode node : network.getNodes()) {
            node.setEasting(Double.parseDouble(node.getAttr(X_ATTRIBUTE)));
            node.setNorthing(Double.parseDouble(node.getAttr(Y_ATTRIBUTE)));
            network.setMinEasting(Math.min(network.getMinEasting(), node.getEasting()));
            network.setMaxEasting(Math.max(network.getMaxEasting(), node.getEasting()));
            network.setMinNorthing(Math.min(network.getMinNorthing(), node.getNorthing()));
            network.setMaxNorthing(Math.max(network.getMaxNorthing(), node.getNorthing()));
        }
        for (VisLink link : network.getLinks()) {
            link.setLanes((int)Math.round(Double.parseDouble(link.getAttr(NOLANES_ATTRIBUTE))));
            link.setLength_m(MathHelpers.length(((VisNode)link.getFromNode()).getEasting(), ((VisNode)link.getFromNode()).getNorthing(), ((VisNode)link.getToNode()).getEasting(), ((VisNode)link.getToNode()).getNorthing()));
            link.setVisible(true);
            link.setTransform(NetVis.newLinear2PlaneTransform(link));
        }
    }
}

