/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sumo.libtraci;

import org.eclipse.sumo.libtraci.ContextSubscriptionResults;
import org.eclipse.sumo.libtraci.IntVector;
import org.eclipse.sumo.libtraci.StringStringPair;
import org.eclipse.sumo.libtraci.StringVector;
import org.eclipse.sumo.libtraci.SubscriptionResults;
import org.eclipse.sumo.libtraci.TraCIResults;
import org.eclipse.sumo.libtraci.libtraciJNI;

public class RouteProbe {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected RouteProbe(long cPtr, boolean cMemoryOwn) {
        this.swigCMemOwn = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(RouteProbe obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    protected static long swigRelease(RouteProbe obj) {
        long ptr = 0L;
        if (obj != null) {
            if (!obj.swigCMemOwn) {
                throw new RuntimeException("Cannot release ownership as memory is not owned");
            }
            ptr = obj.swigCPtr;
            obj.swigCMemOwn = false;
            obj.delete();
        }
        return ptr;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                libtraciJNI.delete_RouteProbe(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public static String getEdgeID(String probeID) {
        return libtraciJNI.RouteProbe_getEdgeID(probeID);
    }

    public static String sampleLastRouteID(String probeID) {
        return libtraciJNI.RouteProbe_sampleLastRouteID(probeID);
    }

    public static String sampleCurrentRouteID(String probeID) {
        return libtraciJNI.RouteProbe_sampleCurrentRouteID(probeID);
    }

    public static StringVector getIDList() {
        return new StringVector(libtraciJNI.RouteProbe_getIDList(), true);
    }

    public static int getIDCount() {
        return libtraciJNI.RouteProbe_getIDCount();
    }

    public static String getParameter(String objectID, String key) {
        return libtraciJNI.RouteProbe_getParameter(objectID, key);
    }

    public static StringStringPair getParameterWithKey(String objectID, String key) {
        return new StringStringPair(libtraciJNI.RouteProbe_getParameterWithKey(objectID, key), true);
    }

    public static void setParameter(String objectID, String key, String value) {
        libtraciJNI.RouteProbe_setParameter(objectID, key, value);
    }

    public static void subscribe(String objectID, IntVector varIDs, double begin, double end, TraCIResults parameters) {
        libtraciJNI.RouteProbe_subscribe__SWIG_0(objectID, IntVector.getCPtr(varIDs), varIDs, begin, end, TraCIResults.getCPtr(parameters), parameters);
    }

    public static void subscribe(String objectID, IntVector varIDs, double begin, double end) {
        libtraciJNI.RouteProbe_subscribe__SWIG_1(objectID, IntVector.getCPtr(varIDs), varIDs, begin, end);
    }

    public static void subscribe(String objectID, IntVector varIDs, double begin) {
        libtraciJNI.RouteProbe_subscribe__SWIG_2(objectID, IntVector.getCPtr(varIDs), varIDs, begin);
    }

    public static void subscribe(String objectID, IntVector varIDs) {
        libtraciJNI.RouteProbe_subscribe__SWIG_3(objectID, IntVector.getCPtr(varIDs), varIDs);
    }

    public static void subscribe(String objectID) {
        libtraciJNI.RouteProbe_subscribe__SWIG_4(objectID);
    }

    public static void unsubscribe(String objectID) {
        libtraciJNI.RouteProbe_unsubscribe(objectID);
    }

    public static void subscribeContext(String objectID, int domain, double dist, IntVector varIDs, double begin, double end, TraCIResults parameters) {
        libtraciJNI.RouteProbe_subscribeContext__SWIG_0(objectID, domain, dist, IntVector.getCPtr(varIDs), varIDs, begin, end, TraCIResults.getCPtr(parameters), parameters);
    }

    public static void subscribeContext(String objectID, int domain, double dist, IntVector varIDs, double begin, double end) {
        libtraciJNI.RouteProbe_subscribeContext__SWIG_1(objectID, domain, dist, IntVector.getCPtr(varIDs), varIDs, begin, end);
    }

    public static void subscribeContext(String objectID, int domain, double dist, IntVector varIDs, double begin) {
        libtraciJNI.RouteProbe_subscribeContext__SWIG_2(objectID, domain, dist, IntVector.getCPtr(varIDs), varIDs, begin);
    }

    public static void subscribeContext(String objectID, int domain, double dist, IntVector varIDs) {
        libtraciJNI.RouteProbe_subscribeContext__SWIG_3(objectID, domain, dist, IntVector.getCPtr(varIDs), varIDs);
    }

    public static void subscribeContext(String objectID, int domain, double dist) {
        libtraciJNI.RouteProbe_subscribeContext__SWIG_4(objectID, domain, dist);
    }

    public static void unsubscribeContext(String objectID, int domain, double dist) {
        libtraciJNI.RouteProbe_unsubscribeContext(objectID, domain, dist);
    }

    public static SubscriptionResults getAllSubscriptionResults() {
        return new SubscriptionResults(libtraciJNI.RouteProbe_getAllSubscriptionResults(), true);
    }

    public static TraCIResults getSubscriptionResults(String objectID) {
        return new TraCIResults(libtraciJNI.RouteProbe_getSubscriptionResults(objectID), true);
    }

    public static ContextSubscriptionResults getAllContextSubscriptionResults() {
        return new ContextSubscriptionResults(libtraciJNI.RouteProbe_getAllContextSubscriptionResults(), true);
    }

    public static SubscriptionResults getContextSubscriptionResults(String objectID) {
        return new SubscriptionResults(libtraciJNI.RouteProbe_getContextSubscriptionResults(objectID), true);
    }

    public static void subscribeParameterWithKey(String objectID, String key, double beginTime, double endTime) {
        libtraciJNI.RouteProbe_subscribeParameterWithKey__SWIG_0(objectID, key, beginTime, endTime);
    }

    public static void subscribeParameterWithKey(String objectID, String key, double beginTime) {
        libtraciJNI.RouteProbe_subscribeParameterWithKey__SWIG_1(objectID, key, beginTime);
    }

    public static void subscribeParameterWithKey(String objectID, String key) {
        libtraciJNI.RouteProbe_subscribeParameterWithKey__SWIG_2(objectID, key);
    }

    public static int getDOMAIN_ID() {
        return libtraciJNI.RouteProbe_DOMAIN_ID_get();
    }

    public static int domainID() {
        return libtraciJNI.RouteProbe_domainID();
    }
}

