/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sumo.libsumo;

import org.eclipse.sumo.libsumo.ContextSubscriptionResults;
import org.eclipse.sumo.libsumo.IntVector;
import org.eclipse.sumo.libsumo.StringStringPair;
import org.eclipse.sumo.libsumo.StringVector;
import org.eclipse.sumo.libsumo.SubscriptionResults;
import org.eclipse.sumo.libsumo.TraCIPosition;
import org.eclipse.sumo.libsumo.TraCIPositionVector;
import org.eclipse.sumo.libsumo.TraCIResults;
import org.eclipse.sumo.libsumo.libsumoJNI;

public class Junction {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected Junction(long cPtr, boolean cMemoryOwn) {
        this.swigCMemOwn = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(Junction obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    protected static long swigRelease(Junction obj) {
        long ptr = 0L;
        if (obj != null) {
            if (!obj.swigCMemOwn) {
                throw new RuntimeException("Cannot release ownership as memory is not owned");
            }
            ptr = obj.swigCPtr;
            obj.swigCMemOwn = false;
            obj.delete();
        }
        return ptr;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                libsumoJNI.delete_Junction(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public static TraCIPosition getPosition(String junctionID, boolean includeZ) {
        return new TraCIPosition(libsumoJNI.Junction_getPosition__SWIG_0(junctionID, includeZ), true);
    }

    public static TraCIPosition getPosition(String junctionID) {
        return new TraCIPosition(libsumoJNI.Junction_getPosition__SWIG_1(junctionID), true);
    }

    public static TraCIPositionVector getShape(String junctionID) {
        return new TraCIPositionVector(libsumoJNI.Junction_getShape(junctionID), true);
    }

    public static StringVector getIncomingEdges(String junctionID) {
        return new StringVector(libsumoJNI.Junction_getIncomingEdges(junctionID), true);
    }

    public static StringVector getOutgoingEdges(String junctionID) {
        return new StringVector(libsumoJNI.Junction_getOutgoingEdges(junctionID), true);
    }

    public static StringVector getIDList() {
        return new StringVector(libsumoJNI.Junction_getIDList(), true);
    }

    public static int getIDCount() {
        return libsumoJNI.Junction_getIDCount();
    }

    public static String getParameter(String objectID, String key) {
        return libsumoJNI.Junction_getParameter(objectID, key);
    }

    public static StringStringPair getParameterWithKey(String objectID, String key) {
        return new StringStringPair(libsumoJNI.Junction_getParameterWithKey(objectID, key), true);
    }

    public static void setParameter(String objectID, String key, String value) {
        libsumoJNI.Junction_setParameter(objectID, key, value);
    }

    public static void subscribe(String objectID, IntVector varIDs, double begin, double end, TraCIResults parameters) {
        libsumoJNI.Junction_subscribe__SWIG_0(objectID, IntVector.getCPtr(varIDs), varIDs, begin, end, TraCIResults.getCPtr(parameters), parameters);
    }

    public static void subscribe(String objectID, IntVector varIDs, double begin, double end) {
        libsumoJNI.Junction_subscribe__SWIG_1(objectID, IntVector.getCPtr(varIDs), varIDs, begin, end);
    }

    public static void subscribe(String objectID, IntVector varIDs, double begin) {
        libsumoJNI.Junction_subscribe__SWIG_2(objectID, IntVector.getCPtr(varIDs), varIDs, begin);
    }

    public static void subscribe(String objectID, IntVector varIDs) {
        libsumoJNI.Junction_subscribe__SWIG_3(objectID, IntVector.getCPtr(varIDs), varIDs);
    }

    public static void subscribe(String objectID) {
        libsumoJNI.Junction_subscribe__SWIG_4(objectID);
    }

    public static void unsubscribe(String objectID) {
        libsumoJNI.Junction_unsubscribe(objectID);
    }

    public static void subscribeContext(String objectID, int domain, double dist, IntVector varIDs, double begin, double end, TraCIResults parameters) {
        libsumoJNI.Junction_subscribeContext__SWIG_0(objectID, domain, dist, IntVector.getCPtr(varIDs), varIDs, begin, end, TraCIResults.getCPtr(parameters), parameters);
    }

    public static void subscribeContext(String objectID, int domain, double dist, IntVector varIDs, double begin, double end) {
        libsumoJNI.Junction_subscribeContext__SWIG_1(objectID, domain, dist, IntVector.getCPtr(varIDs), varIDs, begin, end);
    }

    public static void subscribeContext(String objectID, int domain, double dist, IntVector varIDs, double begin) {
        libsumoJNI.Junction_subscribeContext__SWIG_2(objectID, domain, dist, IntVector.getCPtr(varIDs), varIDs, begin);
    }

    public static void subscribeContext(String objectID, int domain, double dist, IntVector varIDs) {
        libsumoJNI.Junction_subscribeContext__SWIG_3(objectID, domain, dist, IntVector.getCPtr(varIDs), varIDs);
    }

    public static void subscribeContext(String objectID, int domain, double dist) {
        libsumoJNI.Junction_subscribeContext__SWIG_4(objectID, domain, dist);
    }

    public static void unsubscribeContext(String objectID, int domain, double dist) {
        libsumoJNI.Junction_unsubscribeContext(objectID, domain, dist);
    }

    public static SubscriptionResults getAllSubscriptionResults() {
        return new SubscriptionResults(libsumoJNI.Junction_getAllSubscriptionResults(), true);
    }

    public static TraCIResults getSubscriptionResults(String objectID) {
        return new TraCIResults(libsumoJNI.Junction_getSubscriptionResults(objectID), true);
    }

    public static ContextSubscriptionResults getAllContextSubscriptionResults() {
        return new ContextSubscriptionResults(libsumoJNI.Junction_getAllContextSubscriptionResults(), true);
    }

    public static SubscriptionResults getContextSubscriptionResults(String objectID) {
        return new SubscriptionResults(libsumoJNI.Junction_getContextSubscriptionResults(objectID), true);
    }

    public static void subscribeParameterWithKey(String objectID, String key, double beginTime, double endTime) {
        libsumoJNI.Junction_subscribeParameterWithKey__SWIG_0(objectID, key, beginTime, endTime);
    }

    public static void subscribeParameterWithKey(String objectID, String key, double beginTime) {
        libsumoJNI.Junction_subscribeParameterWithKey__SWIG_1(objectID, key, beginTime);
    }

    public static void subscribeParameterWithKey(String objectID, String key) {
        libsumoJNI.Junction_subscribeParameterWithKey__SWIG_2(objectID, key);
    }

    public static int getDOMAIN_ID() {
        return libsumoJNI.Junction_DOMAIN_ID_get();
    }

    public static int domainID() {
        return libsumoJNI.Junction_domainID();
    }
}

