/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sumo.libsumo;

import org.eclipse.sumo.libsumo.ContextSubscriptionResults;
import org.eclipse.sumo.libsumo.IntIntPair;
import org.eclipse.sumo.libsumo.IntVector;
import org.eclipse.sumo.libsumo.StringDoublePair;
import org.eclipse.sumo.libsumo.StringDoublePairVector;
import org.eclipse.sumo.libsumo.StringStringPair;
import org.eclipse.sumo.libsumo.StringVector;
import org.eclipse.sumo.libsumo.SubscriptionResults;
import org.eclipse.sumo.libsumo.TraCIBestLanesDataVector;
import org.eclipse.sumo.libsumo.TraCIColor;
import org.eclipse.sumo.libsumo.TraCIConnectionVector;
import org.eclipse.sumo.libsumo.TraCIJunctionFoeVector;
import org.eclipse.sumo.libsumo.TraCINextStopDataVector;
import org.eclipse.sumo.libsumo.TraCINextTLSVector;
import org.eclipse.sumo.libsumo.TraCIPosition;
import org.eclipse.sumo.libsumo.TraCIResults;
import org.eclipse.sumo.libsumo.libsumoJNI;

public class Vehicle {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected Vehicle(long cPtr, boolean cMemoryOwn) {
        this.swigCMemOwn = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(Vehicle obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    protected static long swigRelease(Vehicle obj) {
        long ptr = 0L;
        if (obj != null) {
            if (!obj.swigCMemOwn) {
                throw new RuntimeException("Cannot release ownership as memory is not owned");
            }
            ptr = obj.swigCPtr;
            obj.swigCMemOwn = false;
            obj.delete();
        }
        return ptr;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                libsumoJNI.delete_Vehicle(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public static double getSpeed(String vehID) {
        return libsumoJNI.Vehicle_getSpeed(vehID);
    }

    public static double getLateralSpeed(String vehID) {
        return libsumoJNI.Vehicle_getLateralSpeed(vehID);
    }

    public static double getAcceleration(String vehID) {
        return libsumoJNI.Vehicle_getAcceleration(vehID);
    }

    public static double getSpeedWithoutTraCI(String vehID) {
        return libsumoJNI.Vehicle_getSpeedWithoutTraCI(vehID);
    }

    public static TraCIPosition getPosition(String vehID, boolean includeZ) {
        return new TraCIPosition(libsumoJNI.Vehicle_getPosition__SWIG_0(vehID, includeZ), true);
    }

    public static TraCIPosition getPosition(String vehID) {
        return new TraCIPosition(libsumoJNI.Vehicle_getPosition__SWIG_1(vehID), true);
    }

    public static TraCIPosition getPosition3D(String vehID) {
        return new TraCIPosition(libsumoJNI.Vehicle_getPosition3D(vehID), true);
    }

    public static double getAngle(String vehID) {
        return libsumoJNI.Vehicle_getAngle(vehID);
    }

    public static double getSlope(String vehID) {
        return libsumoJNI.Vehicle_getSlope(vehID);
    }

    public static String getRoadID(String vehID) {
        return libsumoJNI.Vehicle_getRoadID(vehID);
    }

    public static String getLaneID(String vehID) {
        return libsumoJNI.Vehicle_getLaneID(vehID);
    }

    public static int getLaneIndex(String vehID) {
        return libsumoJNI.Vehicle_getLaneIndex(vehID);
    }

    public static String getSegmentID(String vehID) {
        return libsumoJNI.Vehicle_getSegmentID(vehID);
    }

    public static int getSegmentIndex(String vehID) {
        return libsumoJNI.Vehicle_getSegmentIndex(vehID);
    }

    public static String getTypeID(String vehID) {
        return libsumoJNI.Vehicle_getTypeID(vehID);
    }

    public static String getRouteID(String vehID) {
        return libsumoJNI.Vehicle_getRouteID(vehID);
    }

    public static double getDeparture(String vehID) {
        return libsumoJNI.Vehicle_getDeparture(vehID);
    }

    public static double getDepartDelay(String vehID) {
        return libsumoJNI.Vehicle_getDepartDelay(vehID);
    }

    public static int getRouteIndex(String vehID) {
        return libsumoJNI.Vehicle_getRouteIndex(vehID);
    }

    public static double getLanePosition(String vehID) {
        return libsumoJNI.Vehicle_getLanePosition(vehID);
    }

    public static double getLateralLanePosition(String vehID) {
        return libsumoJNI.Vehicle_getLateralLanePosition(vehID);
    }

    public static double getCO2Emission(String vehID) {
        return libsumoJNI.Vehicle_getCO2Emission(vehID);
    }

    public static double getCOEmission(String vehID) {
        return libsumoJNI.Vehicle_getCOEmission(vehID);
    }

    public static double getHCEmission(String vehID) {
        return libsumoJNI.Vehicle_getHCEmission(vehID);
    }

    public static double getPMxEmission(String vehID) {
        return libsumoJNI.Vehicle_getPMxEmission(vehID);
    }

    public static double getNOxEmission(String vehID) {
        return libsumoJNI.Vehicle_getNOxEmission(vehID);
    }

    public static double getFuelConsumption(String vehID) {
        return libsumoJNI.Vehicle_getFuelConsumption(vehID);
    }

    public static double getNoiseEmission(String vehID) {
        return libsumoJNI.Vehicle_getNoiseEmission(vehID);
    }

    public static double getElectricityConsumption(String vehID) {
        return libsumoJNI.Vehicle_getElectricityConsumption(vehID);
    }

    public static int getPersonNumber(String vehID) {
        return libsumoJNI.Vehicle_getPersonNumber(vehID);
    }

    public static StringVector getPersonIDList(String vehID) {
        return new StringVector(libsumoJNI.Vehicle_getPersonIDList(vehID), true);
    }

    public static StringDoublePair getLeader(String vehID, double dist) {
        return new StringDoublePair(libsumoJNI.Vehicle_getLeader__SWIG_0(vehID, dist), true);
    }

    public static StringDoublePair getLeader(String vehID) {
        return new StringDoublePair(libsumoJNI.Vehicle_getLeader__SWIG_1(vehID), true);
    }

    public static StringDoublePair getFollower(String vehID, double dist) {
        return new StringDoublePair(libsumoJNI.Vehicle_getFollower__SWIG_0(vehID, dist), true);
    }

    public static StringDoublePair getFollower(String vehID) {
        return new StringDoublePair(libsumoJNI.Vehicle_getFollower__SWIG_1(vehID), true);
    }

    public static TraCIJunctionFoeVector getJunctionFoes(String vehID, double dist) {
        return new TraCIJunctionFoeVector(libsumoJNI.Vehicle_getJunctionFoes__SWIG_0(vehID, dist), true);
    }

    public static TraCIJunctionFoeVector getJunctionFoes(String vehID) {
        return new TraCIJunctionFoeVector(libsumoJNI.Vehicle_getJunctionFoes__SWIG_1(vehID), true);
    }

    public static double getWaitingTime(String vehID) {
        return libsumoJNI.Vehicle_getWaitingTime(vehID);
    }

    public static double getAccumulatedWaitingTime(String vehID) {
        return libsumoJNI.Vehicle_getAccumulatedWaitingTime(vehID);
    }

    public static double getAdaptedTraveltime(String vehID, double time, String edgeID) {
        return libsumoJNI.Vehicle_getAdaptedTraveltime(vehID, time, edgeID);
    }

    public static double getEffort(String vehID, double time, String edgeID) {
        return libsumoJNI.Vehicle_getEffort(vehID, time, edgeID);
    }

    public static boolean isRouteValid(String vehID) {
        return libsumoJNI.Vehicle_isRouteValid(vehID);
    }

    public static StringVector getRoute(String vehID) {
        return new StringVector(libsumoJNI.Vehicle_getRoute(vehID), true);
    }

    public static int getSignals(String vehID) {
        return libsumoJNI.Vehicle_getSignals(vehID);
    }

    public static TraCIBestLanesDataVector getBestLanes(String vehID) {
        return new TraCIBestLanesDataVector(libsumoJNI.Vehicle_getBestLanes(vehID), true);
    }

    public static TraCINextTLSVector getNextTLS(String vehID) {
        return new TraCINextTLSVector(libsumoJNI.Vehicle_getNextTLS(vehID), true);
    }

    public static TraCINextStopDataVector getNextStops(String vehID) {
        return new TraCINextStopDataVector(libsumoJNI.Vehicle_getNextStops(vehID), true);
    }

    public static TraCIConnectionVector getNextLinks(String vehID) {
        return new TraCIConnectionVector(libsumoJNI.Vehicle_getNextLinks(vehID), true);
    }

    public static TraCINextStopDataVector getStops(String vehID, int limit) {
        return new TraCINextStopDataVector(libsumoJNI.Vehicle_getStops__SWIG_0(vehID, limit), true);
    }

    public static TraCINextStopDataVector getStops(String vehID) {
        return new TraCINextStopDataVector(libsumoJNI.Vehicle_getStops__SWIG_1(vehID), true);
    }

    public static int getStopState(String vehID) {
        return libsumoJNI.Vehicle_getStopState(vehID);
    }

    public static String getStopParameter(String vehID, int nextStopIndex, String param, boolean customParam) {
        return libsumoJNI.Vehicle_getStopParameter__SWIG_0(vehID, nextStopIndex, param, customParam);
    }

    public static String getStopParameter(String vehID, int nextStopIndex, String param) {
        return libsumoJNI.Vehicle_getStopParameter__SWIG_1(vehID, nextStopIndex, param);
    }

    public static double getDistance(String vehID) {
        return libsumoJNI.Vehicle_getDistance(vehID);
    }

    public static double getDrivingDistance(String vehID, String edgeID, double pos, int laneIndex) {
        return libsumoJNI.Vehicle_getDrivingDistance__SWIG_0(vehID, edgeID, pos, laneIndex);
    }

    public static double getDrivingDistance(String vehID, String edgeID, double pos) {
        return libsumoJNI.Vehicle_getDrivingDistance__SWIG_1(vehID, edgeID, pos);
    }

    public static double getDrivingDistance2D(String vehID, double x, double y) {
        return libsumoJNI.Vehicle_getDrivingDistance2D(vehID, x, y);
    }

    public static double getAllowedSpeed(String vehID) {
        return libsumoJNI.Vehicle_getAllowedSpeed(vehID);
    }

    public static int getSpeedMode(String vehID) {
        return libsumoJNI.Vehicle_getSpeedMode(vehID);
    }

    public static int getLaneChangeMode(String vehID) {
        return libsumoJNI.Vehicle_getLaneChangeMode(vehID);
    }

    public static int getRoutingMode(String vehID) {
        return libsumoJNI.Vehicle_getRoutingMode(vehID);
    }

    public static String getLine(String vehID) {
        return libsumoJNI.Vehicle_getLine(vehID);
    }

    public static StringVector getVia(String vehID) {
        return new StringVector(libsumoJNI.Vehicle_getVia(vehID), true);
    }

    public static IntIntPair getLaneChangeState(String vehID, int direction) {
        return new IntIntPair(libsumoJNI.Vehicle_getLaneChangeState(vehID, direction), true);
    }

    public static double getLastActionTime(String vehID) {
        return libsumoJNI.Vehicle_getLastActionTime(vehID);
    }

    public static StringDoublePairVector getNeighbors(String vehID, int mode) {
        return new StringDoublePairVector(libsumoJNI.Vehicle_getNeighbors(vehID, mode), true);
    }

    public static double getFollowSpeed(String vehID, double speed, double gap, double leaderSpeed, double leaderMaxDecel, String leaderID) {
        return libsumoJNI.Vehicle_getFollowSpeed__SWIG_0(vehID, speed, gap, leaderSpeed, leaderMaxDecel, leaderID);
    }

    public static double getFollowSpeed(String vehID, double speed, double gap, double leaderSpeed, double leaderMaxDecel) {
        return libsumoJNI.Vehicle_getFollowSpeed__SWIG_1(vehID, speed, gap, leaderSpeed, leaderMaxDecel);
    }

    public static double getSecureGap(String vehID, double speed, double leaderSpeed, double leaderMaxDecel, String leaderID) {
        return libsumoJNI.Vehicle_getSecureGap__SWIG_0(vehID, speed, leaderSpeed, leaderMaxDecel, leaderID);
    }

    public static double getSecureGap(String vehID, double speed, double leaderSpeed, double leaderMaxDecel) {
        return libsumoJNI.Vehicle_getSecureGap__SWIG_1(vehID, speed, leaderSpeed, leaderMaxDecel);
    }

    public static double getStopSpeed(String vehID, double speed, double gap) {
        return libsumoJNI.Vehicle_getStopSpeed(vehID, speed, gap);
    }

    public static double getStopDelay(String vehID) {
        return libsumoJNI.Vehicle_getStopDelay(vehID);
    }

    public static double getStopArrivalDelay(String vehID) {
        return libsumoJNI.Vehicle_getStopArrivalDelay(vehID);
    }

    public static double getTimeLoss(String vehID) {
        return libsumoJNI.Vehicle_getTimeLoss(vehID);
    }

    public static StringVector getTaxiFleet(int taxiState) {
        return new StringVector(libsumoJNI.Vehicle_getTaxiFleet__SWIG_0(taxiState), true);
    }

    public static StringVector getTaxiFleet() {
        return new StringVector(libsumoJNI.Vehicle_getTaxiFleet__SWIG_1(), true);
    }

    public static StringVector getLoadedIDList() {
        return new StringVector(libsumoJNI.Vehicle_getLoadedIDList(), true);
    }

    public static StringVector getTeleportingIDList() {
        return new StringVector(libsumoJNI.Vehicle_getTeleportingIDList(), true);
    }

    public static StringVector getIDList() {
        return new StringVector(libsumoJNI.Vehicle_getIDList(), true);
    }

    public static int getIDCount() {
        return libsumoJNI.Vehicle_getIDCount();
    }

    public static String getParameter(String objectID, String key) {
        return libsumoJNI.Vehicle_getParameter(objectID, key);
    }

    public static StringStringPair getParameterWithKey(String objectID, String key) {
        return new StringStringPair(libsumoJNI.Vehicle_getParameterWithKey(objectID, key), true);
    }

    public static void setParameter(String objectID, String key, String value) {
        libsumoJNI.Vehicle_setParameter(objectID, key, value);
    }

    public static double getLength(String typeID) {
        return libsumoJNI.Vehicle_getLength(typeID);
    }

    public static double getMaxSpeed(String typeID) {
        return libsumoJNI.Vehicle_getMaxSpeed(typeID);
    }

    public static String getVehicleClass(String typeID) {
        return libsumoJNI.Vehicle_getVehicleClass(typeID);
    }

    public static double getSpeedFactor(String typeID) {
        return libsumoJNI.Vehicle_getSpeedFactor(typeID);
    }

    public static double getAccel(String typeID) {
        return libsumoJNI.Vehicle_getAccel(typeID);
    }

    public static double getDecel(String typeID) {
        return libsumoJNI.Vehicle_getDecel(typeID);
    }

    public static double getEmergencyDecel(String typeID) {
        return libsumoJNI.Vehicle_getEmergencyDecel(typeID);
    }

    public static double getApparentDecel(String typeID) {
        return libsumoJNI.Vehicle_getApparentDecel(typeID);
    }

    public static double getImperfection(String typeID) {
        return libsumoJNI.Vehicle_getImperfection(typeID);
    }

    public static double getTau(String typeID) {
        return libsumoJNI.Vehicle_getTau(typeID);
    }

    public static String getEmissionClass(String typeID) {
        return libsumoJNI.Vehicle_getEmissionClass(typeID);
    }

    public static String getShapeClass(String typeID) {
        return libsumoJNI.Vehicle_getShapeClass(typeID);
    }

    public static double getMinGap(String typeID) {
        return libsumoJNI.Vehicle_getMinGap(typeID);
    }

    public static double getWidth(String typeID) {
        return libsumoJNI.Vehicle_getWidth(typeID);
    }

    public static double getHeight(String typeID) {
        return libsumoJNI.Vehicle_getHeight(typeID);
    }

    public static double getMass(String typeID) {
        return libsumoJNI.Vehicle_getMass(typeID);
    }

    public static TraCIColor getColor(String typeID) {
        return new TraCIColor(libsumoJNI.Vehicle_getColor(typeID), true);
    }

    public static double getMinGapLat(String typeID) {
        return libsumoJNI.Vehicle_getMinGapLat(typeID);
    }

    public static double getMaxSpeedLat(String typeID) {
        return libsumoJNI.Vehicle_getMaxSpeedLat(typeID);
    }

    public static String getLateralAlignment(String typeID) {
        return libsumoJNI.Vehicle_getLateralAlignment(typeID);
    }

    public static int getPersonCapacity(String typeID) {
        return libsumoJNI.Vehicle_getPersonCapacity(typeID);
    }

    public static double getActionStepLength(String typeID) {
        return libsumoJNI.Vehicle_getActionStepLength(typeID);
    }

    public static double getSpeedDeviation(String typeID) {
        return libsumoJNI.Vehicle_getSpeedDeviation(typeID);
    }

    public static double getBoardingDuration(String typeID) {
        return libsumoJNI.Vehicle_getBoardingDuration(typeID);
    }

    public static double getImpatience(String typeID) {
        return libsumoJNI.Vehicle_getImpatience(typeID);
    }

    public static void setStop(String vehID, String edgeID, double pos, int laneIndex, double duration, int flags, double startPos, double until) {
        libsumoJNI.Vehicle_setStop__SWIG_0(vehID, edgeID, pos, laneIndex, duration, flags, startPos, until);
    }

    public static void setStop(String vehID, String edgeID, double pos, int laneIndex, double duration, int flags, double startPos) {
        libsumoJNI.Vehicle_setStop__SWIG_1(vehID, edgeID, pos, laneIndex, duration, flags, startPos);
    }

    public static void setStop(String vehID, String edgeID, double pos, int laneIndex, double duration, int flags) {
        libsumoJNI.Vehicle_setStop__SWIG_2(vehID, edgeID, pos, laneIndex, duration, flags);
    }

    public static void setStop(String vehID, String edgeID, double pos, int laneIndex, double duration) {
        libsumoJNI.Vehicle_setStop__SWIG_3(vehID, edgeID, pos, laneIndex, duration);
    }

    public static void setStop(String vehID, String edgeID, double pos, int laneIndex) {
        libsumoJNI.Vehicle_setStop__SWIG_4(vehID, edgeID, pos, laneIndex);
    }

    public static void setStop(String vehID, String edgeID, double pos) {
        libsumoJNI.Vehicle_setStop__SWIG_5(vehID, edgeID, pos);
    }

    public static void setStop(String vehID, String edgeID) {
        libsumoJNI.Vehicle_setStop__SWIG_6(vehID, edgeID);
    }

    public static void replaceStop(String vehID, int nextStopIndex, String edgeID, double pos, int laneIndex, double duration, int flags, double startPos, double until, int teleport) {
        libsumoJNI.Vehicle_replaceStop__SWIG_0(vehID, nextStopIndex, edgeID, pos, laneIndex, duration, flags, startPos, until, teleport);
    }

    public static void replaceStop(String vehID, int nextStopIndex, String edgeID, double pos, int laneIndex, double duration, int flags, double startPos, double until) {
        libsumoJNI.Vehicle_replaceStop__SWIG_1(vehID, nextStopIndex, edgeID, pos, laneIndex, duration, flags, startPos, until);
    }

    public static void replaceStop(String vehID, int nextStopIndex, String edgeID, double pos, int laneIndex, double duration, int flags, double startPos) {
        libsumoJNI.Vehicle_replaceStop__SWIG_2(vehID, nextStopIndex, edgeID, pos, laneIndex, duration, flags, startPos);
    }

    public static void replaceStop(String vehID, int nextStopIndex, String edgeID, double pos, int laneIndex, double duration, int flags) {
        libsumoJNI.Vehicle_replaceStop__SWIG_3(vehID, nextStopIndex, edgeID, pos, laneIndex, duration, flags);
    }

    public static void replaceStop(String vehID, int nextStopIndex, String edgeID, double pos, int laneIndex, double duration) {
        libsumoJNI.Vehicle_replaceStop__SWIG_4(vehID, nextStopIndex, edgeID, pos, laneIndex, duration);
    }

    public static void replaceStop(String vehID, int nextStopIndex, String edgeID, double pos, int laneIndex) {
        libsumoJNI.Vehicle_replaceStop__SWIG_5(vehID, nextStopIndex, edgeID, pos, laneIndex);
    }

    public static void replaceStop(String vehID, int nextStopIndex, String edgeID, double pos) {
        libsumoJNI.Vehicle_replaceStop__SWIG_6(vehID, nextStopIndex, edgeID, pos);
    }

    public static void replaceStop(String vehID, int nextStopIndex, String edgeID) {
        libsumoJNI.Vehicle_replaceStop__SWIG_7(vehID, nextStopIndex, edgeID);
    }

    public static void insertStop(String vehID, int nextStopIndex, String edgeID, double pos, int laneIndex, double duration, int flags, double startPos, double until, int teleport) {
        libsumoJNI.Vehicle_insertStop__SWIG_0(vehID, nextStopIndex, edgeID, pos, laneIndex, duration, flags, startPos, until, teleport);
    }

    public static void insertStop(String vehID, int nextStopIndex, String edgeID, double pos, int laneIndex, double duration, int flags, double startPos, double until) {
        libsumoJNI.Vehicle_insertStop__SWIG_1(vehID, nextStopIndex, edgeID, pos, laneIndex, duration, flags, startPos, until);
    }

    public static void insertStop(String vehID, int nextStopIndex, String edgeID, double pos, int laneIndex, double duration, int flags, double startPos) {
        libsumoJNI.Vehicle_insertStop__SWIG_2(vehID, nextStopIndex, edgeID, pos, laneIndex, duration, flags, startPos);
    }

    public static void insertStop(String vehID, int nextStopIndex, String edgeID, double pos, int laneIndex, double duration, int flags) {
        libsumoJNI.Vehicle_insertStop__SWIG_3(vehID, nextStopIndex, edgeID, pos, laneIndex, duration, flags);
    }

    public static void insertStop(String vehID, int nextStopIndex, String edgeID, double pos, int laneIndex, double duration) {
        libsumoJNI.Vehicle_insertStop__SWIG_4(vehID, nextStopIndex, edgeID, pos, laneIndex, duration);
    }

    public static void insertStop(String vehID, int nextStopIndex, String edgeID, double pos, int laneIndex) {
        libsumoJNI.Vehicle_insertStop__SWIG_5(vehID, nextStopIndex, edgeID, pos, laneIndex);
    }

    public static void insertStop(String vehID, int nextStopIndex, String edgeID, double pos) {
        libsumoJNI.Vehicle_insertStop__SWIG_6(vehID, nextStopIndex, edgeID, pos);
    }

    public static void insertStop(String vehID, int nextStopIndex, String edgeID) {
        libsumoJNI.Vehicle_insertStop__SWIG_7(vehID, nextStopIndex, edgeID);
    }

    public static void setStopParameter(String vehID, int nextStopIndex, String param, String value, boolean customParam) {
        libsumoJNI.Vehicle_setStopParameter__SWIG_0(vehID, nextStopIndex, param, value, customParam);
    }

    public static void setStopParameter(String vehID, int nextStopIndex, String param, String value) {
        libsumoJNI.Vehicle_setStopParameter__SWIG_1(vehID, nextStopIndex, param, value);
    }

    public static void rerouteParkingArea(String vehID, String parkingAreaID) {
        libsumoJNI.Vehicle_rerouteParkingArea(vehID, parkingAreaID);
    }

    public static void resume(String vehID) {
        libsumoJNI.Vehicle_resume(vehID);
    }

    public static void add(String vehID, String routeID, String typeID, String depart, String departLane, String departPos, String departSpeed, String arrivalLane, String arrivalPos, String arrivalSpeed, String fromTaz, String toTaz, String line, int personCapacity, int personNumber) {
        libsumoJNI.Vehicle_add__SWIG_0(vehID, routeID, typeID, depart, departLane, departPos, departSpeed, arrivalLane, arrivalPos, arrivalSpeed, fromTaz, toTaz, line, personCapacity, personNumber);
    }

    public static void add(String vehID, String routeID, String typeID, String depart, String departLane, String departPos, String departSpeed, String arrivalLane, String arrivalPos, String arrivalSpeed, String fromTaz, String toTaz, String line, int personCapacity) {
        libsumoJNI.Vehicle_add__SWIG_1(vehID, routeID, typeID, depart, departLane, departPos, departSpeed, arrivalLane, arrivalPos, arrivalSpeed, fromTaz, toTaz, line, personCapacity);
    }

    public static void add(String vehID, String routeID, String typeID, String depart, String departLane, String departPos, String departSpeed, String arrivalLane, String arrivalPos, String arrivalSpeed, String fromTaz, String toTaz, String line) {
        libsumoJNI.Vehicle_add__SWIG_2(vehID, routeID, typeID, depart, departLane, departPos, departSpeed, arrivalLane, arrivalPos, arrivalSpeed, fromTaz, toTaz, line);
    }

    public static void add(String vehID, String routeID, String typeID, String depart, String departLane, String departPos, String departSpeed, String arrivalLane, String arrivalPos, String arrivalSpeed, String fromTaz, String toTaz) {
        libsumoJNI.Vehicle_add__SWIG_3(vehID, routeID, typeID, depart, departLane, departPos, departSpeed, arrivalLane, arrivalPos, arrivalSpeed, fromTaz, toTaz);
    }

    public static void add(String vehID, String routeID, String typeID, String depart, String departLane, String departPos, String departSpeed, String arrivalLane, String arrivalPos, String arrivalSpeed, String fromTaz) {
        libsumoJNI.Vehicle_add__SWIG_4(vehID, routeID, typeID, depart, departLane, departPos, departSpeed, arrivalLane, arrivalPos, arrivalSpeed, fromTaz);
    }

    public static void add(String vehID, String routeID, String typeID, String depart, String departLane, String departPos, String departSpeed, String arrivalLane, String arrivalPos, String arrivalSpeed) {
        libsumoJNI.Vehicle_add__SWIG_5(vehID, routeID, typeID, depart, departLane, departPos, departSpeed, arrivalLane, arrivalPos, arrivalSpeed);
    }

    public static void add(String vehID, String routeID, String typeID, String depart, String departLane, String departPos, String departSpeed, String arrivalLane, String arrivalPos) {
        libsumoJNI.Vehicle_add__SWIG_6(vehID, routeID, typeID, depart, departLane, departPos, departSpeed, arrivalLane, arrivalPos);
    }

    public static void add(String vehID, String routeID, String typeID, String depart, String departLane, String departPos, String departSpeed, String arrivalLane) {
        libsumoJNI.Vehicle_add__SWIG_7(vehID, routeID, typeID, depart, departLane, departPos, departSpeed, arrivalLane);
    }

    public static void add(String vehID, String routeID, String typeID, String depart, String departLane, String departPos, String departSpeed) {
        libsumoJNI.Vehicle_add__SWIG_8(vehID, routeID, typeID, depart, departLane, departPos, departSpeed);
    }

    public static void add(String vehID, String routeID, String typeID, String depart, String departLane, String departPos) {
        libsumoJNI.Vehicle_add__SWIG_9(vehID, routeID, typeID, depart, departLane, departPos);
    }

    public static void add(String vehID, String routeID, String typeID, String depart, String departLane) {
        libsumoJNI.Vehicle_add__SWIG_10(vehID, routeID, typeID, depart, departLane);
    }

    public static void add(String vehID, String routeID, String typeID, String depart) {
        libsumoJNI.Vehicle_add__SWIG_11(vehID, routeID, typeID, depart);
    }

    public static void add(String vehID, String routeID, String typeID) {
        libsumoJNI.Vehicle_add__SWIG_12(vehID, routeID, typeID);
    }

    public static void add(String vehID, String routeID) {
        libsumoJNI.Vehicle_add__SWIG_13(vehID, routeID);
    }

    public static void changeTarget(String vehID, String edgeID) {
        libsumoJNI.Vehicle_changeTarget(vehID, edgeID);
    }

    public static void changeLane(String vehID, int laneIndex, double duration) {
        libsumoJNI.Vehicle_changeLane(vehID, laneIndex, duration);
    }

    public static void changeLaneRelative(String vehID, int indexOffset, double duration) {
        libsumoJNI.Vehicle_changeLaneRelative(vehID, indexOffset, duration);
    }

    public static void changeSublane(String vehID, double latDist) {
        libsumoJNI.Vehicle_changeSublane(vehID, latDist);
    }

    public static void slowDown(String vehID, double speed, double duration) {
        libsumoJNI.Vehicle_slowDown(vehID, speed, duration);
    }

    public static void openGap(String vehID, double newTimeHeadway, double newSpaceHeadway, double duration, double changeRate, double maxDecel, String referenceVehID) {
        libsumoJNI.Vehicle_openGap__SWIG_0(vehID, newTimeHeadway, newSpaceHeadway, duration, changeRate, maxDecel, referenceVehID);
    }

    public static void openGap(String vehID, double newTimeHeadway, double newSpaceHeadway, double duration, double changeRate, double maxDecel) {
        libsumoJNI.Vehicle_openGap__SWIG_1(vehID, newTimeHeadway, newSpaceHeadway, duration, changeRate, maxDecel);
    }

    public static void openGap(String vehID, double newTimeHeadway, double newSpaceHeadway, double duration, double changeRate) {
        libsumoJNI.Vehicle_openGap__SWIG_2(vehID, newTimeHeadway, newSpaceHeadway, duration, changeRate);
    }

    public static void deactivateGapControl(String vehID) {
        libsumoJNI.Vehicle_deactivateGapControl(vehID);
    }

    public static void requestToC(String vehID, double leadTime) {
        libsumoJNI.Vehicle_requestToC(vehID, leadTime);
    }

    public static void setSpeed(String vehID, double speed) {
        libsumoJNI.Vehicle_setSpeed(vehID, speed);
    }

    public static void setAcceleration(String vehID, double acceleration, double duration) {
        libsumoJNI.Vehicle_setAcceleration(vehID, acceleration, duration);
    }

    public static void setPreviousSpeed(String vehID, double prevSpeed, double prevAcceleration) {
        libsumoJNI.Vehicle_setPreviousSpeed__SWIG_0(vehID, prevSpeed, prevAcceleration);
    }

    public static void setPreviousSpeed(String vehID, double prevSpeed) {
        libsumoJNI.Vehicle_setPreviousSpeed__SWIG_1(vehID, prevSpeed);
    }

    public static void setSpeedMode(String vehID, int speedMode) {
        libsumoJNI.Vehicle_setSpeedMode(vehID, speedMode);
    }

    public static void setLaneChangeMode(String vehID, int laneChangeMode) {
        libsumoJNI.Vehicle_setLaneChangeMode(vehID, laneChangeMode);
    }

    public static void setRoutingMode(String vehID, int routingMode) {
        libsumoJNI.Vehicle_setRoutingMode(vehID, routingMode);
    }

    public static void setType(String vehID, String typeID) {
        libsumoJNI.Vehicle_setType(vehID, typeID);
    }

    public static void setRouteID(String vehID, String routeID) {
        libsumoJNI.Vehicle_setRouteID(vehID, routeID);
    }

    public static void setRoute(String vehID, String edgeID) {
        libsumoJNI.Vehicle_setRoute__SWIG_0(vehID, edgeID);
    }

    public static void setRoute(String vehID, StringVector edgeIDs) {
        libsumoJNI.Vehicle_setRoute__SWIG_1(vehID, StringVector.getCPtr(edgeIDs), edgeIDs);
    }

    public static void setLateralLanePosition(String vehID, double posLat) {
        libsumoJNI.Vehicle_setLateralLanePosition(vehID, posLat);
    }

    public static void updateBestLanes(String vehID) {
        libsumoJNI.Vehicle_updateBestLanes(vehID);
    }

    public static void setAdaptedTraveltime(String vehID, String edgeID, double time, double begSeconds, double endSeconds) {
        libsumoJNI.Vehicle_setAdaptedTraveltime__SWIG_0(vehID, edgeID, time, begSeconds, endSeconds);
    }

    public static void setAdaptedTraveltime(String vehID, String edgeID, double time, double begSeconds) {
        libsumoJNI.Vehicle_setAdaptedTraveltime__SWIG_1(vehID, edgeID, time, begSeconds);
    }

    public static void setAdaptedTraveltime(String vehID, String edgeID, double time) {
        libsumoJNI.Vehicle_setAdaptedTraveltime__SWIG_2(vehID, edgeID, time);
    }

    public static void setAdaptedTraveltime(String vehID, String edgeID) {
        libsumoJNI.Vehicle_setAdaptedTraveltime__SWIG_3(vehID, edgeID);
    }

    public static void setEffort(String vehID, String edgeID, double effort, double begSeconds, double endSeconds) {
        libsumoJNI.Vehicle_setEffort__SWIG_0(vehID, edgeID, effort, begSeconds, endSeconds);
    }

    public static void setEffort(String vehID, String edgeID, double effort, double begSeconds) {
        libsumoJNI.Vehicle_setEffort__SWIG_1(vehID, edgeID, effort, begSeconds);
    }

    public static void setEffort(String vehID, String edgeID, double effort) {
        libsumoJNI.Vehicle_setEffort__SWIG_2(vehID, edgeID, effort);
    }

    public static void setEffort(String vehID, String edgeID) {
        libsumoJNI.Vehicle_setEffort__SWIG_3(vehID, edgeID);
    }

    public static void rerouteTraveltime(String vehID, boolean currentTravelTimes) {
        libsumoJNI.Vehicle_rerouteTraveltime__SWIG_0(vehID, currentTravelTimes);
    }

    public static void rerouteTraveltime(String vehID) {
        libsumoJNI.Vehicle_rerouteTraveltime__SWIG_1(vehID);
    }

    public static void rerouteEffort(String vehID) {
        libsumoJNI.Vehicle_rerouteEffort(vehID);
    }

    public static void setSignals(String vehID, int signals) {
        libsumoJNI.Vehicle_setSignals(vehID, signals);
    }

    public static void moveTo(String vehID, String laneID, double pos, int reason) {
        libsumoJNI.Vehicle_moveTo__SWIG_0(vehID, laneID, pos, reason);
    }

    public static void moveTo(String vehID, String laneID, double pos) {
        libsumoJNI.Vehicle_moveTo__SWIG_1(vehID, laneID, pos);
    }

    public static void moveToXY(String vehID, String edgeID, int laneIndex, double x, double y, double angle, int keepRoute, double matchThreshold) {
        libsumoJNI.Vehicle_moveToXY__SWIG_0(vehID, edgeID, laneIndex, x, y, angle, keepRoute, matchThreshold);
    }

    public static void moveToXY(String vehID, String edgeID, int laneIndex, double x, double y, double angle, int keepRoute) {
        libsumoJNI.Vehicle_moveToXY__SWIG_1(vehID, edgeID, laneIndex, x, y, angle, keepRoute);
    }

    public static void moveToXY(String vehID, String edgeID, int laneIndex, double x, double y, double angle) {
        libsumoJNI.Vehicle_moveToXY__SWIG_2(vehID, edgeID, laneIndex, x, y, angle);
    }

    public static void moveToXY(String vehID, String edgeID, int laneIndex, double x, double y) {
        libsumoJNI.Vehicle_moveToXY__SWIG_3(vehID, edgeID, laneIndex, x, y);
    }

    public static void remove(String vehID, char reason) {
        libsumoJNI.Vehicle_remove__SWIG_0(vehID, reason);
    }

    public static void remove(String vehID) {
        libsumoJNI.Vehicle_remove__SWIG_1(vehID);
    }

    public static void setLine(String vehID, String line) {
        libsumoJNI.Vehicle_setLine(vehID, line);
    }

    public static void setVia(String vehID, StringVector edgeList) {
        libsumoJNI.Vehicle_setVia(vehID, StringVector.getCPtr(edgeList), edgeList);
    }

    public static void highlight(String vehID, TraCIColor col, double size, int alphaMax, double duration, int type) {
        libsumoJNI.Vehicle_highlight__SWIG_0(vehID, TraCIColor.getCPtr(col), col, size, alphaMax, duration, type);
    }

    public static void highlight(String vehID, TraCIColor col, double size, int alphaMax, double duration) {
        libsumoJNI.Vehicle_highlight__SWIG_1(vehID, TraCIColor.getCPtr(col), col, size, alphaMax, duration);
    }

    public static void highlight(String vehID, TraCIColor col, double size, int alphaMax) {
        libsumoJNI.Vehicle_highlight__SWIG_2(vehID, TraCIColor.getCPtr(col), col, size, alphaMax);
    }

    public static void highlight(String vehID, TraCIColor col, double size) {
        libsumoJNI.Vehicle_highlight__SWIG_3(vehID, TraCIColor.getCPtr(col), col, size);
    }

    public static void highlight(String vehID, TraCIColor col) {
        libsumoJNI.Vehicle_highlight__SWIG_4(vehID, TraCIColor.getCPtr(col), col);
    }

    public static void highlight(String vehID) {
        libsumoJNI.Vehicle_highlight__SWIG_5(vehID);
    }

    public static void dispatchTaxi(String vehID, StringVector reservations) {
        libsumoJNI.Vehicle_dispatchTaxi(vehID, StringVector.getCPtr(reservations), reservations);
    }

    public static void setLength(String typeID, double length) {
        libsumoJNI.Vehicle_setLength(typeID, length);
    }

    public static void setMaxSpeed(String typeID, double speed) {
        libsumoJNI.Vehicle_setMaxSpeed(typeID, speed);
    }

    public static void setVehicleClass(String typeID, String clazz) {
        libsumoJNI.Vehicle_setVehicleClass(typeID, clazz);
    }

    public static void setSpeedFactor(String typeID, double factor) {
        libsumoJNI.Vehicle_setSpeedFactor(typeID, factor);
    }

    public static void setAccel(String typeID, double accel) {
        libsumoJNI.Vehicle_setAccel(typeID, accel);
    }

    public static void setDecel(String typeID, double decel) {
        libsumoJNI.Vehicle_setDecel(typeID, decel);
    }

    public static void setEmergencyDecel(String typeID, double decel) {
        libsumoJNI.Vehicle_setEmergencyDecel(typeID, decel);
    }

    public static void setApparentDecel(String typeID, double decel) {
        libsumoJNI.Vehicle_setApparentDecel(typeID, decel);
    }

    public static void setImperfection(String typeID, double imperfection) {
        libsumoJNI.Vehicle_setImperfection(typeID, imperfection);
    }

    public static void setTau(String typeID, double tau) {
        libsumoJNI.Vehicle_setTau(typeID, tau);
    }

    public static void setEmissionClass(String typeID, String clazz) {
        libsumoJNI.Vehicle_setEmissionClass(typeID, clazz);
    }

    public static void setShapeClass(String typeID, String shapeClass) {
        libsumoJNI.Vehicle_setShapeClass(typeID, shapeClass);
    }

    public static void setWidth(String typeID, double width) {
        libsumoJNI.Vehicle_setWidth(typeID, width);
    }

    public static void setHeight(String typeID, double height) {
        libsumoJNI.Vehicle_setHeight(typeID, height);
    }

    public static void setMass(String typeID, double mass) {
        libsumoJNI.Vehicle_setMass(typeID, mass);
    }

    public static void setColor(String typeID, TraCIColor color) {
        libsumoJNI.Vehicle_setColor(typeID, TraCIColor.getCPtr(color), color);
    }

    public static void setMinGap(String typeID, double minGap) {
        libsumoJNI.Vehicle_setMinGap(typeID, minGap);
    }

    public static void setMinGapLat(String typeID, double minGapLat) {
        libsumoJNI.Vehicle_setMinGapLat(typeID, minGapLat);
    }

    public static void setMaxSpeedLat(String typeID, double speed) {
        libsumoJNI.Vehicle_setMaxSpeedLat(typeID, speed);
    }

    public static void setLateralAlignment(String typeID, String latAlignment) {
        libsumoJNI.Vehicle_setLateralAlignment(typeID, latAlignment);
    }

    public static void setActionStepLength(String typeID, double actionStepLength, boolean resetActionOffset) {
        libsumoJNI.Vehicle_setActionStepLength__SWIG_0(typeID, actionStepLength, resetActionOffset);
    }

    public static void setActionStepLength(String typeID, double actionStepLength) {
        libsumoJNI.Vehicle_setActionStepLength__SWIG_1(typeID, actionStepLength);
    }

    public static void setBoardingDuration(String typeID, double boardingDuration) {
        libsumoJNI.Vehicle_setBoardingDuration(typeID, boardingDuration);
    }

    public static void setImpatience(String typeID, double impatience) {
        libsumoJNI.Vehicle_setImpatience(typeID, impatience);
    }

    public static void subscribe(String objectID, IntVector varIDs, double begin, double end, TraCIResults parameters) {
        libsumoJNI.Vehicle_subscribe__SWIG_0(objectID, IntVector.getCPtr(varIDs), varIDs, begin, end, TraCIResults.getCPtr(parameters), parameters);
    }

    public static void subscribe(String objectID, IntVector varIDs, double begin, double end) {
        libsumoJNI.Vehicle_subscribe__SWIG_1(objectID, IntVector.getCPtr(varIDs), varIDs, begin, end);
    }

    public static void subscribe(String objectID, IntVector varIDs, double begin) {
        libsumoJNI.Vehicle_subscribe__SWIG_2(objectID, IntVector.getCPtr(varIDs), varIDs, begin);
    }

    public static void subscribe(String objectID, IntVector varIDs) {
        libsumoJNI.Vehicle_subscribe__SWIG_3(objectID, IntVector.getCPtr(varIDs), varIDs);
    }

    public static void subscribe(String objectID) {
        libsumoJNI.Vehicle_subscribe__SWIG_4(objectID);
    }

    public static void unsubscribe(String objectID) {
        libsumoJNI.Vehicle_unsubscribe(objectID);
    }

    public static void subscribeContext(String objectID, int domain, double dist, IntVector varIDs, double begin, double end, TraCIResults parameters) {
        libsumoJNI.Vehicle_subscribeContext__SWIG_0(objectID, domain, dist, IntVector.getCPtr(varIDs), varIDs, begin, end, TraCIResults.getCPtr(parameters), parameters);
    }

    public static void subscribeContext(String objectID, int domain, double dist, IntVector varIDs, double begin, double end) {
        libsumoJNI.Vehicle_subscribeContext__SWIG_1(objectID, domain, dist, IntVector.getCPtr(varIDs), varIDs, begin, end);
    }

    public static void subscribeContext(String objectID, int domain, double dist, IntVector varIDs, double begin) {
        libsumoJNI.Vehicle_subscribeContext__SWIG_2(objectID, domain, dist, IntVector.getCPtr(varIDs), varIDs, begin);
    }

    public static void subscribeContext(String objectID, int domain, double dist, IntVector varIDs) {
        libsumoJNI.Vehicle_subscribeContext__SWIG_3(objectID, domain, dist, IntVector.getCPtr(varIDs), varIDs);
    }

    public static void subscribeContext(String objectID, int domain, double dist) {
        libsumoJNI.Vehicle_subscribeContext__SWIG_4(objectID, domain, dist);
    }

    public static void unsubscribeContext(String objectID, int domain, double dist) {
        libsumoJNI.Vehicle_unsubscribeContext(objectID, domain, dist);
    }

    public static SubscriptionResults getAllSubscriptionResults() {
        return new SubscriptionResults(libsumoJNI.Vehicle_getAllSubscriptionResults(), true);
    }

    public static TraCIResults getSubscriptionResults(String objectID) {
        return new TraCIResults(libsumoJNI.Vehicle_getSubscriptionResults(objectID), true);
    }

    public static ContextSubscriptionResults getAllContextSubscriptionResults() {
        return new ContextSubscriptionResults(libsumoJNI.Vehicle_getAllContextSubscriptionResults(), true);
    }

    public static SubscriptionResults getContextSubscriptionResults(String objectID) {
        return new SubscriptionResults(libsumoJNI.Vehicle_getContextSubscriptionResults(objectID), true);
    }

    public static void subscribeParameterWithKey(String objectID, String key, double beginTime, double endTime) {
        libsumoJNI.Vehicle_subscribeParameterWithKey__SWIG_0(objectID, key, beginTime, endTime);
    }

    public static void subscribeParameterWithKey(String objectID, String key, double beginTime) {
        libsumoJNI.Vehicle_subscribeParameterWithKey__SWIG_1(objectID, key, beginTime);
    }

    public static void subscribeParameterWithKey(String objectID, String key) {
        libsumoJNI.Vehicle_subscribeParameterWithKey__SWIG_2(objectID, key);
    }

    public static int getDOMAIN_ID() {
        return libsumoJNI.Vehicle_DOMAIN_ID_get();
    }

    public static int domainID() {
        return libsumoJNI.Vehicle_domainID();
    }

    public static void subscribeLeader(String vehID, double dist, double begin, double end) {
        libsumoJNI.Vehicle_subscribeLeader__SWIG_0(vehID, dist, begin, end);
    }

    public static void subscribeLeader(String vehID, double dist, double begin) {
        libsumoJNI.Vehicle_subscribeLeader__SWIG_1(vehID, dist, begin);
    }

    public static void subscribeLeader(String vehID, double dist) {
        libsumoJNI.Vehicle_subscribeLeader__SWIG_2(vehID, dist);
    }

    public static void subscribeLeader(String vehID) {
        libsumoJNI.Vehicle_subscribeLeader__SWIG_3(vehID);
    }

    public static void addSubscriptionFilterLanes(IntVector lanes, boolean noOpposite, double downstreamDist, double upstreamDist) {
        libsumoJNI.Vehicle_addSubscriptionFilterLanes__SWIG_0(IntVector.getCPtr(lanes), lanes, noOpposite, downstreamDist, upstreamDist);
    }

    public static void addSubscriptionFilterLanes(IntVector lanes, boolean noOpposite, double downstreamDist) {
        libsumoJNI.Vehicle_addSubscriptionFilterLanes__SWIG_1(IntVector.getCPtr(lanes), lanes, noOpposite, downstreamDist);
    }

    public static void addSubscriptionFilterLanes(IntVector lanes, boolean noOpposite) {
        libsumoJNI.Vehicle_addSubscriptionFilterLanes__SWIG_2(IntVector.getCPtr(lanes), lanes, noOpposite);
    }

    public static void addSubscriptionFilterLanes(IntVector lanes) {
        libsumoJNI.Vehicle_addSubscriptionFilterLanes__SWIG_3(IntVector.getCPtr(lanes), lanes);
    }

    public static void addSubscriptionFilterNoOpposite() {
        libsumoJNI.Vehicle_addSubscriptionFilterNoOpposite();
    }

    public static void addSubscriptionFilterDownstreamDistance(double dist) {
        libsumoJNI.Vehicle_addSubscriptionFilterDownstreamDistance(dist);
    }

    public static void addSubscriptionFilterUpstreamDistance(double dist) {
        libsumoJNI.Vehicle_addSubscriptionFilterUpstreamDistance(dist);
    }

    public static void addSubscriptionFilterCFManeuver(double downstreamDist, double upstreamDist) {
        libsumoJNI.Vehicle_addSubscriptionFilterCFManeuver__SWIG_0(downstreamDist, upstreamDist);
    }

    public static void addSubscriptionFilterCFManeuver(double downstreamDist) {
        libsumoJNI.Vehicle_addSubscriptionFilterCFManeuver__SWIG_1(downstreamDist);
    }

    public static void addSubscriptionFilterCFManeuver() {
        libsumoJNI.Vehicle_addSubscriptionFilterCFManeuver__SWIG_2();
    }

    public static void addSubscriptionFilterLCManeuver(int direction, boolean noOpposite, double downstreamDist, double upstreamDist) {
        libsumoJNI.Vehicle_addSubscriptionFilterLCManeuver__SWIG_0(direction, noOpposite, downstreamDist, upstreamDist);
    }

    public static void addSubscriptionFilterLCManeuver(int direction, boolean noOpposite, double downstreamDist) {
        libsumoJNI.Vehicle_addSubscriptionFilterLCManeuver__SWIG_1(direction, noOpposite, downstreamDist);
    }

    public static void addSubscriptionFilterLCManeuver(int direction, boolean noOpposite) {
        libsumoJNI.Vehicle_addSubscriptionFilterLCManeuver__SWIG_2(direction, noOpposite);
    }

    public static void addSubscriptionFilterLCManeuver(int direction) {
        libsumoJNI.Vehicle_addSubscriptionFilterLCManeuver__SWIG_3(direction);
    }

    public static void addSubscriptionFilterLCManeuver() {
        libsumoJNI.Vehicle_addSubscriptionFilterLCManeuver__SWIG_4();
    }

    public static void addSubscriptionFilterLeadFollow(IntVector lanes) {
        libsumoJNI.Vehicle_addSubscriptionFilterLeadFollow(IntVector.getCPtr(lanes), lanes);
    }

    public static void addSubscriptionFilterTurn(double downstreamDist, double foeDistToJunction) {
        libsumoJNI.Vehicle_addSubscriptionFilterTurn__SWIG_0(downstreamDist, foeDistToJunction);
    }

    public static void addSubscriptionFilterTurn(double downstreamDist) {
        libsumoJNI.Vehicle_addSubscriptionFilterTurn__SWIG_1(downstreamDist);
    }

    public static void addSubscriptionFilterTurn() {
        libsumoJNI.Vehicle_addSubscriptionFilterTurn__SWIG_2();
    }

    public static void addSubscriptionFilterVClass(StringVector vClasses) {
        libsumoJNI.Vehicle_addSubscriptionFilterVClass(StringVector.getCPtr(vClasses), vClasses);
    }

    public static void addSubscriptionFilterVType(StringVector vTypes) {
        libsumoJNI.Vehicle_addSubscriptionFilterVType(StringVector.getCPtr(vTypes), vTypes);
    }

    public static void addSubscriptionFilterFieldOfVision(double openingAngle) {
        libsumoJNI.Vehicle_addSubscriptionFilterFieldOfVision(openingAngle);
    }

    public static void addSubscriptionFilterLateralDistance(double lateralDist, double downstreamDist, double upstreamDist) {
        libsumoJNI.Vehicle_addSubscriptionFilterLateralDistance__SWIG_0(lateralDist, downstreamDist, upstreamDist);
    }

    public static void addSubscriptionFilterLateralDistance(double lateralDist, double downstreamDist) {
        libsumoJNI.Vehicle_addSubscriptionFilterLateralDistance__SWIG_1(lateralDist, downstreamDist);
    }

    public static void addSubscriptionFilterLateralDistance(double lateralDist) {
        libsumoJNI.Vehicle_addSubscriptionFilterLateralDistance__SWIG_2(lateralDist);
    }
}

