/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.3.1
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.eclipse.sumo.libtraci;

public class Vehicle {
  private transient long swigCPtr;
  protected transient boolean swigCMemOwn;

  protected Vehicle(long cPtr, boolean cMemoryOwn) {
    swigCMemOwn = cMemoryOwn;
    swigCPtr = cPtr;
  }

  protected static long getCPtr(Vehicle obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(Vehicle obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  public synchronized void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        libtraciJNI.delete_Vehicle(swigCPtr);
      }
      swigCPtr = 0;
    }
  }

  public static double getSpeed(String vehID) {
    return libtraciJNI.Vehicle_getSpeed(vehID);
  }

  public static double getLateralSpeed(String vehID) {
    return libtraciJNI.Vehicle_getLateralSpeed(vehID);
  }

  public static double getAcceleration(String vehID) {
    return libtraciJNI.Vehicle_getAcceleration(vehID);
  }

  public static double getSpeedWithoutTraCI(String vehID) {
    return libtraciJNI.Vehicle_getSpeedWithoutTraCI(vehID);
  }

  public static TraCIPosition getPosition(String vehID, boolean includeZ) {
    return new TraCIPosition(libtraciJNI.Vehicle_getPosition__SWIG_0(vehID, includeZ), true);
  }

  public static TraCIPosition getPosition(String vehID) {
    return new TraCIPosition(libtraciJNI.Vehicle_getPosition__SWIG_1(vehID), true);
  }

  public static TraCIPosition getPosition3D(String vehID) {
    return new TraCIPosition(libtraciJNI.Vehicle_getPosition3D(vehID), true);
  }

  public static double getAngle(String vehID) {
    return libtraciJNI.Vehicle_getAngle(vehID);
  }

  public static double getSlope(String vehID) {
    return libtraciJNI.Vehicle_getSlope(vehID);
  }

  public static String getRoadID(String vehID) {
    return libtraciJNI.Vehicle_getRoadID(vehID);
  }

  public static String getLaneID(String vehID) {
    return libtraciJNI.Vehicle_getLaneID(vehID);
  }

  public static int getLaneIndex(String vehID) {
    return libtraciJNI.Vehicle_getLaneIndex(vehID);
  }

  public static String getSegmentID(String vehID) {
    return libtraciJNI.Vehicle_getSegmentID(vehID);
  }

  public static int getSegmentIndex(String vehID) {
    return libtraciJNI.Vehicle_getSegmentIndex(vehID);
  }

  public static String getTypeID(String vehID) {
    return libtraciJNI.Vehicle_getTypeID(vehID);
  }

  public static String getRouteID(String vehID) {
    return libtraciJNI.Vehicle_getRouteID(vehID);
  }

  public static double getDeparture(String vehID) {
    return libtraciJNI.Vehicle_getDeparture(vehID);
  }

  public static double getDepartDelay(String vehID) {
    return libtraciJNI.Vehicle_getDepartDelay(vehID);
  }

  public static int getRouteIndex(String vehID) {
    return libtraciJNI.Vehicle_getRouteIndex(vehID);
  }

  public static double getLanePosition(String vehID) {
    return libtraciJNI.Vehicle_getLanePosition(vehID);
  }

  public static double getLateralLanePosition(String vehID) {
    return libtraciJNI.Vehicle_getLateralLanePosition(vehID);
  }

  public static double getCO2Emission(String vehID) {
    return libtraciJNI.Vehicle_getCO2Emission(vehID);
  }

  public static double getCOEmission(String vehID) {
    return libtraciJNI.Vehicle_getCOEmission(vehID);
  }

  public static double getHCEmission(String vehID) {
    return libtraciJNI.Vehicle_getHCEmission(vehID);
  }

  public static double getPMxEmission(String vehID) {
    return libtraciJNI.Vehicle_getPMxEmission(vehID);
  }

  public static double getNOxEmission(String vehID) {
    return libtraciJNI.Vehicle_getNOxEmission(vehID);
  }

  public static double getFuelConsumption(String vehID) {
    return libtraciJNI.Vehicle_getFuelConsumption(vehID);
  }

  public static double getNoiseEmission(String vehID) {
    return libtraciJNI.Vehicle_getNoiseEmission(vehID);
  }

  public static double getElectricityConsumption(String vehID) {
    return libtraciJNI.Vehicle_getElectricityConsumption(vehID);
  }

  public static int getPersonNumber(String vehID) {
    return libtraciJNI.Vehicle_getPersonNumber(vehID);
  }

  public static StringVector getPersonIDList(String vehID) {
    return new StringVector(libtraciJNI.Vehicle_getPersonIDList(vehID), true);
  }

  public static StringDoublePair getLeader(String vehID, double dist) {
    return new StringDoublePair(libtraciJNI.Vehicle_getLeader__SWIG_0(vehID, dist), true);
  }

  public static StringDoublePair getLeader(String vehID) {
    return new StringDoublePair(libtraciJNI.Vehicle_getLeader__SWIG_1(vehID), true);
  }

  public static StringDoublePair getFollower(String vehID, double dist) {
    return new StringDoublePair(libtraciJNI.Vehicle_getFollower__SWIG_0(vehID, dist), true);
  }

  public static StringDoublePair getFollower(String vehID) {
    return new StringDoublePair(libtraciJNI.Vehicle_getFollower__SWIG_1(vehID), true);
  }

  public static TraCIJunctionFoeVector getJunctionFoes(String vehID, double dist) {
    return new TraCIJunctionFoeVector(libtraciJNI.Vehicle_getJunctionFoes__SWIG_0(vehID, dist), true);
  }

  public static TraCIJunctionFoeVector getJunctionFoes(String vehID) {
    return new TraCIJunctionFoeVector(libtraciJNI.Vehicle_getJunctionFoes__SWIG_1(vehID), true);
  }

  public static double getWaitingTime(String vehID) {
    return libtraciJNI.Vehicle_getWaitingTime(vehID);
  }

  public static double getAccumulatedWaitingTime(String vehID) {
    return libtraciJNI.Vehicle_getAccumulatedWaitingTime(vehID);
  }

  public static double getAdaptedTraveltime(String vehID, double time, String edgeID) {
    return libtraciJNI.Vehicle_getAdaptedTraveltime(vehID, time, edgeID);
  }

  public static double getEffort(String vehID, double time, String edgeID) {
    return libtraciJNI.Vehicle_getEffort(vehID, time, edgeID);
  }

  public static boolean isRouteValid(String vehID) {
    return libtraciJNI.Vehicle_isRouteValid(vehID);
  }

  public static StringVector getRoute(String vehID) {
    return new StringVector(libtraciJNI.Vehicle_getRoute(vehID), true);
  }

  public static int getSignals(String vehID) {
    return libtraciJNI.Vehicle_getSignals(vehID);
  }

  public static TraCIBestLanesDataVector getBestLanes(String vehID) {
    return new TraCIBestLanesDataVector(libtraciJNI.Vehicle_getBestLanes(vehID), true);
  }

  public static TraCINextTLSVector getNextTLS(String vehID) {
    return new TraCINextTLSVector(libtraciJNI.Vehicle_getNextTLS(vehID), true);
  }

  public static TraCINextStopDataVector getNextStops(String vehID) {
    return new TraCINextStopDataVector(libtraciJNI.Vehicle_getNextStops(vehID), true);
  }

  public static TraCIConnectionVector getNextLinks(String vehID) {
    return new TraCIConnectionVector(libtraciJNI.Vehicle_getNextLinks(vehID), true);
  }

  public static TraCINextStopDataVector getStops(String vehID, int limit) {
    return new TraCINextStopDataVector(libtraciJNI.Vehicle_getStops__SWIG_0(vehID, limit), true);
  }

  public static TraCINextStopDataVector getStops(String vehID) {
    return new TraCINextStopDataVector(libtraciJNI.Vehicle_getStops__SWIG_1(vehID), true);
  }

  public static int getStopState(String vehID) {
    return libtraciJNI.Vehicle_getStopState(vehID);
  }

  public static String getStopParameter(String vehID, int nextStopIndex, String param, boolean customParam) {
    return libtraciJNI.Vehicle_getStopParameter__SWIG_0(vehID, nextStopIndex, param, customParam);
  }

  public static String getStopParameter(String vehID, int nextStopIndex, String param) {
    return libtraciJNI.Vehicle_getStopParameter__SWIG_1(vehID, nextStopIndex, param);
  }

  public static double getDistance(String vehID) {
    return libtraciJNI.Vehicle_getDistance(vehID);
  }

  public static double getDrivingDistance(String vehID, String edgeID, double pos, int laneIndex) {
    return libtraciJNI.Vehicle_getDrivingDistance__SWIG_0(vehID, edgeID, pos, laneIndex);
  }

  public static double getDrivingDistance(String vehID, String edgeID, double pos) {
    return libtraciJNI.Vehicle_getDrivingDistance__SWIG_1(vehID, edgeID, pos);
  }

  public static double getDrivingDistance2D(String vehID, double x, double y) {
    return libtraciJNI.Vehicle_getDrivingDistance2D(vehID, x, y);
  }

  public static double getAllowedSpeed(String vehID) {
    return libtraciJNI.Vehicle_getAllowedSpeed(vehID);
  }

  public static int getSpeedMode(String vehID) {
    return libtraciJNI.Vehicle_getSpeedMode(vehID);
  }

  public static int getLaneChangeMode(String vehID) {
    return libtraciJNI.Vehicle_getLaneChangeMode(vehID);
  }

  public static int getRoutingMode(String vehID) {
    return libtraciJNI.Vehicle_getRoutingMode(vehID);
  }

  public static String getLine(String vehID) {
    return libtraciJNI.Vehicle_getLine(vehID);
  }

  public static StringVector getVia(String vehID) {
    return new StringVector(libtraciJNI.Vehicle_getVia(vehID), true);
  }

  public static IntIntPair getLaneChangeState(String vehID, int direction) {
    return new IntIntPair(libtraciJNI.Vehicle_getLaneChangeState(vehID, direction), true);
  }

  public static double getLastActionTime(String vehID) {
    return libtraciJNI.Vehicle_getLastActionTime(vehID);
  }

  public static StringDoublePairVector getNeighbors(String vehID, int mode) {
    return new StringDoublePairVector(libtraciJNI.Vehicle_getNeighbors(vehID, mode), true);
  }

  public static double getFollowSpeed(String vehID, double speed, double gap, double leaderSpeed, double leaderMaxDecel, String leaderID) {
    return libtraciJNI.Vehicle_getFollowSpeed__SWIG_0(vehID, speed, gap, leaderSpeed, leaderMaxDecel, leaderID);
  }

  public static double getFollowSpeed(String vehID, double speed, double gap, double leaderSpeed, double leaderMaxDecel) {
    return libtraciJNI.Vehicle_getFollowSpeed__SWIG_1(vehID, speed, gap, leaderSpeed, leaderMaxDecel);
  }

  public static double getSecureGap(String vehID, double speed, double leaderSpeed, double leaderMaxDecel, String leaderID) {
    return libtraciJNI.Vehicle_getSecureGap__SWIG_0(vehID, speed, leaderSpeed, leaderMaxDecel, leaderID);
  }

  public static double getSecureGap(String vehID, double speed, double leaderSpeed, double leaderMaxDecel) {
    return libtraciJNI.Vehicle_getSecureGap__SWIG_1(vehID, speed, leaderSpeed, leaderMaxDecel);
  }

  public static double getStopSpeed(String vehID, double speed, double gap) {
    return libtraciJNI.Vehicle_getStopSpeed(vehID, speed, gap);
  }

  public static double getStopDelay(String vehID) {
    return libtraciJNI.Vehicle_getStopDelay(vehID);
  }

  public static double getStopArrivalDelay(String vehID) {
    return libtraciJNI.Vehicle_getStopArrivalDelay(vehID);
  }

  public static double getTimeLoss(String vehID) {
    return libtraciJNI.Vehicle_getTimeLoss(vehID);
  }

  public static StringVector getTaxiFleet(int taxiState) {
    return new StringVector(libtraciJNI.Vehicle_getTaxiFleet__SWIG_0(taxiState), true);
  }

  public static StringVector getTaxiFleet() {
    return new StringVector(libtraciJNI.Vehicle_getTaxiFleet__SWIG_1(), true);
  }

  public static StringVector getLoadedIDList() {
    return new StringVector(libtraciJNI.Vehicle_getLoadedIDList(), true);
  }

  public static StringVector getTeleportingIDList() {
    return new StringVector(libtraciJNI.Vehicle_getTeleportingIDList(), true);
  }

  public static StringVector getIDList() {
    return new StringVector(libtraciJNI.Vehicle_getIDList(), true);
  }

  public static int getIDCount() {
    return libtraciJNI.Vehicle_getIDCount();
  }

  public static String getParameter(String objectID, String key) {
    return libtraciJNI.Vehicle_getParameter(objectID, key);
  }

  public static StringStringPair getParameterWithKey(String objectID, String key) {
    return new StringStringPair(libtraciJNI.Vehicle_getParameterWithKey(objectID, key), true);
  }

  public static void setParameter(String objectID, String key, String value) {
    libtraciJNI.Vehicle_setParameter(objectID, key, value);
  }

  public static double getLength(String typeID) {
    return libtraciJNI.Vehicle_getLength(typeID);
  }

  public static double getMaxSpeed(String typeID) {
    return libtraciJNI.Vehicle_getMaxSpeed(typeID);
  }

  public static String getVehicleClass(String typeID) {
    return libtraciJNI.Vehicle_getVehicleClass(typeID);
  }

  public static double getSpeedFactor(String typeID) {
    return libtraciJNI.Vehicle_getSpeedFactor(typeID);
  }

  public static double getAccel(String typeID) {
    return libtraciJNI.Vehicle_getAccel(typeID);
  }

  public static double getDecel(String typeID) {
    return libtraciJNI.Vehicle_getDecel(typeID);
  }

  public static double getEmergencyDecel(String typeID) {
    return libtraciJNI.Vehicle_getEmergencyDecel(typeID);
  }

  public static double getApparentDecel(String typeID) {
    return libtraciJNI.Vehicle_getApparentDecel(typeID);
  }

  public static double getImperfection(String typeID) {
    return libtraciJNI.Vehicle_getImperfection(typeID);
  }

  public static double getTau(String typeID) {
    return libtraciJNI.Vehicle_getTau(typeID);
  }

  public static String getEmissionClass(String typeID) {
    return libtraciJNI.Vehicle_getEmissionClass(typeID);
  }

  public static String getShapeClass(String typeID) {
    return libtraciJNI.Vehicle_getShapeClass(typeID);
  }

  public static double getMinGap(String typeID) {
    return libtraciJNI.Vehicle_getMinGap(typeID);
  }

  public static double getWidth(String typeID) {
    return libtraciJNI.Vehicle_getWidth(typeID);
  }

  public static double getHeight(String typeID) {
    return libtraciJNI.Vehicle_getHeight(typeID);
  }

  public static double getMass(String typeID) {
    return libtraciJNI.Vehicle_getMass(typeID);
  }

  public static TraCIColor getColor(String typeID) {
    return new TraCIColor(libtraciJNI.Vehicle_getColor(typeID), true);
  }

  public static double getMinGapLat(String typeID) {
    return libtraciJNI.Vehicle_getMinGapLat(typeID);
  }

  public static double getMaxSpeedLat(String typeID) {
    return libtraciJNI.Vehicle_getMaxSpeedLat(typeID);
  }

  public static String getLateralAlignment(String typeID) {
    return libtraciJNI.Vehicle_getLateralAlignment(typeID);
  }

  public static int getPersonCapacity(String typeID) {
    return libtraciJNI.Vehicle_getPersonCapacity(typeID);
  }

  public static double getActionStepLength(String typeID) {
    return libtraciJNI.Vehicle_getActionStepLength(typeID);
  }

  public static double getSpeedDeviation(String typeID) {
    return libtraciJNI.Vehicle_getSpeedDeviation(typeID);
  }

  public static double getBoardingDuration(String typeID) {
    return libtraciJNI.Vehicle_getBoardingDuration(typeID);
  }

  public static double getImpatience(String typeID) {
    return libtraciJNI.Vehicle_getImpatience(typeID);
  }

  public static void setStop(String vehID, String edgeID, double pos, int laneIndex, double duration, int flags, double startPos, double until) {
    libtraciJNI.Vehicle_setStop__SWIG_0(vehID, edgeID, pos, laneIndex, duration, flags, startPos, until);
  }

  public static void setStop(String vehID, String edgeID, double pos, int laneIndex, double duration, int flags, double startPos) {
    libtraciJNI.Vehicle_setStop__SWIG_1(vehID, edgeID, pos, laneIndex, duration, flags, startPos);
  }

  public static void setStop(String vehID, String edgeID, double pos, int laneIndex, double duration, int flags) {
    libtraciJNI.Vehicle_setStop__SWIG_2(vehID, edgeID, pos, laneIndex, duration, flags);
  }

  public static void setStop(String vehID, String edgeID, double pos, int laneIndex, double duration) {
    libtraciJNI.Vehicle_setStop__SWIG_3(vehID, edgeID, pos, laneIndex, duration);
  }

  public static void setStop(String vehID, String edgeID, double pos, int laneIndex) {
    libtraciJNI.Vehicle_setStop__SWIG_4(vehID, edgeID, pos, laneIndex);
  }

  public static void setStop(String vehID, String edgeID, double pos) {
    libtraciJNI.Vehicle_setStop__SWIG_5(vehID, edgeID, pos);
  }

  public static void setStop(String vehID, String edgeID) {
    libtraciJNI.Vehicle_setStop__SWIG_6(vehID, edgeID);
  }

  public static void replaceStop(String vehID, int nextStopIndex, String edgeID, double pos, int laneIndex, double duration, int flags, double startPos, double until, int teleport) {
    libtraciJNI.Vehicle_replaceStop__SWIG_0(vehID, nextStopIndex, edgeID, pos, laneIndex, duration, flags, startPos, until, teleport);
  }

  public static void replaceStop(String vehID, int nextStopIndex, String edgeID, double pos, int laneIndex, double duration, int flags, double startPos, double until) {
    libtraciJNI.Vehicle_replaceStop__SWIG_1(vehID, nextStopIndex, edgeID, pos, laneIndex, duration, flags, startPos, until);
  }

  public static void replaceStop(String vehID, int nextStopIndex, String edgeID, double pos, int laneIndex, double duration, int flags, double startPos) {
    libtraciJNI.Vehicle_replaceStop__SWIG_2(vehID, nextStopIndex, edgeID, pos, laneIndex, duration, flags, startPos);
  }

  public static void replaceStop(String vehID, int nextStopIndex, String edgeID, double pos, int laneIndex, double duration, int flags) {
    libtraciJNI.Vehicle_replaceStop__SWIG_3(vehID, nextStopIndex, edgeID, pos, laneIndex, duration, flags);
  }

  public static void replaceStop(String vehID, int nextStopIndex, String edgeID, double pos, int laneIndex, double duration) {
    libtraciJNI.Vehicle_replaceStop__SWIG_4(vehID, nextStopIndex, edgeID, pos, laneIndex, duration);
  }

  public static void replaceStop(String vehID, int nextStopIndex, String edgeID, double pos, int laneIndex) {
    libtraciJNI.Vehicle_replaceStop__SWIG_5(vehID, nextStopIndex, edgeID, pos, laneIndex);
  }

  public static void replaceStop(String vehID, int nextStopIndex, String edgeID, double pos) {
    libtraciJNI.Vehicle_replaceStop__SWIG_6(vehID, nextStopIndex, edgeID, pos);
  }

  public static void replaceStop(String vehID, int nextStopIndex, String edgeID) {
    libtraciJNI.Vehicle_replaceStop__SWIG_7(vehID, nextStopIndex, edgeID);
  }

  public static void insertStop(String vehID, int nextStopIndex, String edgeID, double pos, int laneIndex, double duration, int flags, double startPos, double until, int teleport) {
    libtraciJNI.Vehicle_insertStop__SWIG_0(vehID, nextStopIndex, edgeID, pos, laneIndex, duration, flags, startPos, until, teleport);
  }

  public static void insertStop(String vehID, int nextStopIndex, String edgeID, double pos, int laneIndex, double duration, int flags, double startPos, double until) {
    libtraciJNI.Vehicle_insertStop__SWIG_1(vehID, nextStopIndex, edgeID, pos, laneIndex, duration, flags, startPos, until);
  }

  public static void insertStop(String vehID, int nextStopIndex, String edgeID, double pos, int laneIndex, double duration, int flags, double startPos) {
    libtraciJNI.Vehicle_insertStop__SWIG_2(vehID, nextStopIndex, edgeID, pos, laneIndex, duration, flags, startPos);
  }

  public static void insertStop(String vehID, int nextStopIndex, String edgeID, double pos, int laneIndex, double duration, int flags) {
    libtraciJNI.Vehicle_insertStop__SWIG_3(vehID, nextStopIndex, edgeID, pos, laneIndex, duration, flags);
  }

  public static void insertStop(String vehID, int nextStopIndex, String edgeID, double pos, int laneIndex, double duration) {
    libtraciJNI.Vehicle_insertStop__SWIG_4(vehID, nextStopIndex, edgeID, pos, laneIndex, duration);
  }

  public static void insertStop(String vehID, int nextStopIndex, String edgeID, double pos, int laneIndex) {
    libtraciJNI.Vehicle_insertStop__SWIG_5(vehID, nextStopIndex, edgeID, pos, laneIndex);
  }

  public static void insertStop(String vehID, int nextStopIndex, String edgeID, double pos) {
    libtraciJNI.Vehicle_insertStop__SWIG_6(vehID, nextStopIndex, edgeID, pos);
  }

  public static void insertStop(String vehID, int nextStopIndex, String edgeID) {
    libtraciJNI.Vehicle_insertStop__SWIG_7(vehID, nextStopIndex, edgeID);
  }

  public static void setStopParameter(String vehID, int nextStopIndex, String param, String value, boolean customParam) {
    libtraciJNI.Vehicle_setStopParameter__SWIG_0(vehID, nextStopIndex, param, value, customParam);
  }

  public static void setStopParameter(String vehID, int nextStopIndex, String param, String value) {
    libtraciJNI.Vehicle_setStopParameter__SWIG_1(vehID, nextStopIndex, param, value);
  }

  public static void rerouteParkingArea(String vehID, String parkingAreaID) {
    libtraciJNI.Vehicle_rerouteParkingArea(vehID, parkingAreaID);
  }

  public static void resume(String vehID) {
    libtraciJNI.Vehicle_resume(vehID);
  }

  public static void add(String vehID, String routeID, String typeID, String depart, String departLane, String departPos, String departSpeed, String arrivalLane, String arrivalPos, String arrivalSpeed, String fromTaz, String toTaz, String line, int personCapacity, int personNumber) {
    libtraciJNI.Vehicle_add__SWIG_0(vehID, routeID, typeID, depart, departLane, departPos, departSpeed, arrivalLane, arrivalPos, arrivalSpeed, fromTaz, toTaz, line, personCapacity, personNumber);
  }

  public static void add(String vehID, String routeID, String typeID, String depart, String departLane, String departPos, String departSpeed, String arrivalLane, String arrivalPos, String arrivalSpeed, String fromTaz, String toTaz, String line, int personCapacity) {
    libtraciJNI.Vehicle_add__SWIG_1(vehID, routeID, typeID, depart, departLane, departPos, departSpeed, arrivalLane, arrivalPos, arrivalSpeed, fromTaz, toTaz, line, personCapacity);
  }

  public static void add(String vehID, String routeID, String typeID, String depart, String departLane, String departPos, String departSpeed, String arrivalLane, String arrivalPos, String arrivalSpeed, String fromTaz, String toTaz, String line) {
    libtraciJNI.Vehicle_add__SWIG_2(vehID, routeID, typeID, depart, departLane, departPos, departSpeed, arrivalLane, arrivalPos, arrivalSpeed, fromTaz, toTaz, line);
  }

  public static void add(String vehID, String routeID, String typeID, String depart, String departLane, String departPos, String departSpeed, String arrivalLane, String arrivalPos, String arrivalSpeed, String fromTaz, String toTaz) {
    libtraciJNI.Vehicle_add__SWIG_3(vehID, routeID, typeID, depart, departLane, departPos, departSpeed, arrivalLane, arrivalPos, arrivalSpeed, fromTaz, toTaz);
  }

  public static void add(String vehID, String routeID, String typeID, String depart, String departLane, String departPos, String departSpeed, String arrivalLane, String arrivalPos, String arrivalSpeed, String fromTaz) {
    libtraciJNI.Vehicle_add__SWIG_4(vehID, routeID, typeID, depart, departLane, departPos, departSpeed, arrivalLane, arrivalPos, arrivalSpeed, fromTaz);
  }

  public static void add(String vehID, String routeID, String typeID, String depart, String departLane, String departPos, String departSpeed, String arrivalLane, String arrivalPos, String arrivalSpeed) {
    libtraciJNI.Vehicle_add__SWIG_5(vehID, routeID, typeID, depart, departLane, departPos, departSpeed, arrivalLane, arrivalPos, arrivalSpeed);
  }

  public static void add(String vehID, String routeID, String typeID, String depart, String departLane, String departPos, String departSpeed, String arrivalLane, String arrivalPos) {
    libtraciJNI.Vehicle_add__SWIG_6(vehID, routeID, typeID, depart, departLane, departPos, departSpeed, arrivalLane, arrivalPos);
  }

  public static void add(String vehID, String routeID, String typeID, String depart, String departLane, String departPos, String departSpeed, String arrivalLane) {
    libtraciJNI.Vehicle_add__SWIG_7(vehID, routeID, typeID, depart, departLane, departPos, departSpeed, arrivalLane);
  }

  public static void add(String vehID, String routeID, String typeID, String depart, String departLane, String departPos, String departSpeed) {
    libtraciJNI.Vehicle_add__SWIG_8(vehID, routeID, typeID, depart, departLane, departPos, departSpeed);
  }

  public static void add(String vehID, String routeID, String typeID, String depart, String departLane, String departPos) {
    libtraciJNI.Vehicle_add__SWIG_9(vehID, routeID, typeID, depart, departLane, departPos);
  }

  public static void add(String vehID, String routeID, String typeID, String depart, String departLane) {
    libtraciJNI.Vehicle_add__SWIG_10(vehID, routeID, typeID, depart, departLane);
  }

  public static void add(String vehID, String routeID, String typeID, String depart) {
    libtraciJNI.Vehicle_add__SWIG_11(vehID, routeID, typeID, depart);
  }

  public static void add(String vehID, String routeID, String typeID) {
    libtraciJNI.Vehicle_add__SWIG_12(vehID, routeID, typeID);
  }

  public static void add(String vehID, String routeID) {
    libtraciJNI.Vehicle_add__SWIG_13(vehID, routeID);
  }

  public static void changeTarget(String vehID, String edgeID) {
    libtraciJNI.Vehicle_changeTarget(vehID, edgeID);
  }

  public static void changeLane(String vehID, int laneIndex, double duration) {
    libtraciJNI.Vehicle_changeLane(vehID, laneIndex, duration);
  }

  public static void changeLaneRelative(String vehID, int indexOffset, double duration) {
    libtraciJNI.Vehicle_changeLaneRelative(vehID, indexOffset, duration);
  }

  public static void changeSublane(String vehID, double latDist) {
    libtraciJNI.Vehicle_changeSublane(vehID, latDist);
  }

  public static void slowDown(String vehID, double speed, double duration) {
    libtraciJNI.Vehicle_slowDown(vehID, speed, duration);
  }

  public static void openGap(String vehID, double newTimeHeadway, double newSpaceHeadway, double duration, double changeRate, double maxDecel, String referenceVehID) {
    libtraciJNI.Vehicle_openGap__SWIG_0(vehID, newTimeHeadway, newSpaceHeadway, duration, changeRate, maxDecel, referenceVehID);
  }

  public static void openGap(String vehID, double newTimeHeadway, double newSpaceHeadway, double duration, double changeRate, double maxDecel) {
    libtraciJNI.Vehicle_openGap__SWIG_1(vehID, newTimeHeadway, newSpaceHeadway, duration, changeRate, maxDecel);
  }

  public static void openGap(String vehID, double newTimeHeadway, double newSpaceHeadway, double duration, double changeRate) {
    libtraciJNI.Vehicle_openGap__SWIG_2(vehID, newTimeHeadway, newSpaceHeadway, duration, changeRate);
  }

  public static void deactivateGapControl(String vehID) {
    libtraciJNI.Vehicle_deactivateGapControl(vehID);
  }

  public static void requestToC(String vehID, double leadTime) {
    libtraciJNI.Vehicle_requestToC(vehID, leadTime);
  }

  public static void setSpeed(String vehID, double speed) {
    libtraciJNI.Vehicle_setSpeed(vehID, speed);
  }

  public static void setAcceleration(String vehID, double acceleration, double duration) {
    libtraciJNI.Vehicle_setAcceleration(vehID, acceleration, duration);
  }

  public static void setPreviousSpeed(String vehID, double prevSpeed, double prevAcceleration) {
    libtraciJNI.Vehicle_setPreviousSpeed__SWIG_0(vehID, prevSpeed, prevAcceleration);
  }

  public static void setPreviousSpeed(String vehID, double prevSpeed) {
    libtraciJNI.Vehicle_setPreviousSpeed__SWIG_1(vehID, prevSpeed);
  }

  public static void setSpeedMode(String vehID, int speedMode) {
    libtraciJNI.Vehicle_setSpeedMode(vehID, speedMode);
  }

  public static void setLaneChangeMode(String vehID, int laneChangeMode) {
    libtraciJNI.Vehicle_setLaneChangeMode(vehID, laneChangeMode);
  }

  public static void setRoutingMode(String vehID, int routingMode) {
    libtraciJNI.Vehicle_setRoutingMode(vehID, routingMode);
  }

  public static void setType(String vehID, String typeID) {
    libtraciJNI.Vehicle_setType(vehID, typeID);
  }

  public static void setRouteID(String vehID, String routeID) {
    libtraciJNI.Vehicle_setRouteID(vehID, routeID);
  }

  public static void setRoute(String vehID, String edgeID) {
    libtraciJNI.Vehicle_setRoute__SWIG_0(vehID, edgeID);
  }

  public static void setRoute(String vehID, StringVector edgeIDs) {
    libtraciJNI.Vehicle_setRoute__SWIG_1(vehID, StringVector.getCPtr(edgeIDs), edgeIDs);
  }

  public static void setLateralLanePosition(String vehID, double posLat) {
    libtraciJNI.Vehicle_setLateralLanePosition(vehID, posLat);
  }

  public static void updateBestLanes(String vehID) {
    libtraciJNI.Vehicle_updateBestLanes(vehID);
  }

  public static void setAdaptedTraveltime(String vehID, String edgeID, double time, double begSeconds, double endSeconds) {
    libtraciJNI.Vehicle_setAdaptedTraveltime__SWIG_0(vehID, edgeID, time, begSeconds, endSeconds);
  }

  public static void setAdaptedTraveltime(String vehID, String edgeID, double time, double begSeconds) {
    libtraciJNI.Vehicle_setAdaptedTraveltime__SWIG_1(vehID, edgeID, time, begSeconds);
  }

  public static void setAdaptedTraveltime(String vehID, String edgeID, double time) {
    libtraciJNI.Vehicle_setAdaptedTraveltime__SWIG_2(vehID, edgeID, time);
  }

  public static void setAdaptedTraveltime(String vehID, String edgeID) {
    libtraciJNI.Vehicle_setAdaptedTraveltime__SWIG_3(vehID, edgeID);
  }

  public static void setEffort(String vehID, String edgeID, double effort, double begSeconds, double endSeconds) {
    libtraciJNI.Vehicle_setEffort__SWIG_0(vehID, edgeID, effort, begSeconds, endSeconds);
  }

  public static void setEffort(String vehID, String edgeID, double effort, double begSeconds) {
    libtraciJNI.Vehicle_setEffort__SWIG_1(vehID, edgeID, effort, begSeconds);
  }

  public static void setEffort(String vehID, String edgeID, double effort) {
    libtraciJNI.Vehicle_setEffort__SWIG_2(vehID, edgeID, effort);
  }

  public static void setEffort(String vehID, String edgeID) {
    libtraciJNI.Vehicle_setEffort__SWIG_3(vehID, edgeID);
  }

  public static void rerouteTraveltime(String vehID, boolean currentTravelTimes) {
    libtraciJNI.Vehicle_rerouteTraveltime__SWIG_0(vehID, currentTravelTimes);
  }

  public static void rerouteTraveltime(String vehID) {
    libtraciJNI.Vehicle_rerouteTraveltime__SWIG_1(vehID);
  }

  public static void rerouteEffort(String vehID) {
    libtraciJNI.Vehicle_rerouteEffort(vehID);
  }

  public static void setSignals(String vehID, int signals) {
    libtraciJNI.Vehicle_setSignals(vehID, signals);
  }

  public static void moveTo(String vehID, String laneID, double pos, int reason) {
    libtraciJNI.Vehicle_moveTo__SWIG_0(vehID, laneID, pos, reason);
  }

  public static void moveTo(String vehID, String laneID, double pos) {
    libtraciJNI.Vehicle_moveTo__SWIG_1(vehID, laneID, pos);
  }

  public static void moveToXY(String vehID, String edgeID, int laneIndex, double x, double y, double angle, int keepRoute, double matchThreshold) {
    libtraciJNI.Vehicle_moveToXY__SWIG_0(vehID, edgeID, laneIndex, x, y, angle, keepRoute, matchThreshold);
  }

  public static void moveToXY(String vehID, String edgeID, int laneIndex, double x, double y, double angle, int keepRoute) {
    libtraciJNI.Vehicle_moveToXY__SWIG_1(vehID, edgeID, laneIndex, x, y, angle, keepRoute);
  }

  public static void moveToXY(String vehID, String edgeID, int laneIndex, double x, double y, double angle) {
    libtraciJNI.Vehicle_moveToXY__SWIG_2(vehID, edgeID, laneIndex, x, y, angle);
  }

  public static void moveToXY(String vehID, String edgeID, int laneIndex, double x, double y) {
    libtraciJNI.Vehicle_moveToXY__SWIG_3(vehID, edgeID, laneIndex, x, y);
  }

  public static void remove(String vehID, char reason) {
    libtraciJNI.Vehicle_remove__SWIG_0(vehID, reason);
  }

  public static void remove(String vehID) {
    libtraciJNI.Vehicle_remove__SWIG_1(vehID);
  }

  public static void setLine(String vehID, String line) {
    libtraciJNI.Vehicle_setLine(vehID, line);
  }

  public static void setVia(String vehID, StringVector edgeList) {
    libtraciJNI.Vehicle_setVia(vehID, StringVector.getCPtr(edgeList), edgeList);
  }

  public static void highlight(String vehID, TraCIColor col, double size, int alphaMax, double duration, int type) {
    libtraciJNI.Vehicle_highlight__SWIG_0(vehID, TraCIColor.getCPtr(col), col, size, alphaMax, duration, type);
  }

  public static void highlight(String vehID, TraCIColor col, double size, int alphaMax, double duration) {
    libtraciJNI.Vehicle_highlight__SWIG_1(vehID, TraCIColor.getCPtr(col), col, size, alphaMax, duration);
  }

  public static void highlight(String vehID, TraCIColor col, double size, int alphaMax) {
    libtraciJNI.Vehicle_highlight__SWIG_2(vehID, TraCIColor.getCPtr(col), col, size, alphaMax);
  }

  public static void highlight(String vehID, TraCIColor col, double size) {
    libtraciJNI.Vehicle_highlight__SWIG_3(vehID, TraCIColor.getCPtr(col), col, size);
  }

  public static void highlight(String vehID, TraCIColor col) {
    libtraciJNI.Vehicle_highlight__SWIG_4(vehID, TraCIColor.getCPtr(col), col);
  }

  public static void highlight(String vehID) {
    libtraciJNI.Vehicle_highlight__SWIG_5(vehID);
  }

  public static void dispatchTaxi(String vehID, StringVector reservations) {
    libtraciJNI.Vehicle_dispatchTaxi(vehID, StringVector.getCPtr(reservations), reservations);
  }

  public static void setLength(String typeID, double length) {
    libtraciJNI.Vehicle_setLength(typeID, length);
  }

  public static void setMaxSpeed(String typeID, double speed) {
    libtraciJNI.Vehicle_setMaxSpeed(typeID, speed);
  }

  public static void setVehicleClass(String typeID, String clazz) {
    libtraciJNI.Vehicle_setVehicleClass(typeID, clazz);
  }

  public static void setSpeedFactor(String typeID, double factor) {
    libtraciJNI.Vehicle_setSpeedFactor(typeID, factor);
  }

  public static void setAccel(String typeID, double accel) {
    libtraciJNI.Vehicle_setAccel(typeID, accel);
  }

  public static void setDecel(String typeID, double decel) {
    libtraciJNI.Vehicle_setDecel(typeID, decel);
  }

  public static void setEmergencyDecel(String typeID, double decel) {
    libtraciJNI.Vehicle_setEmergencyDecel(typeID, decel);
  }

  public static void setApparentDecel(String typeID, double decel) {
    libtraciJNI.Vehicle_setApparentDecel(typeID, decel);
  }

  public static void setImperfection(String typeID, double imperfection) {
    libtraciJNI.Vehicle_setImperfection(typeID, imperfection);
  }

  public static void setTau(String typeID, double tau) {
    libtraciJNI.Vehicle_setTau(typeID, tau);
  }

  public static void setEmissionClass(String typeID, String clazz) {
    libtraciJNI.Vehicle_setEmissionClass(typeID, clazz);
  }

  public static void setShapeClass(String typeID, String shapeClass) {
    libtraciJNI.Vehicle_setShapeClass(typeID, shapeClass);
  }

  public static void setWidth(String typeID, double width) {
    libtraciJNI.Vehicle_setWidth(typeID, width);
  }

  public static void setHeight(String typeID, double height) {
    libtraciJNI.Vehicle_setHeight(typeID, height);
  }

  public static void setMass(String typeID, double mass) {
    libtraciJNI.Vehicle_setMass(typeID, mass);
  }

  public static void setColor(String typeID, TraCIColor color) {
    libtraciJNI.Vehicle_setColor(typeID, TraCIColor.getCPtr(color), color);
  }

  public static void setMinGap(String typeID, double minGap) {
    libtraciJNI.Vehicle_setMinGap(typeID, minGap);
  }

  public static void setMinGapLat(String typeID, double minGapLat) {
    libtraciJNI.Vehicle_setMinGapLat(typeID, minGapLat);
  }

  public static void setMaxSpeedLat(String typeID, double speed) {
    libtraciJNI.Vehicle_setMaxSpeedLat(typeID, speed);
  }

  public static void setLateralAlignment(String typeID, String latAlignment) {
    libtraciJNI.Vehicle_setLateralAlignment(typeID, latAlignment);
  }

  public static void setActionStepLength(String typeID, double actionStepLength, boolean resetActionOffset) {
    libtraciJNI.Vehicle_setActionStepLength__SWIG_0(typeID, actionStepLength, resetActionOffset);
  }

  public static void setActionStepLength(String typeID, double actionStepLength) {
    libtraciJNI.Vehicle_setActionStepLength__SWIG_1(typeID, actionStepLength);
  }

  public static void setBoardingDuration(String typeID, double boardingDuration) {
    libtraciJNI.Vehicle_setBoardingDuration(typeID, boardingDuration);
  }

  public static void setImpatience(String typeID, double impatience) {
    libtraciJNI.Vehicle_setImpatience(typeID, impatience);
  }

  public static void subscribe(String objectID, IntVector varIDs, double begin, double end, TraCIResults parameters) {
    libtraciJNI.Vehicle_subscribe__SWIG_0(objectID, IntVector.getCPtr(varIDs), varIDs, begin, end, TraCIResults.getCPtr(parameters), parameters);
  }

  public static void subscribe(String objectID, IntVector varIDs, double begin, double end) {
    libtraciJNI.Vehicle_subscribe__SWIG_1(objectID, IntVector.getCPtr(varIDs), varIDs, begin, end);
  }

  public static void subscribe(String objectID, IntVector varIDs, double begin) {
    libtraciJNI.Vehicle_subscribe__SWIG_2(objectID, IntVector.getCPtr(varIDs), varIDs, begin);
  }

  public static void subscribe(String objectID, IntVector varIDs) {
    libtraciJNI.Vehicle_subscribe__SWIG_3(objectID, IntVector.getCPtr(varIDs), varIDs);
  }

  public static void subscribe(String objectID) {
    libtraciJNI.Vehicle_subscribe__SWIG_4(objectID);
  }

  public static void unsubscribe(String objectID) {
    libtraciJNI.Vehicle_unsubscribe(objectID);
  }

  public static void subscribeContext(String objectID, int domain, double dist, IntVector varIDs, double begin, double end, TraCIResults parameters) {
    libtraciJNI.Vehicle_subscribeContext__SWIG_0(objectID, domain, dist, IntVector.getCPtr(varIDs), varIDs, begin, end, TraCIResults.getCPtr(parameters), parameters);
  }

  public static void subscribeContext(String objectID, int domain, double dist, IntVector varIDs, double begin, double end) {
    libtraciJNI.Vehicle_subscribeContext__SWIG_1(objectID, domain, dist, IntVector.getCPtr(varIDs), varIDs, begin, end);
  }

  public static void subscribeContext(String objectID, int domain, double dist, IntVector varIDs, double begin) {
    libtraciJNI.Vehicle_subscribeContext__SWIG_2(objectID, domain, dist, IntVector.getCPtr(varIDs), varIDs, begin);
  }

  public static void subscribeContext(String objectID, int domain, double dist, IntVector varIDs) {
    libtraciJNI.Vehicle_subscribeContext__SWIG_3(objectID, domain, dist, IntVector.getCPtr(varIDs), varIDs);
  }

  public static void subscribeContext(String objectID, int domain, double dist) {
    libtraciJNI.Vehicle_subscribeContext__SWIG_4(objectID, domain, dist);
  }

  public static void unsubscribeContext(String objectID, int domain, double dist) {
    libtraciJNI.Vehicle_unsubscribeContext(objectID, domain, dist);
  }

  public static SubscriptionResults getAllSubscriptionResults() {
    return new SubscriptionResults(libtraciJNI.Vehicle_getAllSubscriptionResults(), true);
  }

  public static TraCIResults getSubscriptionResults(String objectID) {
    return new TraCIResults(libtraciJNI.Vehicle_getSubscriptionResults(objectID), true);
  }

  public static ContextSubscriptionResults getAllContextSubscriptionResults() {
    return new ContextSubscriptionResults(libtraciJNI.Vehicle_getAllContextSubscriptionResults(), true);
  }

  public static SubscriptionResults getContextSubscriptionResults(String objectID) {
    return new SubscriptionResults(libtraciJNI.Vehicle_getContextSubscriptionResults(objectID), true);
  }

  public static void subscribeParameterWithKey(String objectID, String key, double beginTime, double endTime) {
    libtraciJNI.Vehicle_subscribeParameterWithKey__SWIG_0(objectID, key, beginTime, endTime);
  }

  public static void subscribeParameterWithKey(String objectID, String key, double beginTime) {
    libtraciJNI.Vehicle_subscribeParameterWithKey__SWIG_1(objectID, key, beginTime);
  }

  public static void subscribeParameterWithKey(String objectID, String key) {
    libtraciJNI.Vehicle_subscribeParameterWithKey__SWIG_2(objectID, key);
  }

  public static int getDOMAIN_ID() {
    return libtraciJNI.Vehicle_DOMAIN_ID_get();
  }

  public static int domainID() {
    return libtraciJNI.Vehicle_domainID();
  }

  public static void subscribeLeader(String vehID, double dist, double begin, double end) {
    libtraciJNI.Vehicle_subscribeLeader__SWIG_0(vehID, dist, begin, end);
  }

  public static void subscribeLeader(String vehID, double dist, double begin) {
    libtraciJNI.Vehicle_subscribeLeader__SWIG_1(vehID, dist, begin);
  }

  public static void subscribeLeader(String vehID, double dist) {
    libtraciJNI.Vehicle_subscribeLeader__SWIG_2(vehID, dist);
  }

  public static void subscribeLeader(String vehID) {
    libtraciJNI.Vehicle_subscribeLeader__SWIG_3(vehID);
  }

  public static void addSubscriptionFilterLanes(IntVector lanes, boolean noOpposite, double downstreamDist, double upstreamDist) {
    libtraciJNI.Vehicle_addSubscriptionFilterLanes__SWIG_0(IntVector.getCPtr(lanes), lanes, noOpposite, downstreamDist, upstreamDist);
  }

  public static void addSubscriptionFilterLanes(IntVector lanes, boolean noOpposite, double downstreamDist) {
    libtraciJNI.Vehicle_addSubscriptionFilterLanes__SWIG_1(IntVector.getCPtr(lanes), lanes, noOpposite, downstreamDist);
  }

  public static void addSubscriptionFilterLanes(IntVector lanes, boolean noOpposite) {
    libtraciJNI.Vehicle_addSubscriptionFilterLanes__SWIG_2(IntVector.getCPtr(lanes), lanes, noOpposite);
  }

  public static void addSubscriptionFilterLanes(IntVector lanes) {
    libtraciJNI.Vehicle_addSubscriptionFilterLanes__SWIG_3(IntVector.getCPtr(lanes), lanes);
  }

  public static void addSubscriptionFilterNoOpposite() {
    libtraciJNI.Vehicle_addSubscriptionFilterNoOpposite();
  }

  public static void addSubscriptionFilterDownstreamDistance(double dist) {
    libtraciJNI.Vehicle_addSubscriptionFilterDownstreamDistance(dist);
  }

  public static void addSubscriptionFilterUpstreamDistance(double dist) {
    libtraciJNI.Vehicle_addSubscriptionFilterUpstreamDistance(dist);
  }

  public static void addSubscriptionFilterCFManeuver(double downstreamDist, double upstreamDist) {
    libtraciJNI.Vehicle_addSubscriptionFilterCFManeuver__SWIG_0(downstreamDist, upstreamDist);
  }

  public static void addSubscriptionFilterCFManeuver(double downstreamDist) {
    libtraciJNI.Vehicle_addSubscriptionFilterCFManeuver__SWIG_1(downstreamDist);
  }

  public static void addSubscriptionFilterCFManeuver() {
    libtraciJNI.Vehicle_addSubscriptionFilterCFManeuver__SWIG_2();
  }

  public static void addSubscriptionFilterLCManeuver(int direction, boolean noOpposite, double downstreamDist, double upstreamDist) {
    libtraciJNI.Vehicle_addSubscriptionFilterLCManeuver__SWIG_0(direction, noOpposite, downstreamDist, upstreamDist);
  }

  public static void addSubscriptionFilterLCManeuver(int direction, boolean noOpposite, double downstreamDist) {
    libtraciJNI.Vehicle_addSubscriptionFilterLCManeuver__SWIG_1(direction, noOpposite, downstreamDist);
  }

  public static void addSubscriptionFilterLCManeuver(int direction, boolean noOpposite) {
    libtraciJNI.Vehicle_addSubscriptionFilterLCManeuver__SWIG_2(direction, noOpposite);
  }

  public static void addSubscriptionFilterLCManeuver(int direction) {
    libtraciJNI.Vehicle_addSubscriptionFilterLCManeuver__SWIG_3(direction);
  }

  public static void addSubscriptionFilterLCManeuver() {
    libtraciJNI.Vehicle_addSubscriptionFilterLCManeuver__SWIG_4();
  }

  public static void addSubscriptionFilterLeadFollow(IntVector lanes) {
    libtraciJNI.Vehicle_addSubscriptionFilterLeadFollow(IntVector.getCPtr(lanes), lanes);
  }

  public static void addSubscriptionFilterTurn(double downstreamDist, double foeDistToJunction) {
    libtraciJNI.Vehicle_addSubscriptionFilterTurn__SWIG_0(downstreamDist, foeDistToJunction);
  }

  public static void addSubscriptionFilterTurn(double downstreamDist) {
    libtraciJNI.Vehicle_addSubscriptionFilterTurn__SWIG_1(downstreamDist);
  }

  public static void addSubscriptionFilterTurn() {
    libtraciJNI.Vehicle_addSubscriptionFilterTurn__SWIG_2();
  }

  public static void addSubscriptionFilterVClass(StringVector vClasses) {
    libtraciJNI.Vehicle_addSubscriptionFilterVClass(StringVector.getCPtr(vClasses), vClasses);
  }

  public static void addSubscriptionFilterVType(StringVector vTypes) {
    libtraciJNI.Vehicle_addSubscriptionFilterVType(StringVector.getCPtr(vTypes), vTypes);
  }

  public static void addSubscriptionFilterFieldOfVision(double openingAngle) {
    libtraciJNI.Vehicle_addSubscriptionFilterFieldOfVision(openingAngle);
  }

  public static void addSubscriptionFilterLateralDistance(double lateralDist, double downstreamDist, double upstreamDist) {
    libtraciJNI.Vehicle_addSubscriptionFilterLateralDistance__SWIG_0(lateralDist, downstreamDist, upstreamDist);
  }

  public static void addSubscriptionFilterLateralDistance(double lateralDist, double downstreamDist) {
    libtraciJNI.Vehicle_addSubscriptionFilterLateralDistance__SWIG_1(lateralDist, downstreamDist);
  }

  public static void addSubscriptionFilterLateralDistance(double lateralDist) {
    libtraciJNI.Vehicle_addSubscriptionFilterLateralDistance__SWIG_2(lateralDist);
  }

}
