/****************************************************************************/
// Eclipse SUMO, Simulation of Urban MObility; see https://eclipse.dev/sumo
// Copyright (C) 2001-2026 German Aerospace Center (DLR) and others.
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License 2.0 which is available at
// https://www.eclipse.org/legal/epl-2.0/
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License 2.0 are satisfied: GNU General Public License, version 2
// or later which is available at
// https://www.gnu.org/licenses/old-licenses/gpl-2.0-standalone.html
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-or-later
/****************************************************************************/
/// @file    MSChargingStationExport.h
/// @author  Mirko Barthauer
/// @date    2024-07-24
///
// Realises dumping ChargingStation charging events
/****************************************************************************/
#pragma once
#include <config.h>

#include <utils/common/SUMOTime.h>


// ===========================================================================
// class declarations
// ===========================================================================
class OutputDevice;


// ===========================================================================
// class definitions
// ===========================================================================
/**
 * @class MSBatteryExport
 * @brief Realises dumping Battery Data
 *
 *  The class offers a static method, which writes all available Battery factors
 *  of each vehicles of the network into the given OutputDevice.
 *
 * @todo consider error-handling on write (using IOError)
 */
class MSChargingStationExport {
public:
    /** @brief Writes the recently completed charging events
     *
     *  Any charging event which ended and hasn't been written will get its data aggregated
     *  and written to output.
     *
     * @param[in] of The output device to use
     * @param[in] end Whether the simulation ends
     * @exception IOError If an error on writing occurs (!!! not yet implemented)
     */
    static void write(OutputDevice& of, bool end = false);


private:
    /// @brief Invalidated copy constructor.
    MSChargingStationExport(const MSChargingStationExport&);

    /// @brief Invalidated assignment operator.
    MSChargingStationExport& operator=(const MSChargingStationExport&);

};
