/****************************************************************************/
// Eclipse SUMO, Simulation of Urban MObility; see https://eclipse.dev/sumo
// Copyright (C) 2001-2026 German Aerospace Center (DLR) and others.
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License 2.0 which is available at
// https://www.eclipse.org/legal/epl-2.0/
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License 2.0 are satisfied: GNU General Public License, version 2
// or later which is available at
// https://www.gnu.org/licenses/old-licenses/gpl-2.0-standalone.html
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-or-later
/****************************************************************************/
/// @file    GNEChange_Connection.cpp
/// @author  Jakob Erdmann
/// @date    May 2011
///
// A network change in which a single connection is created or deleted
/****************************************************************************/

#include <netedit/GNENet.h>

#include "GNEChange_Connection.h"

// ===========================================================================
// FOX-declarations
// ===========================================================================

FXIMPLEMENT_ABSTRACT(GNEChange_Connection, GNEChange, nullptr, 0)

// ===========================================================================
// member method definitions
// ===========================================================================


GNEChange_Connection::GNEChange_Connection(GNEEdge* edge, NBEdge::Connection nbCon, bool selected, bool forward) :
    GNEChange(Supermode::NETWORK, forward, selected),
    myEdge(edge),
    myNBEdgeConnection(nbCon) {
}


GNEChange_Connection::~GNEChange_Connection() {
}


void
GNEChange_Connection::undo() {
    if (myForward) {
        // remove connection from edge
        myEdge->removeConnection(myNBEdgeConnection);
    } else {
        // add connection into edge
        myEdge->addConnection(myNBEdgeConnection, mySelectedElement);
    }
    // enable save networkElements
    myEdge->getNet()->getSavingStatus()->requireSaveNetwork();
}


void
GNEChange_Connection::redo() {
    if (myForward) {
        // add connection into edge
        myEdge->addConnection(myNBEdgeConnection, mySelectedElement);
    } else {
        // remove connection from edge
        myEdge->removeConnection(myNBEdgeConnection);
    }
    // enable save networkElements
    myEdge->getNet()->getSavingStatus()->requireSaveNetwork();
}


std::string
GNEChange_Connection::undoName() const {
    if (myForward) {
        return (TL("Undo create ") + toString(SUMO_TAG_CONNECTION) + " '" +
                toString(myNBEdgeConnection.fromLane) + "->" + toString(myNBEdgeConnection.fromLane) + "'");
    } else {
        return (TL("Undo delete ") + toString(SUMO_TAG_CONNECTION) + " '" +
                toString(myNBEdgeConnection.fromLane) + "->" + toString(myNBEdgeConnection.fromLane) + "'");
    }
}


std::string
GNEChange_Connection::redoName() const {
    if (myForward) {
        return (TL("Redo create connection '") +
                toString(myNBEdgeConnection.fromLane) + "->" + toString(myNBEdgeConnection.fromLane) + "'");
    } else {
        return (TL("Redo delete connection '") +
                toString(myNBEdgeConnection.fromLane) + "->" + toString(myNBEdgeConnection.fromLane) + "'");
    }
}
