/*
 * Decompiled with CFR 0.152.
 */
package de.tudresden.sumo.cmd;

import de.tudresden.sumo.objects.SumoColor;
import de.tudresden.sumo.objects.SumoStopFlags;
import de.tudresden.sumo.objects.SumoStringList;
import de.tudresden.sumo.util.SumoCommand;

public class Vehicle {
    public static SumoCommand getAccel(String vehID) {
        return new SumoCommand(164, 70, vehID, 180, 11);
    }

    public static SumoCommand getActionStepLength(String vehID) {
        return new SumoCommand(164, 125, vehID, 180, 11);
    }

    public static SumoCommand getIDCount() {
        return new SumoCommand(164, 1, "", 180, 9);
    }

    public static SumoCommand getAdaptedTraveltime(String vehID, double time, String edgeID) {
        Object[] array = new Object[]{time, edgeID};
        return new SumoCommand(164, 88, (Object)vehID, array, 180, 11);
    }

    public static SumoCommand getAngle(String vehID) {
        return new SumoCommand(164, 67, vehID, 180, 11);
    }

    public static SumoCommand getApparentDecel(String vehID) {
        return new SumoCommand(164, 124, vehID, 180, 11);
    }

    public static SumoCommand getMaxSpeedLat(String vehID) {
        return new SumoCommand(164, 186, vehID, 180, 11);
    }

    public static SumoCommand getMinGapLat(String vehID) {
        return new SumoCommand(164, 187, vehID, 180, 11);
    }

    public static SumoCommand getAllowedSpeed(String vehID) {
        return new SumoCommand(164, 183, vehID, 180, 11);
    }

    public static SumoCommand getHeight(String vehID) {
        return new SumoCommand(164, 188, vehID, 180, 11);
    }

    public static SumoCommand getLateralLanePosition(String vehID) {
        return new SumoCommand(164, 184, vehID, 180, 11);
    }

    public static SumoCommand getLaneChangeState(String vehID, int direction) {
        Object[] array = new Object[]{direction};
        return new SumoCommand(196, 19, (Object)vehID, array, 180, 15);
    }

    public static SumoCommand getEmergencyDecel(String vehID) {
        return new SumoCommand(196, 123, vehID, 180, 11);
    }

    public static SumoCommand getLastActionTime(String vehID) {
        return new SumoCommand(164, 127, vehID, 180, 11);
    }

    public static SumoCommand getLateralAlignment(String vehID) {
        return new SumoCommand(164, 185, vehID, 180, 12);
    }

    public static SumoCommand getLaneChangeMode(String vehID) {
        return new SumoCommand(164, 182, vehID, 180, 9);
    }

    public static SumoCommand getLeader(String vehID, double dist) {
        Object[] array = new Object[]{dist};
        return new SumoCommand(164, 104, (Object)vehID, array, 180, 15);
    }

    public static SumoCommand getPersonNumber(String vehID) {
        return new SumoCommand(164, 103, vehID, 180, 9);
    }

    public static SumoCommand getBestLanes(String vehID) {
        return new SumoCommand(164, 178, vehID, 180, 15);
    }

    public static SumoCommand getCO2Emission(String vehID) {
        return new SumoCommand(164, 96, vehID, 180, 11);
    }

    public static SumoCommand getCOEmission(String vehID) {
        return new SumoCommand(164, 97, vehID, 180, 11);
    }

    public static SumoCommand getColor(String vehID) {
        return new SumoCommand(164, 69, vehID, 180, 17);
    }

    public static SumoCommand getDecel(String vehID) {
        return new SumoCommand(164, 71, vehID, 180, 11);
    }

    public static SumoCommand getDrivingDistance(String vehID, String edgeID, double pos, byte laneID) {
        Object[] array = new Object[]{edgeID, pos, laneID};
        return new SumoCommand(164, 131, (Object)vehID, array, 180, 11);
    }

    public static SumoCommand getDrivingDistance2D(String vehID, double x, double y) {
        Object[] array = new Object[]{x, y};
        return new SumoCommand(164, 131, (Object)vehID, array, 180, 11);
    }

    public static SumoCommand getDistance(String vehID) {
        return new SumoCommand(164, 132, vehID, 180, 11);
    }

    public static SumoCommand getEffort(String vehID, double time, String edgeID) {
        Object[] array = new Object[]{time, edgeID};
        return new SumoCommand(164, 89, (Object)vehID, array, 180, 11);
    }

    public static SumoCommand getEmissionClass(String vehID) {
        return new SumoCommand(164, 74, vehID, 180, 12);
    }

    public static SumoCommand getElectricityConsumption(String vehID) {
        return new SumoCommand(164, 113, vehID, 180, 11);
    }

    public static SumoCommand getFuelConsumption(String vehID) {
        return new SumoCommand(164, 101, vehID, 180, 11);
    }

    public static SumoCommand getHCEmission(String vehID) {
        return new SumoCommand(164, 98, vehID, 180, 11);
    }

    public static SumoCommand getIDList() {
        return new SumoCommand(164, 0, "", 180, 14);
    }

    public static SumoCommand getImperfection(String vehID) {
        return new SumoCommand(164, 93, vehID, 180, 11);
    }

    public static SumoCommand getLaneID(String vehID) {
        return new SumoCommand(164, 81, vehID, 180, 12);
    }

    public static SumoCommand getLaneIndex(String vehID) {
        return new SumoCommand(164, 82, vehID, 180, 9);
    }

    public static SumoCommand getLanePosition(String vehID) {
        return new SumoCommand(164, 86, vehID, 180, 11);
    }

    public static SumoCommand getLength(String vehID) {
        return new SumoCommand(164, 68, vehID, 180, 11);
    }

    public static SumoCommand getLine(String vehID) {
        return new SumoCommand(164, 189, vehID, 180, 12);
    }

    public static SumoCommand getMaxSpeed(String vehID) {
        return new SumoCommand(164, 65, vehID, 180, 11);
    }

    public static SumoCommand getMinGap(String vehID) {
        return new SumoCommand(164, 76, vehID, 180, 11);
    }

    public static SumoCommand getNextTLS(String vehID) {
        return new SumoCommand(164, 112, vehID, 180, 15);
    }

    public static SumoCommand getNextStops(String vehID) {
        return new SumoCommand(164, 115, vehID, 180, 15);
    }

    public static SumoCommand getNOxEmission(String vehID) {
        return new SumoCommand(164, 100, vehID, 180, 11);
    }

    public static SumoCommand getNoiseEmission(String vehID) {
        return new SumoCommand(164, 102, vehID, 180, 11);
    }

    public static SumoCommand getParameter(String vehID, String param) {
        Object[] array = new Object[]{param};
        return new SumoCommand(164, 126, (Object)vehID, array, 180, 12);
    }

    public static SumoCommand setParameter(String vehID, String param, String value) {
        Object[] array = new Object[]{param, value};
        return new SumoCommand(196, 126, (Object)vehID, array);
    }

    public static SumoCommand getPMxEmission(String vehID) {
        return new SumoCommand(164, 99, vehID, 180, 11);
    }

    public static SumoCommand getPosition(String vehID) {
        return new SumoCommand(164, 66, vehID, 180, 1);
    }

    public static SumoCommand getPosition3D(String vehID) {
        return new SumoCommand(164, 57, vehID, 180, 3);
    }

    public static SumoCommand getRoadID(String vehID) {
        return new SumoCommand(164, 80, vehID, 180, 12);
    }

    public static SumoCommand getRoute(String vehID) {
        return new SumoCommand(164, 84, vehID, 180, 14);
    }

    public static SumoCommand getRouteID(String vehID) {
        return new SumoCommand(164, 83, vehID, 180, 12);
    }

    public static SumoCommand getRouteIndex(String vehID) {
        return new SumoCommand(164, 105, vehID, 180, 9);
    }

    public static SumoCommand getRoutingMode(String vehID) {
        return new SumoCommand(164, 137, vehID, 180, 9);
    }

    public static SumoCommand getShapeClass(String vehID) {
        return new SumoCommand(164, 75, vehID, 180, 12);
    }

    public static SumoCommand getSignals(String vehID) {
        return new SumoCommand(164, 91, vehID, 180, 9);
    }

    public static SumoCommand getSlope(String vehID) {
        return new SumoCommand(164, 54, vehID, 180, 11);
    }

    public static SumoCommand getSpeed(String vehID) {
        return new SumoCommand(164, 64, vehID, 180, 11);
    }

    public static SumoCommand getSpeedDeviation(String vehID) {
        return new SumoCommand(164, 95, vehID, 180, 11);
    }

    public static SumoCommand getSpeedFactor(String vehID) {
        return new SumoCommand(164, 94, vehID, 180, 11);
    }

    public static SumoCommand getSpeedMode(String vehID) {
        return new SumoCommand(164, 179, vehID, 180, 9);
    }

    public static SumoCommand getSpeedWithoutTraCI(String vehID) {
        return new SumoCommand(164, 177, vehID, 180, 11);
    }

    public static SumoCommand getStopState(String vehID) {
        return new SumoCommand(164, 181, vehID, 180, 7);
    }

    public static SumoCommand getTau(String vehID) {
        return new SumoCommand(164, 72, vehID, 180, 11);
    }

    public static SumoCommand getVia(String vehID) {
        return new SumoCommand(164, 190, vehID, 180, 14);
    }

    public static SumoCommand getWaitingTime(String vehID) {
        return new SumoCommand(164, 122, vehID, 180, 11);
    }

    public static SumoCommand getTypeID(String vehID) {
        return new SumoCommand(164, 79, vehID, 180, 12);
    }

    public static SumoCommand getPersonIDList(String vehID) {
        return new SumoCommand(164, 26, vehID, 180, 9);
    }

    public static SumoCommand getVehicleClass(String vehID) {
        return new SumoCommand(164, 73, vehID, 180, 12);
    }

    public static SumoCommand getAccumulatedWaitingTime(String vehID) {
        return new SumoCommand(164, 135, vehID, 180, 11);
    }

    public static SumoCommand getWidth(String vehID) {
        return new SumoCommand(164, 77, vehID, 180, 11);
    }

    public static SumoCommand isStopped(String vehID) {
        return new SumoCommand(164, 181, (Object)vehID, 180, 9, "isStopped");
    }

    public static SumoCommand isStoppedTriggered(String vehID) {
        return new SumoCommand(164, 181, (Object)vehID, 180, 7, "isStoppedTriggered");
    }

    public static SumoCommand isAtContainerStop(String vehID) {
        return new SumoCommand(164, 181, (Object)vehID, 180, 7, "isAtContainerStop");
    }

    public static SumoCommand isStoppedParking(String vehID) {
        return new SumoCommand(164, 181, (Object)vehID, 180, 7, "isStoppedParking");
    }

    public static SumoCommand isAtBusStop(String vehID) {
        return new SumoCommand(164, 181, (Object)vehID, 180, 7, "isAtBusStop");
    }

    public static SumoCommand isRouteValid(String vehID) {
        return new SumoCommand(164, 146, vehID, 180, 7);
    }

    public static SumoCommand slowDown(String vehID, double speed, double duration) {
        Object[] array = new Object[]{speed, duration};
        return new SumoCommand(196, 20, (Object)vehID, array, 180, 9);
    }

    public static SumoCommand add(String vehID, String typeID, String routeID, int depart, double pos, double speed, byte lane) {
        Object[] array = new Object[]{typeID, routeID, depart, pos, speed, lane};
        return new SumoCommand(196, 128, (Object)vehID, array);
    }

    public static SumoCommand addFull(String vehID, String routeID, String typeID, String depart, String departLane, String departPosition, String departSpeed, String arrivalLane, String arrivalPosition, String arrivalSpeed, String fromTAZ, String toTAZ, String line, int person_capacity, int person_number) {
        Object[] array = new Object[]{routeID, typeID, depart, departLane, departPosition, departSpeed, arrivalLane, arrivalPosition, arrivalSpeed, fromTAZ, toTAZ, line, person_capacity, person_number};
        return new SumoCommand(196, 133, (Object)vehID, array);
    }

    public static SumoCommand changeLane(String vehID, byte laneIndex, double duration) {
        Object[] array = new Object[]{laneIndex, duration};
        return new SumoCommand(196, 19, (Object)vehID, array);
    }

    public static SumoCommand changeTarget(String vehID, String edgeID) {
        return new SumoCommand(196, 49, (Object)vehID, edgeID);
    }

    public static SumoCommand changeSublane(String vehID, double latDist) {
        return new SumoCommand(196, 21, (Object)vehID, latDist);
    }

    public static SumoCommand moveTo(String vehID, String laneID, double pos) {
        Object[] array = new Object[]{laneID, pos};
        return new SumoCommand(196, 92, (Object)vehID, array);
    }

    public static SumoCommand moveToXY(String vehID, String edgeID, int lane, double x, double y, double angle, byte keepRoute) {
        Object[] array = new Object[]{edgeID, lane, x, y, angle, keepRoute};
        return new SumoCommand(196, 180, (Object)vehID, array);
    }

    public static SumoCommand remove(String vehID, byte reason) {
        return new SumoCommand(196, 129, (Object)vehID, reason);
    }

    public static SumoCommand rerouteEffort(String vehID) {
        Object[] array = new Object[]{vehID};
        return new SumoCommand(196, 145, (Object)vehID, array);
    }

    public static SumoCommand rerouteTraveltime(String vehID) {
        Object[] array = new Object[]{vehID};
        return new SumoCommand(196, 144, (Object)vehID, array);
    }

    public static SumoCommand setAccel(String vehID, double accel) {
        return new SumoCommand(196, 70, (Object)vehID, accel);
    }

    public static SumoCommand setAdaptedTraveltime(String vehID, double begTime, double endTime, String edgeID, double time) {
        Object[] array = new Object[]{begTime, endTime, edgeID, time};
        return new SumoCommand(196, 88, (Object)vehID, array);
    }

    public static SumoCommand setLateralAlignment(String vehID, String align) {
        Object[] array = new Object[]{align};
        return new SumoCommand(196, 185, (Object)vehID, array);
    }

    public static SumoCommand setApparentDecel(String vehID, double decel) {
        Object[] array = new Object[]{decel};
        return new SumoCommand(196, 124, (Object)vehID, array);
    }

    public static SumoCommand setMinGapLat(String vehID, double minGapLat) {
        Object[] array = new Object[]{minGapLat};
        return new SumoCommand(196, 187, (Object)vehID, array);
    }

    public static SumoCommand setColor(String vehID, SumoColor color) {
        return new SumoCommand(196, 69, (Object)vehID, color);
    }

    public static SumoCommand setDecel(String vehID, double decel) {
        return new SumoCommand(196, 71, (Object)vehID, decel);
    }

    public static SumoCommand setHeight(String vehID, double height) {
        return new SumoCommand(196, 188, (Object)vehID, height);
    }

    public static SumoCommand setLaneChangeMode(String vehID, int lcm) {
        return new SumoCommand(196, 182, (Object)vehID, lcm);
    }

    public static SumoCommand setEmergencyDecel(String vehID, double decel) {
        return new SumoCommand(196, 123, (Object)vehID, decel);
    }

    public static SumoCommand setRoute(String vehID, SumoStringList edgeList) {
        Object[] array = new Object[]{edgeList};
        return new SumoCommand(196, 87, (Object)vehID, array);
    }

    public static SumoCommand setRoutingMode(String vehID, int routingMode) {
        return new SumoCommand(196, 137, (Object)vehID, routingMode);
    }

    public static SumoCommand setType(String vehID, String typeID) {
        return new SumoCommand(196, 79, (Object)vehID, typeID);
    }

    public static SumoCommand setEffort(String vehID, int begTime, int endTime, String edgeID, double effort) {
        Object[] array = new Object[]{begTime, endTime, edgeID, effort};
        return new SumoCommand(196, 89, (Object)vehID, array);
    }

    public static SumoCommand setEmissionClass(String vehID, String clazz) {
        return new SumoCommand(196, 74, (Object)vehID, clazz);
    }

    public static SumoCommand setImperfection(String vehID, double imperfection) {
        return new SumoCommand(196, 93, (Object)vehID, imperfection);
    }

    public static SumoCommand setLength(String vehID, double length) {
        return new SumoCommand(196, 68, (Object)vehID, length);
    }

    public static SumoCommand setActionStepLength(String vehID, double actionStepLength, boolean resetActionOffset) {
        if (!resetActionOffset) {
            actionStepLength *= -1.0;
        }
        return new SumoCommand(196, 125, (Object)vehID, actionStepLength);
    }

    public static SumoCommand setLine(String vehID, String line) {
        return new SumoCommand(196, 189, (Object)vehID, line);
    }

    public static SumoCommand setVia(String vehID, SumoStringList edgeList) {
        Object[] array = new Object[]{edgeList};
        return new SumoCommand(196, 190, (Object)vehID, array);
    }

    public static SumoCommand setMaxSpeed(String vehID, double speed) {
        return new SumoCommand(196, 65, (Object)vehID, speed);
    }

    public static SumoCommand setMaxSpeedLat(String vehID, double speed) {
        return new SumoCommand(196, 186, (Object)vehID, speed);
    }

    public static SumoCommand setMinGap(String vehID, double minGap) {
        return new SumoCommand(196, 76, (Object)vehID, minGap);
    }

    public static SumoCommand setRouteID(String vehID, String routeID) {
        return new SumoCommand(196, 83, (Object)vehID, routeID);
    }

    public static SumoCommand setShapeClass(String vehID, String clazz) {
        return new SumoCommand(196, 75, (Object)vehID, clazz);
    }

    public static SumoCommand setSignals(String vehID, int signals) {
        return new SumoCommand(196, 91, (Object)vehID, signals);
    }

    public static SumoCommand setSpeed(String vehID, double speed) {
        return new SumoCommand(196, 64, (Object)vehID, speed);
    }

    public static SumoCommand setSpeedDeviation(String vehID, double deviation) {
        return new SumoCommand(196, 95, (Object)vehID, deviation);
    }

    public static SumoCommand setSpeedFactor(String vehID, double factor) {
        return new SumoCommand(196, 94, (Object)vehID, factor);
    }

    public static SumoCommand setSpeedMode(String vehID, int sm) {
        return new SumoCommand(196, 179, (Object)vehID, sm);
    }

    public static SumoCommand setStop(String vehID, String edgeID, double pos, byte laneIndex, double duration, SumoStopFlags sf, double startPos, double until) {
        Object[] array = new Object[]{edgeID, pos, laneIndex, duration, sf, startPos, until};
        return new SumoCommand(196, 18, (Object)vehID, array);
    }

    public static SumoCommand setChargingStationStop(String vehID, String stopID, double duration, double until) {
        SumoStopFlags sf = new SumoStopFlags(false, false, false, false, false, true, false);
        return Vehicle.setStop(vehID, stopID, 1.0, (byte)0, duration, sf, -1.073741824E9, until);
    }

    public static SumoCommand setBusStop(String vehID, String stopID, double duration, double until) {
        SumoStopFlags sf = new SumoStopFlags(false, false, false, true, false, false, false);
        return Vehicle.setStop(vehID, stopID, 1.0, (byte)0, duration, sf, -1.073741824E9, until);
    }

    public static SumoCommand setContainerStop(String vehID, String stopID, double duration, double until) {
        SumoStopFlags sf = new SumoStopFlags(false, false, false, false, true, false, false);
        return Vehicle.setStop(vehID, stopID, 1.0, (byte)0, duration, sf, -1.073741824E9, until);
    }

    public static SumoCommand setParkingAreaStop(String vehID, String stopID, double duration, double until) {
        SumoStopFlags sf = new SumoStopFlags(true, false, false, false, false, false, true);
        return Vehicle.setStop(vehID, stopID, 1.0, (byte)0, duration, sf, -1.073741824E9, until);
    }

    public static SumoCommand resume(String vehID) {
        Object[] array = new Object[]{vehID};
        return new SumoCommand(196, 25, (Object)vehID, array);
    }

    public static SumoCommand setTau(String vehID, double tau) {
        return new SumoCommand(196, 72, (Object)vehID, tau);
    }

    public static SumoCommand setVehicleClass(String vehID, String clazz) {
        return new SumoCommand(196, 73, (Object)vehID, clazz);
    }

    public static SumoCommand setWidth(String vehID, double width) {
        return new SumoCommand(196, 77, (Object)vehID, width);
    }

    public static SumoCommand updateBestLanes(String vehID) {
        return new SumoCommand(196, 106, (Object)vehID, "");
    }

    public static SumoCommand rerouteParkingArea(String vehID, String parkingAreaID) {
        return new SumoCommand(196, 106, (Object)vehID, parkingAreaID);
    }
}

