/*
 * Decompiled with CFR 0.152.
 */
package de.tudresden.sumo.subscription;

public enum ResponseType {
    UNKNOWN(-1, false),
    EDGE_VARIABLE(234, true),
    AREAL_DETECTOR_VARIABLE(237, true),
    PERSON_VARIABLE(238, true),
    MULTI_ENTRY_EXIT_DETECTOR_VARIABLE(225, true),
    JUNCTION_VARIABLE(233, true),
    VEHICLE_VARIABLE(228, true),
    INDUCTIONLOOP_VARIABLE(224, true),
    GUI_VARIABLE(236, true),
    POI_VARIABLE(231, true),
    VEHICLETYPE_VARIABLE(229, true),
    LANE_VARIABLE(227, true),
    POLYGON_VARIABLE(232, true),
    TL_VARIABLE(226, true),
    ROUTE_VARIABLE(230, true),
    SIM_VARIABLE(235, true),
    POLYGON_CONTEXT(152, false),
    EDGE_CONTEXT(154, false),
    AREAL_DETECTOR_CONTEXT(157, false),
    PERSON_CONTEXT(158, false),
    POI_CONTEXT(151, false),
    GUI_CONTEXT(156, false),
    MULTI_ENTRY_EXIT_DETECTOR_CONTEXT(145, false),
    INDUCTIONLOOP_CONTEXT(144, false),
    ROUTE_CONTEXT(150, false),
    VEHICLE_CONTEXT(148, false),
    VEHICLETYPE_CONTEXT(149, false),
    JUNCTION_CONTEXT(153, false),
    SIM_CONTEXT(155, false),
    LANE_CONTEXT(147, false),
    TL_CONTEXT(146, false);

    boolean variable;
    int id;

    private ResponseType(int id, boolean variable) {
        this.id = id;
        this.variable = variable;
    }

    public boolean isVariable() {
        return this.variable;
    }

    public boolean isContext() {
        return !this.variable;
    }

    public static ResponseType getType(int response) {
        ResponseType rt;
        switch (response) {
            case 234: {
                rt = EDGE_VARIABLE;
                break;
            }
            case 237: {
                rt = AREAL_DETECTOR_VARIABLE;
                break;
            }
            case 238: {
                rt = PERSON_VARIABLE;
                break;
            }
            case 225: {
                rt = MULTI_ENTRY_EXIT_DETECTOR_VARIABLE;
                break;
            }
            case 233: {
                rt = JUNCTION_VARIABLE;
                break;
            }
            case 228: {
                rt = VEHICLE_VARIABLE;
                break;
            }
            case 224: {
                rt = INDUCTIONLOOP_VARIABLE;
                break;
            }
            case 236: {
                rt = GUI_VARIABLE;
                break;
            }
            case 231: {
                rt = POI_VARIABLE;
                break;
            }
            case 229: {
                rt = VEHICLETYPE_VARIABLE;
                break;
            }
            case 227: {
                rt = LANE_VARIABLE;
                break;
            }
            case 232: {
                rt = POLYGON_VARIABLE;
                break;
            }
            case 226: {
                rt = TL_VARIABLE;
                break;
            }
            case 230: {
                rt = ROUTE_VARIABLE;
                break;
            }
            case 235: {
                rt = SIM_VARIABLE;
                break;
            }
            case 152: {
                rt = POLYGON_CONTEXT;
                break;
            }
            case 154: {
                rt = EDGE_CONTEXT;
                break;
            }
            case 157: {
                rt = AREAL_DETECTOR_CONTEXT;
                break;
            }
            case 158: {
                rt = PERSON_CONTEXT;
                break;
            }
            case 151: {
                rt = POI_CONTEXT;
                break;
            }
            case 156: {
                rt = GUI_CONTEXT;
                break;
            }
            case 145: {
                rt = MULTI_ENTRY_EXIT_DETECTOR_CONTEXT;
                break;
            }
            case 144: {
                rt = INDUCTIONLOOP_CONTEXT;
                break;
            }
            case 150: {
                rt = ROUTE_CONTEXT;
                break;
            }
            case 148: {
                rt = VEHICLE_CONTEXT;
                break;
            }
            case 149: {
                rt = VEHICLETYPE_CONTEXT;
                break;
            }
            case 153: {
                rt = JUNCTION_CONTEXT;
                break;
            }
            case 155: {
                rt = SIM_CONTEXT;
                break;
            }
            case 147: {
                rt = LANE_CONTEXT;
                break;
            }
            case 146: {
                rt = TL_CONTEXT;
                break;
            }
            default: {
                rt = UNKNOWN;
            }
        }
        return rt;
    }
}

