/*
 * Decompiled with CFR 0.152.
 */
package it.polito.appeal.traci;

import de.tudresden.sumo.subscription.Subscription;
import de.tudresden.sumo.util.CommandProcessor;
import de.tudresden.sumo.util.Observer;
import de.tudresden.sumo.util.SumoCommand;
import it.polito.appeal.traci.CloseQuery;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.List;

public class SumoTraciConnection {
    static boolean stdout = false;
    static boolean stderr = true;
    private String configFile;
    private int randomSeed = -1;
    private int remotePort;
    private Socket socket;
    private String net_file;
    private String route_file;
    private String additional_file;
    private String gui_settings;
    String sumoEXE = "/opt/sumo/sumo-1.1.0/bin/sumo";
    private CommandProcessor cp;
    private Process sumoProcess;
    private static final int CONNECT_RETRIES = 3;
    private CloseQuery closeQuery;
    private List<String> args = new ArrayList<String>();
    private boolean remote = false;

    public SumoTraciConnection(String sumo_bin) {
        this.sumoEXE = sumo_bin;
    }

    public SumoTraciConnection(String sumo_bin, String net_file, String route_file) {
        this.sumoEXE = sumo_bin;
        this.net_file = net_file;
        this.route_file = route_file;
    }

    public SumoTraciConnection(String sumo_bin, String net_file, String route_file, String additional_file) {
        this.sumoEXE = sumo_bin;
        this.net_file = net_file;
        this.route_file = route_file;
        this.additional_file = additional_file;
    }

    public SumoTraciConnection(String sumo_bin, String net_file, String route_file, String additional_file, String gui_settings) {
        this.sumoEXE = sumo_bin;
        this.net_file = net_file;
        this.route_file = route_file;
        this.additional_file = additional_file;
        this.gui_settings = gui_settings;
    }

    public SumoTraciConnection(String sumo_bin, String configFile) {
        this.sumoEXE = sumo_bin;
        this.configFile = configFile;
    }

    public SumoTraciConnection(String configFile, int randomSeed, boolean useGeoOffset) {
        this.randomSeed = randomSeed;
        this.configFile = configFile;
    }

    public SumoTraciConnection(int remotePort) throws IOException, InterruptedException {
        this(new InetSocketAddress("127.0.0.1", remotePort));
    }

    public SumoTraciConnection(SocketAddress sockAddr) throws IOException, InterruptedException {
        System.err.println("TraAS and TraCI4J are deprecated. Please use libtracijni instead, see https://sumo.dlr.de/docs/Libtraci.html.");
        this.remote = true;
        this.socket = new Socket();
        this.socket.setTcpNoDelay(true);
        int waitTime = 500;
        for (int i = 0; i < 3; ++i) {
            try {
                this.socket.connect(sockAddr);
                break;
            }
            catch (ConnectException ce) {
                Thread.sleep(waitTime);
                waitTime *= 2;
                continue;
            }
        }
        if (!this.socket.isConnected()) {
            throw new IOException("can't connect to SUMO server");
        }
        this.cp = new CommandProcessor(this.socket);
    }

    public void addOption(String option, String value) {
        this.args.add("--" + option);
        if (value != null) {
            this.args.add(value);
        }
    }

    public void runServer() throws IOException {
        this.runServer(0);
    }

    public void runServer(int _remotePort) throws IOException {
        System.err.println("TraAS and TraCI4J are deprecated. Please use libtracijni instead, see https://sumo.dlr.de/docs/Libtraci.html.");
        if (!this.remote) {
            this.remotePort = _remotePort;
            if (this.remotePort == 0) {
                this.findAvailablePort();
            }
            this.runSUMO();
            int waitTime = 500;
            try {
                for (int i = 0; i < 3; ++i) {
                    this.socket = new Socket();
                    this.socket.setTcpNoDelay(true);
                    try {
                        this.socket.connect(new InetSocketAddress("127.0.0.1", this.remotePort));
                        break;
                    }
                    catch (ConnectException ce) {
                        Thread.sleep(waitTime);
                        waitTime *= 2;
                        continue;
                    }
                }
                if (!this.socket.isConnected()) {
                    throw new IOException("can't connect to SUMO server at " + this.remotePort);
                }
                this.cp = new CommandProcessor(this.socket);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this.closeQuery = new CloseQuery(this.socket);
        }
    }

    private void runSUMO() throws IOException {
        this.args.add(0, this.sumoEXE);
        if (this.configFile != null) {
            this.args.add("-c");
            this.args.add(this.configFile);
        } else if (this.net_file != null && this.route_file != null) {
            this.args.add("--net-file");
            this.args.add(this.net_file);
            this.args.add("--route-files");
            this.args.add(this.route_file);
            if (this.additional_file != null) {
                this.args.add("--additional-files");
                this.args.add(this.additional_file);
            }
            if (this.gui_settings != null) {
                this.args.add("--gui-settings-file");
                this.args.add(this.gui_settings);
            }
        } else if (this.net_file != null) {
            this.args.add("--net-file");
            this.args.add(this.net_file);
        }
        this.args.add("--remote-port");
        this.args.add(Integer.toString(this.remotePort));
        if (this.randomSeed != -1) {
            this.args.add("--seed");
            this.args.add(Integer.toString(this.randomSeed));
        }
        String[] argsArray = new String[this.args.size()];
        this.args.toArray(argsArray);
        this.sumoProcess = Runtime.getRuntime().exec(argsArray);
        StreamLogger errStreamLogger = new StreamLogger(this.sumoProcess.getErrorStream(), "SUMO-err:");
        StreamLogger outStreamLogger = new StreamLogger(this.sumoProcess.getInputStream(), "SUMO-out:");
        new Thread((Runnable)errStreamLogger, "StreamLogger-SUMO-err").start();
        new Thread((Runnable)outStreamLogger, "StreamLogger-SUMO-out").start();
    }

    private void findAvailablePort() throws IOException {
        ServerSocket testSock = new ServerSocket(0);
        this.remotePort = testSock.getLocalPort();
        testSock.close();
        testSock = null;
    }

    public void close() {
        try {
            if (this.isClosed()) {
                throw new IllegalStateException("connection is closed");
            }
            this.cp.do_close();
            this.socket.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void closeAndDontCareAboutInterruptedException() {
        this.close();
    }

    public boolean isClosed() {
        return this.socket == null || this.socket.isClosed();
    }

    public synchronized void do_job_set(SumoCommand cmd) throws Exception {
        if (this.isClosed()) {
            throw new IllegalStateException("connection is closed");
        }
        try {
            this.cp.do_job_set(cmd);
        }
        catch (Exception e) {
            this.closeAndDontCareAboutInterruptedException();
            throw e;
        }
    }

    public synchronized Object do_job_get(SumoCommand cmd) throws Exception {
        Object output = null;
        if (this.isClosed()) {
            throw new IllegalStateException("connection is closed");
        }
        try {
            output = this.cp.do_job_get(cmd);
        }
        catch (Exception e) {
            this.closeAndDontCareAboutInterruptedException();
            throw e;
        }
        return output;
    }

    public synchronized void setOrder(int index) throws Exception {
        if (this.isClosed()) {
            throw new IllegalStateException("connection is closed");
        }
        try {
            this.cp.do_setOrder(index);
        }
        catch (Exception e) {
            this.closeAndDontCareAboutInterruptedException();
            throw e;
        }
    }

    public synchronized void do_timestep() throws Exception {
        this.do_timestep(0.0);
    }

    public synchronized void do_timestep(double targetTime) throws Exception {
        if (this.isClosed()) {
            throw new IllegalStateException("connection is closed");
        }
        try {
            this.cp.do_SimulationStep(targetTime);
        }
        catch (Exception e) {
            this.closeAndDontCareAboutInterruptedException();
            throw e;
        }
    }

    public synchronized void addObserver(Observer o) {
        this.cp.addObserver(o);
    }

    public synchronized void do_subscription(Subscription cs) throws Exception {
        if (this.isClosed()) {
            throw new IllegalStateException("connection is closed");
        }
        try {
            this.cp.do_subscription(cs);
        }
        catch (Exception e) {
            this.closeAndDontCareAboutInterruptedException();
            throw e;
        }
    }

    public void printSumoOutput(boolean b) {
        stdout = b;
    }

    public void printSumoError(boolean b) {
        stderr = b;
    }

    private static class StreamLogger
    implements Runnable {
        final InputStream stream;
        final String prefix;

        public StreamLogger(InputStream stream, String prefix) {
            this.stream = stream;
            this.prefix = prefix;
        }

        @Override
        public void run() {
            BufferedReader br = new BufferedReader(new InputStreamReader(this.stream));
            try {
                String strLine;
                while ((strLine = br.readLine()) != null) {
                    if (strLine.contains("Error:") && !strLine.contains("peer shutdown")) {
                        if (!stderr) continue;
                        System.err.println(strLine);
                        continue;
                    }
                    if (!stdout) continue;
                    System.out.println(strLine);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

