/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sumo.libtraci;

import java.util.AbstractList;
import java.util.RandomAccess;
import org.eclipse.sumo.libtraci.libtraciJNI;

public class IntVector
extends AbstractList<Integer>
implements RandomAccess {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected IntVector(long cPtr, boolean cMemoryOwn) {
        this.swigCMemOwn = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(IntVector obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    protected static long swigRelease(IntVector obj) {
        long ptr = 0L;
        if (obj != null) {
            if (!obj.swigCMemOwn) {
                throw new RuntimeException("Cannot release ownership as memory is not owned");
            }
            ptr = obj.swigCPtr;
            obj.swigCMemOwn = false;
            obj.delete();
        }
        return ptr;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                libtraciJNI.delete_IntVector(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public IntVector(int[] initialElements) {
        this();
        this.reserve(initialElements.length);
        for (int element : initialElements) {
            this.add(element);
        }
    }

    public IntVector(Iterable<Integer> initialElements) {
        this();
        for (int element : initialElements) {
            this.add(element);
        }
    }

    @Override
    public Integer get(int index) {
        return this.doGet(index);
    }

    @Override
    public Integer set(int index, Integer e) {
        return this.doSet(index, e);
    }

    @Override
    public boolean add(Integer e) {
        ++this.modCount;
        this.doAdd(e);
        return true;
    }

    @Override
    public void add(int index, Integer e) {
        ++this.modCount;
        this.doAdd(index, e);
    }

    @Override
    public Integer remove(int index) {
        ++this.modCount;
        return this.doRemove(index);
    }

    @Override
    protected void removeRange(int fromIndex, int toIndex) {
        ++this.modCount;
        this.doRemoveRange(fromIndex, toIndex);
    }

    @Override
    public int size() {
        return this.doSize();
    }

    public int capacity() {
        return this.doCapacity();
    }

    public void reserve(int n) {
        this.doReserve(n);
    }

    public IntVector() {
        this(libtraciJNI.new_IntVector__SWIG_0(), true);
    }

    public IntVector(IntVector other) {
        this(libtraciJNI.new_IntVector__SWIG_1(IntVector.getCPtr(other), other), true);
    }

    @Override
    public boolean isEmpty() {
        return libtraciJNI.IntVector_isEmpty(this.swigCPtr, this);
    }

    @Override
    public void clear() {
        libtraciJNI.IntVector_clear(this.swigCPtr, this);
    }

    public IntVector(int count, int value) {
        this(libtraciJNI.new_IntVector__SWIG_2(count, value), true);
    }

    private int doCapacity() {
        return libtraciJNI.IntVector_doCapacity(this.swigCPtr, this);
    }

    private void doReserve(int n) {
        libtraciJNI.IntVector_doReserve(this.swigCPtr, this, n);
    }

    private int doSize() {
        return libtraciJNI.IntVector_doSize(this.swigCPtr, this);
    }

    private void doAdd(int x) {
        libtraciJNI.IntVector_doAdd__SWIG_0(this.swigCPtr, this, x);
    }

    private void doAdd(int index, int x) {
        libtraciJNI.IntVector_doAdd__SWIG_1(this.swigCPtr, this, index, x);
    }

    private int doRemove(int index) {
        return libtraciJNI.IntVector_doRemove(this.swigCPtr, this, index);
    }

    private int doGet(int index) {
        return libtraciJNI.IntVector_doGet(this.swigCPtr, this, index);
    }

    private int doSet(int index, int val) {
        return libtraciJNI.IntVector_doSet(this.swigCPtr, this, index, val);
    }

    private void doRemoveRange(int fromIndex, int toIndex) {
        libtraciJNI.IntVector_doRemoveRange(this.swigCPtr, this, fromIndex, toIndex);
    }
}

