/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sumo.libtraci;

import org.eclipse.sumo.libtraci.ContextSubscriptionResults;
import org.eclipse.sumo.libtraci.IntVector;
import org.eclipse.sumo.libtraci.StringStringPair;
import org.eclipse.sumo.libtraci.StringVector;
import org.eclipse.sumo.libtraci.SubscriptionResults;
import org.eclipse.sumo.libtraci.TraCIPosition;
import org.eclipse.sumo.libtraci.TraCIPositionVector;
import org.eclipse.sumo.libtraci.TraCIResults;
import org.eclipse.sumo.libtraci.libtraciJNI;

public class Junction {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected Junction(long cPtr, boolean cMemoryOwn) {
        this.swigCMemOwn = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(Junction obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    protected static long swigRelease(Junction obj) {
        long ptr = 0L;
        if (obj != null) {
            if (!obj.swigCMemOwn) {
                throw new RuntimeException("Cannot release ownership as memory is not owned");
            }
            ptr = obj.swigCPtr;
            obj.swigCMemOwn = false;
            obj.delete();
        }
        return ptr;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                libtraciJNI.delete_Junction(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public static TraCIPosition getPosition(String junctionID, boolean includeZ) {
        return new TraCIPosition(libtraciJNI.Junction_getPosition__SWIG_0(junctionID, includeZ), true);
    }

    public static TraCIPosition getPosition(String junctionID) {
        return new TraCIPosition(libtraciJNI.Junction_getPosition__SWIG_1(junctionID), true);
    }

    public static TraCIPositionVector getShape(String junctionID) {
        return new TraCIPositionVector(libtraciJNI.Junction_getShape(junctionID), true);
    }

    public static StringVector getIncomingEdges(String junctionID) {
        return new StringVector(libtraciJNI.Junction_getIncomingEdges(junctionID), true);
    }

    public static StringVector getOutgoingEdges(String junctionID) {
        return new StringVector(libtraciJNI.Junction_getOutgoingEdges(junctionID), true);
    }

    public static StringVector getIDList() {
        return new StringVector(libtraciJNI.Junction_getIDList(), true);
    }

    public static int getIDCount() {
        return libtraciJNI.Junction_getIDCount();
    }

    public static String getParameter(String objectID, String key) {
        return libtraciJNI.Junction_getParameter(objectID, key);
    }

    public static StringStringPair getParameterWithKey(String objectID, String key) {
        return new StringStringPair(libtraciJNI.Junction_getParameterWithKey(objectID, key), true);
    }

    public static void setParameter(String objectID, String key, String value) {
        libtraciJNI.Junction_setParameter(objectID, key, value);
    }

    public static void subscribe(String objectID, IntVector varIDs, double begin, double end, TraCIResults parameters) {
        libtraciJNI.Junction_subscribe__SWIG_0(objectID, IntVector.getCPtr(varIDs), varIDs, begin, end, TraCIResults.getCPtr(parameters), parameters);
    }

    public static void subscribe(String objectID, IntVector varIDs, double begin, double end) {
        libtraciJNI.Junction_subscribe__SWIG_1(objectID, IntVector.getCPtr(varIDs), varIDs, begin, end);
    }

    public static void subscribe(String objectID, IntVector varIDs, double begin) {
        libtraciJNI.Junction_subscribe__SWIG_2(objectID, IntVector.getCPtr(varIDs), varIDs, begin);
    }

    public static void subscribe(String objectID, IntVector varIDs) {
        libtraciJNI.Junction_subscribe__SWIG_3(objectID, IntVector.getCPtr(varIDs), varIDs);
    }

    public static void subscribe(String objectID) {
        libtraciJNI.Junction_subscribe__SWIG_4(objectID);
    }

    public static void unsubscribe(String objectID) {
        libtraciJNI.Junction_unsubscribe(objectID);
    }

    public static void subscribeContext(String objectID, int domain, double dist, IntVector varIDs, double begin, double end, TraCIResults parameters) {
        libtraciJNI.Junction_subscribeContext__SWIG_0(objectID, domain, dist, IntVector.getCPtr(varIDs), varIDs, begin, end, TraCIResults.getCPtr(parameters), parameters);
    }

    public static void subscribeContext(String objectID, int domain, double dist, IntVector varIDs, double begin, double end) {
        libtraciJNI.Junction_subscribeContext__SWIG_1(objectID, domain, dist, IntVector.getCPtr(varIDs), varIDs, begin, end);
    }

    public static void subscribeContext(String objectID, int domain, double dist, IntVector varIDs, double begin) {
        libtraciJNI.Junction_subscribeContext__SWIG_2(objectID, domain, dist, IntVector.getCPtr(varIDs), varIDs, begin);
    }

    public static void subscribeContext(String objectID, int domain, double dist, IntVector varIDs) {
        libtraciJNI.Junction_subscribeContext__SWIG_3(objectID, domain, dist, IntVector.getCPtr(varIDs), varIDs);
    }

    public static void subscribeContext(String objectID, int domain, double dist) {
        libtraciJNI.Junction_subscribeContext__SWIG_4(objectID, domain, dist);
    }

    public static void unsubscribeContext(String objectID, int domain, double dist) {
        libtraciJNI.Junction_unsubscribeContext(objectID, domain, dist);
    }

    public static SubscriptionResults getAllSubscriptionResults() {
        return new SubscriptionResults(libtraciJNI.Junction_getAllSubscriptionResults(), true);
    }

    public static TraCIResults getSubscriptionResults(String objectID) {
        return new TraCIResults(libtraciJNI.Junction_getSubscriptionResults(objectID), true);
    }

    public static ContextSubscriptionResults getAllContextSubscriptionResults() {
        return new ContextSubscriptionResults(libtraciJNI.Junction_getAllContextSubscriptionResults(), true);
    }

    public static SubscriptionResults getContextSubscriptionResults(String objectID) {
        return new SubscriptionResults(libtraciJNI.Junction_getContextSubscriptionResults(objectID), true);
    }

    public static void subscribeParameterWithKey(String objectID, String key, double beginTime, double endTime) {
        libtraciJNI.Junction_subscribeParameterWithKey__SWIG_0(objectID, key, beginTime, endTime);
    }

    public static void subscribeParameterWithKey(String objectID, String key, double beginTime) {
        libtraciJNI.Junction_subscribeParameterWithKey__SWIG_1(objectID, key, beginTime);
    }

    public static void subscribeParameterWithKey(String objectID, String key) {
        libtraciJNI.Junction_subscribeParameterWithKey__SWIG_2(objectID, key);
    }

    public static int getDOMAIN_ID() {
        return libtraciJNI.Junction_DOMAIN_ID_get();
    }

    public static int domainID() {
        return libtraciJNI.Junction_domainID();
    }
}

