/*
 * Decompiled with CFR 0.152.
 */
package de.dlr.ts.lisum.enums;

public enum LightColor {
    OFF(0, 'O'),
    RED(3, 'r'),
    YELLOW_BLINKING(8, 'o'),
    YELLOW(12, 'y'),
    RED_YELLOW(15, 'u'),
    GREEN(48, 'G'),
    DARK_GREEN(-1, 'g');

    private final int ocitCode;
    private final char sumoCode;

    private LightColor(int ocitCode, char sumoCode) {
        this.ocitCode = ocitCode;
        this.sumoCode = sumoCode;
    }

    public int getOcitCode() {
        return this.ocitCode;
    }

    public boolean isGreen() {
        return this.ocitCode == 48;
    }

    public char getSumoCode() {
        return this.sumoCode;
    }

    public static LightColor getPerOcitCode(int code) {
        for (LightColor sc : LightColor.values()) {
            if (sc.ocitCode != code) continue;
            return sc;
        }
        return null;
    }

    public static LightColor getPerSumoCode(char code) {
        for (LightColor sc : LightColor.values()) {
            if (sc.sumoCode != code) continue;
            return sc;
        }
        return null;
    }
}

