/*
 * Decompiled with CFR 0.152.
 */
package de.dlr.ts.lisum.lisa;

import de.dlr.ts.commons.logger.DLRLogger;
import de.dlr.ts.lisum.enums.LightColor;
import de.dlr.ts.lisum.lisa.LisaConfigurationFiles;
import de.dlr.ts.lisum.lisa.LisaSignalGroup;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class LisaSignalGroups {
    private final List<LisaSignalGroup> signals = new ArrayList<LisaSignalGroup>();
    private final Map<String, LisaSignalGroup> signalsMap = new HashMap<String, LisaSignalGroup>();

    LisaSignalGroups() {
    }

    void load(LisaConfigurationFiles.ControlUnit controlUnit) {
        for (int i = 0; i < controlUnit.signalGroups.size(); ++i) {
            LisaConfigurationFiles.ControlUnit.SignalGroup sg = controlUnit.signalGroups.get(i);
            LisaSignalGroup lisaSignalGroup = new LisaSignalGroup(sg.index, sg.bezeichnung);
            this.signals.add(lisaSignalGroup);
            this.signalsMap.put(sg.bezeichnung, lisaSignalGroup);
            DLRLogger.info((Object)this, "Adding signal group: " + sg.bezeichnung);
        }
        Collections.sort(this.signals);
    }

    public void print() {
        for (LisaSignalGroup signal : this.signals) {
            DLRLogger.info((Object)this, signal.getIndex() + " - " + signal.getName());
        }
    }

    public void parseStates(String line) {
        line = line.replaceAll("\\{", "");
        line = line.replaceAll("\\}", "");
        String[] split = line.split("/");
        for (int i = 0; i < split.length; ++i) {
            int inn = new Integer(split[i]);
            this.signals.get(i).setColor(LightColor.getPerOcitCode(inn));
        }
    }

    public LightColor getColor(int signalIndex) {
        if (signalIndex >= this.signalsCount()) {
            return LightColor.OFF;
        }
        return this.signals.get(signalIndex).getColor();
    }

    public LightColor getColor(String signalName) {
        LisaSignalGroup get = this.signalsMap.get(signalName);
        if (get == null) {
            return LightColor.OFF;
        }
        return get.getColor();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (LisaSignalGroup signal : this.signals) {
            sb.append(signal).append(", ");
        }
        return sb.toString();
    }

    public int signalsCount() {
        return this.signals.size();
    }
}

