/*
 * Decompiled with CFR 0.152.
 */
package de.dlr.ts.lisum.simulation;

import de.dlr.ts.lisum.enums.LightColor;
import de.dlr.ts.lisum.interfaces.CityInterface;
import de.dlr.ts.lisum.interfaces.ControlUnitInterface;
import de.dlr.ts.lisum.simulation.ConfigurationFile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class SimulationControlUnits {
    private final Map<String, SimuControlUnit> perSumo = new HashMap<String, SimuControlUnit>();
    private final Map<String, String> perCity = new HashMap<String, String>();
    private static final Map<String, LightColor> complexCodes = new HashMap<String, LightColor>();

    public String getSumoName(String cityName) {
        return this.perCity.get(cityName);
    }

    public void load(ConfigurationFile configFile, CityInterface city) {
        for (ConfigurationFile.CFControlUnit cfcu : configFile) {
            ControlUnitInterface controlUnitInter = city.getControlUnit(cfcu.lisaName);
            if (controlUnitInter == null) continue;
            SimuControlUnit cuu = new SimuControlUnit(controlUnitInter, cfcu.sumoName);
            cuu.load(cfcu);
            this.perSumo.put(cfcu.sumoName, cuu);
            this.perCity.put(cfcu.lisaName, cfcu.sumoName);
            controlUnitInter.setEnabled(true);
        }
        complexCodes.put("O", LightColor.OFF);
        complexCodes.put("OO", LightColor.OFF);
        complexCodes.put("OOO", LightColor.OFF);
        complexCodes.put("OoO", LightColor.OFF);
        complexCodes.put("r", LightColor.RED);
        complexCodes.put("o", LightColor.YELLOW_BLINKING);
        complexCodes.put("y", LightColor.YELLOW);
        complexCodes.put("u", LightColor.RED_YELLOW);
        complexCodes.put("G", LightColor.GREEN);
        complexCodes.put("g", LightColor.DARK_GREEN);
        complexCodes.put("rO", LightColor.RED);
        complexCodes.put("Or", LightColor.RED);
        complexCodes.put("ro", LightColor.RED);
        complexCodes.put("ry", LightColor.YELLOW);
        complexCodes.put("yr", LightColor.YELLOW);
        complexCodes.put("yO", LightColor.YELLOW);
        complexCodes.put("yo", LightColor.YELLOW);
        complexCodes.put("Oy", LightColor.YELLOW);
        complexCodes.put("uo", LightColor.RED_YELLOW);
        complexCodes.put("uO", LightColor.RED_YELLOW);
        complexCodes.put("Ou", LightColor.RED_YELLOW);
        complexCodes.put("Go", LightColor.DARK_GREEN);
        complexCodes.put("go", LightColor.DARK_GREEN);
        complexCodes.put("gO", LightColor.DARK_GREEN);
        complexCodes.put("OG", LightColor.GREEN);
        complexCodes.put("Gr", LightColor.GREEN);
        complexCodes.put("GO", LightColor.GREEN);
        complexCodes.put("Gu", LightColor.GREEN);
        complexCodes.put("rro", LightColor.RED);
        complexCodes.put("rrO", LightColor.RED);
        complexCodes.put("rGo", LightColor.RED);
        complexCodes.put("rGO", LightColor.RED);
        complexCodes.put("rOO", LightColor.RED);
        complexCodes.put("roO", LightColor.RED);
        complexCodes.put("ryo", LightColor.RED);
        complexCodes.put("ryO", LightColor.RED);
        complexCodes.put("ruO", LightColor.RED);
        complexCodes.put("ruo", LightColor.RED);
        complexCodes.put("yGO", LightColor.YELLOW);
        complexCodes.put("yOO", LightColor.YELLOW);
        complexCodes.put("yyo", LightColor.YELLOW);
        complexCodes.put("yyO", LightColor.YELLOW);
        complexCodes.put("yoO", LightColor.YELLOW);
        complexCodes.put("uOO", LightColor.RED_YELLOW);
        complexCodes.put("uoO", LightColor.RED_YELLOW);
        complexCodes.put("OGo", LightColor.DARK_GREEN);
        complexCodes.put("GoO", LightColor.DARK_GREEN);
        complexCodes.put("goO", LightColor.DARK_GREEN);
        complexCodes.put("GoG", LightColor.GREEN);
        complexCodes.put("GOG", LightColor.GREEN);
        complexCodes.put("OGO", LightColor.GREEN);
        complexCodes.put("yG", LightColor.GREEN);
    }

    public LightColor getLightColor(String controlUnitSumoName, int signalGroupIndex) {
        SimuControlUnit hh = this.perSumo.get(controlUnitSumoName);
        if (hh != null) {
            return hh.getColor(signalGroupIndex);
        }
        return LightColor.OFF;
    }

    private static class SimuControlUnit {
        private final Map<Integer, ArrayList<SignalGroup>> signalGroups = new HashMap<Integer, ArrayList<SignalGroup>>();
        private final ControlUnitInterface cui;
        private final String sumoLogicName;

        public SimuControlUnit(ControlUnitInterface cui, String sumoLogicName) {
            this.cui = cui;
            this.sumoLogicName = sumoLogicName;
        }

        LightColor getColor(int signalGroupIndex) {
            int debugIndex = -1;
            ArrayList<SignalGroup> sgs = this.signalGroups.get(signalGroupIndex);
            if (sgs == null || sgs.isEmpty()) {
                return LightColor.OFF;
            }
            String complexCode = "";
            for (SignalGroup sg : sgs) {
                if (signalGroupIndex == debugIndex) {
                    System.out.println("  buildComplexState sg.lisa=" + sg.lisa + " ocit=" + this.cui.getLightColor(sg.lisa).getOcitCode());
                }
                complexCode = complexCode + this.cui.getLightColor(sg.lisa).getSumoCode();
            }
            LightColor lightColor = (LightColor)((Object)complexCodes.get(complexCode));
            if (signalGroupIndex == debugIndex) {
                System.out.println("sumoLogic=" + this.sumoLogicName + " sumoIndex=" + signalGroupIndex + " complex=" + complexCode + " lc=" + (Object)((Object)lightColor));
            }
            if (lightColor == null) {
                System.out.println("sumoLogic=" + this.sumoLogicName + " sumoIndex=" + signalGroupIndex + " complex=" + complexCode + " could not be interpreted");
                return LightColor.OFF;
            }
            return lightColor;
        }

        void load(ConfigurationFile.CFControlUnit controlUnit) {
            for (int i = 0; i < controlUnit.signalGroups.size(); ++i) {
                String[] split;
                ConfigurationFile.CFControlUnit.SignalGroup sg = controlUnit.signalGroups.get(i);
                String string = sg.sumo;
                for (String s : split = string.split(",")) {
                    int sumoIndex = Integer.valueOf(s);
                    if (!this.signalGroups.containsKey(sumoIndex)) {
                        this.signalGroups.put(sumoIndex, new ArrayList());
                    }
                    this.signalGroups.get(sumoIndex).add(new SignalGroup(sg.lisa, sg.ifOff));
                }
            }
        }

        class SignalGroup {
            String lisa;
            String ifOff;

            public SignalGroup(String lisa, String main) {
                this.lisa = lisa;
                this.ifOff = main;
            }
        }
    }
}

