/*
 * Decompiled with CFR 0.152.
 */
package de.dlr.ts.lisum.simulation;

import de.dlr.ts.commons.logger.DLRLogger;
import de.dlr.ts.lisum.exceptions.LisumException;
import de.dlr.ts.utils.xmladmin2.MalformedKeyOrNameException;
import de.dlr.ts.utils.xmladmin2.XMLAdmin2;
import de.dlr.ts.utils.xmladmin2.XMLNodeNotFoundException;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xml.sax.SAXException;

public class SimulationFiles {
    private File sumoNetFile;
    private File sumoAddFile;
    private File sumoRouFile;
    private File simulationDirectory;
    private File lisumConfigFile;
    private File sumoConfigFile;
    private File lisaDataDirectory;

    public void setLisaDataDirectory(File lisaDataDirectory) {
        if (!lisaDataDirectory.isAbsolute()) {
            lisaDataDirectory = new File(this.simulationDirectory.getAbsolutePath() + File.separator + lisaDataDirectory.getName());
        }
        this.lisaDataDirectory = lisaDataDirectory;
    }

    public void read(File lisumConfigurationFile, String sumoConfig) throws LisumException {
        DLRLogger.config((Object)this, "Reading and setting simulation properties from " + lisumConfigurationFile + ".");
        this.lisumConfigFile = lisumConfigurationFile;
        if (!this.lisumConfigFile.isAbsolute()) {
            this.lisumConfigFile = new File(this.lisumConfigFile.getAbsolutePath());
        }
        if (!this.lisumConfigFile.exists()) {
            throw new LisumException("Fatal error: Configuration file '" + this.lisumConfigFile.getAbsolutePath() + "' does not exist.");
        }
        this.simulationDirectory = new File(this.lisumConfigFile.getParent());
        DLRLogger.config((Object)this, "Setting simulation directory: " + this.simulationDirectory);
        if (sumoConfig == null) {
            for (String s : this.simulationDirectory.list()) {
                if (!s.endsWith(".sumocfg")) continue;
                sumoConfig = s;
            }
            if (sumoConfig == null) {
                throw new LisumException("Fatal error: no Sumo configuration file could be found.");
            }
            this.sumoConfigFile = new File(this.simulationDirectory.getAbsolutePath() + File.separator + sumoConfig);
        } else {
            this.sumoConfigFile = new File(sumoConfig);
        }
        DLRLogger.config((Object)this, "Setting Sumo configuration file: " + this.sumoConfigFile);
        String tmp = null;
        try {
            XMLAdmin2 x = new XMLAdmin2().load(this.sumoConfigFile);
            try {
                tmp = x.getNode("input.net-file").getAttributes().get("value").getValue();
                if (tmp == null) {
                    throw new LisumException("Fatal error: no Sumo net.xml file could be found");
                }
                this.sumoNetFile = new File(tmp);
                if (!this.sumoNetFile.isAbsolute()) {
                    this.sumoNetFile = new File(this.sumoConfigFile.getParent() + File.separator + tmp);
                }
                DLRLogger.config((Object)this, "Setting Sumo net.xml file: " + this.sumoNetFile);
            }
            catch (XMLNodeNotFoundException ex) {
                Logger.getLogger(SimulationFiles.class.getName()).log(Level.SEVERE, null, ex);
            }
            try {
                tmp = x.getNode("input.additional-files").getAttributes().get("value").getValue();
                if (tmp != null) {
                    this.sumoAddFile = new File(tmp);
                    if (!this.sumoAddFile.isAbsolute()) {
                        this.sumoAddFile = new File(this.sumoConfigFile.getParent() + File.separator + tmp);
                    }
                    DLRLogger.config((Object)this, "Setting Sumo add.xml file: " + this.sumoAddFile);
                }
            }
            catch (XMLNodeNotFoundException ex) {
                Logger.getLogger(SimulationFiles.class.getName()).log(Level.SEVERE, null, ex);
            }
            try {
                tmp = x.getNode("input.route-files").getAttributes().get("value").getValue();
                if (tmp != null) {
                    this.sumoRouFile = new File(tmp);
                    if (!this.sumoRouFile.isAbsolute()) {
                        this.sumoRouFile = new File(this.sumoConfigFile.getParent() + File.separator + tmp);
                    }
                    DLRLogger.config((Object)this, "Setting Sumo rou.xml file: " + this.sumoRouFile);
                }
            }
            catch (XMLNodeNotFoundException ex) {
                Logger.getLogger(SimulationFiles.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        catch (MalformedKeyOrNameException | IOException | SAXException ex) {
            Logger.getLogger(SimulationFiles.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public File getLisumConfigFile() {
        return this.lisumConfigFile;
    }

    public File getSumoConfigFile() {
        return this.sumoConfigFile;
    }

    public File getSimulationDirectory() {
        return this.simulationDirectory;
    }

    public File getLisaDataDirectory() {
        return this.lisaDataDirectory;
    }

    public File getSumoNetFile() {
        return this.sumoNetFile;
    }

    public File getSumoAddFile() {
        return this.sumoAddFile;
    }

    public File getSumoRouFile() {
        return this.sumoRouFile;
    }

    void setSimulationDirectory(File simulationDirectory) {
        this.simulationDirectory = simulationDirectory;
    }
}

