/*
 * Decompiled with CFR 0.152.
 */
package de.dlr.ts.lisum.sumo;

import de.dlr.ts.commons.logger.DLRLogger;
import de.dlr.ts.lisum.interfaces.DetectorInterface;
import de.dlr.ts.lisum.simulation.LisumSimulation;
import de.dlr.ts.lisum.simulation.VehicleTypes;
import de.dlr.ts.lisum.sumo.SumoControlUnit;
import de.dlr.ts.lisum.sumo.SumoControlUnits;
import de.dlr.ts.lisum.sumo.SumoDetectors;
import de.tudresden.sumo.cmd.Inductionloop;
import de.tudresden.sumo.cmd.Simulation;
import de.tudresden.sumo.cmd.Trafficlight;
import de.tudresden.sumo.cmd.Vehicle;
import de.tudresden.sumo.objects.SumoStringList;
import it.polito.appeal.traci.SumoTraciConnection;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Sumo {
    private LisumSimulation lisumSimulation;
    private SumoControlUnits sumoControlUnits;
    private SumoDetectors sumoDetectors;
    private VehicleTypes vehicleTypes;
    private long vehiclesCount;
    private long stepsPerSecond = 0L;
    private final String sumoExec;
    private final String sumoConfig;
    private final int sumoPort;
    private final Runnable runnable = new Runnable(){

        @Override
        public void run() {
            try {
                DLRLogger.info((Object)"Sumo", "Starting SumoGUI instance, port " + Sumo.this.sumoPort);
                SumoTraciConnection conn = new SumoTraciConnection(Sumo.this.sumoExec, Sumo.this.sumoConfig);
                conn.runServer();
                Sumo.this.sumoDetectors = new SumoDetectors(conn);
                double simulationTimeSeconds = 0.0;
                Object get = conn.do_job_get(Trafficlight.getIDList());
                SumoStringList ids = (SumoStringList)get;
                for (String id : ids) {
                    SumoControlUnit sumoControlUnit = Sumo.this.sumoControlUnits.getControlUnit(id);
                    if (sumoControlUnit == null) continue;
                    sumoControlUnit.setSumoTraciConnection(conn);
                    sumoControlUnit.setControlUnits(Sumo.this.lisumSimulation.getControlUnits());
                }
                DLRLogger.finest((Object)this, "Reading detectors from Sumo");
                for (String inductionId : (SumoStringList)conn.do_job_get(Inductionloop.getIDList())) {
                    DetectorInterface cityDetector = Sumo.this.lisumSimulation.getDetectors().getDetectorPerSumoId(inductionId);
                    Sumo.this.sumoDetectors.addDetector(inductionId, cityDetector);
                }
                long time = System.currentTimeMillis();
                long _steps = 0L;
                while ((Integer)conn.do_job_get(Simulation.getMinExpectedNumber()) > 0) {
                    conn.do_timestep();
                    simulationTimeSeconds = (double)((Integer)conn.do_job_get(Simulation.getCurrentTime())).intValue() / 1000.0;
                    if (System.currentTimeMillis() - time > 1000L) {
                        Sumo.this.stepsPerSecond = _steps;
                        _steps = 0L;
                        time = System.currentTimeMillis();
                    } else {
                        ++_steps;
                    }
                    Sumo.this.vehiclesCount = ((Integer)conn.do_job_get(Vehicle.getIDCount())).intValue();
                    Sumo.this.sumoDetectors.executeSimulationStep();
                    Sumo.this.sumoControlUnits.executeSimulationStep();
                    Sumo.this.lisumSimulation.executeSimulationStep((long)simulationTimeSeconds);
                }
                conn.close();
            }
            catch (UnknownHostException ex) {
                DLRLogger.info((Object)"Sumo", "Closing SumoGUI instance");
            }
            catch (IOException | InterruptedException ex) {
                DLRLogger.info((Object)"Sumo", "Closing SumoGUI instance");
            }
            catch (Exception ex) {
                Logger.getLogger(Sumo.class.getName()).log(Level.SEVERE, null, ex);
            }
            Sumo.this.stepsPerSecond = 0L;
            Sumo.this.vehiclesCount = 0L;
        }
    };

    public Sumo(LisumSimulation lisumSimulation, String sumoExec, String sumoConfig, int sumoPort) {
        this.lisumSimulation = lisumSimulation;
        this.sumoExec = sumoExec;
        this.sumoConfig = sumoConfig;
        this.sumoPort = sumoPort;
    }

    public void initBeforePlay() {
        this.sumoControlUnits = new SumoControlUnits();
        this.sumoControlUnits.load(this.lisumSimulation.getSimulationFiles().getSumoNetFile());
        this.vehicleTypes = new VehicleTypes();
        this.vehicleTypes.load(this.lisumSimulation.getSimulationFiles().getSumoRouFile());
    }

    public void play() {
        Thread thread = new Thread(this.runnable);
        thread.start();
    }

    public Runnable getRunnable() {
        return this.runnable;
    }

    public long getVehiclesCount() {
        return this.vehiclesCount;
    }

    public long getStepsPerSecond() {
        return this.stepsPerSecond;
    }
}

