/*
 * Decompiled with CFR 0.152.
 */
package de.dlr.ts.utils.xmladmin2;

import de.dlr.ts.utils.xmladmin2.Attribute;
import de.dlr.ts.utils.xmladmin2.KeyNode;
import de.dlr.ts.utils.xmladmin2.MalformedKeyOrNameException;
import de.dlr.ts.utils.xmladmin2.XMLNode;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

class Tools {
    Tools() {
    }

    public static String formatXML(String xml) {
        try {
            Transformer serializer = SAXTransformerFactory.newInstance().newTransformer();
            serializer.setOutputProperty("indent", "yes");
            serializer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            SAXSource xmlSource = new SAXSource(new InputSource(new ByteArrayInputStream(xml.getBytes())));
            StreamResult res = new StreamResult(new ByteArrayOutputStream());
            serializer.transform(xmlSource, res);
            return new String(((ByteArrayOutputStream)res.getOutputStream()).toByteArray());
        }
        catch (IllegalArgumentException | TransformerException e) {
            return xml;
        }
    }

    public static boolean validateNodeName(String name) {
        if (!name.matches("^[^\\d].*")) {
            return false;
        }
        if (name.contains("=") || name.contains("[") || name.contains("]") || name.contains(" ")) {
            return false;
        }
        return !name.toLowerCase().startsWith("xml");
    }

    static void extract(Node orig, XMLNode new_) throws MalformedKeyOrNameException {
        new_.setName(orig.getNodeName());
        if (orig.getFirstChild() != null && orig.getFirstChild().getNodeValue() != null) {
            new_.setValue(orig.getFirstChild().getNodeValue().trim());
        }
        NamedNodeMap atts = orig.getAttributes();
        for (int i = 0; atts != null && i < atts.getLength(); ++i) {
            Node item = atts.item(i);
            Attribute aa = new Attribute();
            aa.setName(item.getNodeName());
            aa.setValue(item.getNodeValue());
            new_.getAttributes().add(aa);
        }
        NodeList list = orig.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node item = list.item(i);
            if (item.getNodeType() != 1) continue;
            XMLNode node_ = new XMLNode(item.getNodeName(), item.getNodeValue());
            new_.addNode(node_);
            Tools.extract(item, node_);
        }
    }

    static XMLNode createNodes(String key, String value) throws MalformedKeyOrNameException {
        List<KeyNode> pk = Tools.parseKey(key);
        XMLNode first = new XMLNode();
        if (!pk.isEmpty()) {
            XMLNode node = first;
            for (int i = 0; i < pk.size(); ++i) {
                KeyNode get = pk.get(i);
                if (i == 0) {
                    node.setName(get.getName());
                } else {
                    XMLNode tmp = new XMLNode(get.getName());
                    node.addNode(tmp);
                    node = tmp;
                }
                if (i == pk.size() - 1 && value != null) {
                    node.setValue(value);
                }
                if (get.getAttributes().isEmpty()) continue;
                for (int j = 0; j < get.getAttributes().size(); ++j) {
                    node.getAttributes().add(get.getAttributes().get(j));
                }
            }
        }
        return first;
    }

    static XMLNode createNodes(String key) throws MalformedKeyOrNameException {
        return Tools.createNodes(key, null);
    }

    static List<KeyNode> parseKey(String key) throws MalformedKeyOrNameException {
        return Tools.parseKey(key, 0);
    }

    static List<KeyNode> parseKey(String key, int occurrence) throws MalformedKeyOrNameException {
        if (key.isEmpty()) {
            throw new MalformedKeyOrNameException("Key cannot be empty");
        }
        if (key.endsWith(".")) {
            throw new MalformedKeyOrNameException("Key cannot end with '.'");
        }
        if (key.startsWith(".")) {
            throw new MalformedKeyOrNameException("Key cannot start with '.'");
        }
        String[] keys = Tools.split(key);
        ArrayList<KeyNode> nono = new ArrayList<KeyNode>();
        for (String k : keys) {
            nono.add(new KeyNode(k));
        }
        ((KeyNode)nono.get(nono.size() - 1)).setOccurrence(occurrence);
        return nono;
    }

    private static String[] split(String s) throws MalformedKeyOrNameException {
        ParsingResult cleaned = Tools.cleanAttributes(s);
        cleaned.keys = cleaned.string.split("\\.");
        String[] keys = Tools.restoreAttributes(cleaned);
        return keys;
    }

    private static String[] restoreAttributes(ParsingResult res) {
        String[] tmp = new String[res.keys.length];
        for (int i = 0; i < res.keys.length; ++i) {
            if (res.keys[i].contains("2saddakk2kk441uu467ru73446efd64df9skj###")) {
                while (res.keys[i].contains("2saddakk2kk441uu467ru73446efd64df9skj###")) {
                    String get = res.list.remove(0);
                    tmp[i] = res.keys[i].replaceFirst("2saddakk2kk441uu467ru73446efd64df9skj###", get);
                    res.keys[i] = tmp[i];
                }
                continue;
            }
            tmp[i] = res.keys[i];
        }
        return tmp;
    }

    static ParsingResult cleanAttributes(String s) throws MalformedKeyOrNameException {
        int first;
        ParsingResult pr = new ParsingResult();
        while ((first = s.indexOf("[")) != -1) {
            int end = s.indexOf("]");
            if (end == -1) {
                throw new MalformedKeyOrNameException("']' expected");
            }
            String subs = s.substring(first, end + 1);
            s = s.replace(subs, "2saddakk2kk441uu467ru73446efd64df9skj###");
            pr.list.add(subs);
        }
        pr.string = s;
        return pr;
    }

    static Attribute parseKeyAttribute(String s) throws MalformedKeyOrNameException {
        s = s.replace("[", "").trim();
        if (!(s = s.substring(0, s.indexOf("]"))).contains("=")) {
            throw new MalformedKeyOrNameException("[XMLReader] No '=' in attribute declaration");
        }
        String name = s.substring(0, s.indexOf("="));
        String value = s.replace(name + "=", "");
        return new Attribute(name, value);
    }

    private static class ParsingResult {
        static final String ATTS_TOKEN = "2saddakk2kk441uu467ru73446efd64df9skj###";
        List<String> list = new ArrayList<String>();
        String string;
        String[] keys;

        private ParsingResult() {
        }
    }
}

