/*
 * Decompiled with CFR 0.152.
 */
package de.dlr.ts.utils.xmladmin2;

import de.dlr.ts.utils.xmladmin2.Attribute;
import de.dlr.ts.utils.xmladmin2.KeyNode;
import de.dlr.ts.utils.xmladmin2.MalformedKeyOrNameException;
import de.dlr.ts.utils.xmladmin2.Tools;
import de.dlr.ts.utils.xmladmin2.XMLAdmin2;
import de.dlr.ts.utils.xmladmin2.XMLNodeBase;
import de.dlr.ts.utils.xmladmin2.XMLNodeNotFoundException;
import java.util.ArrayList;
import java.util.List;

public class XMLNode
extends XMLNodeBase {
    public XMLNode() {
    }

    public XMLNode(String name) throws MalformedKeyOrNameException {
        super(name);
    }

    public XMLNode(String name, String value) throws MalformedKeyOrNameException {
        super(name, value);
    }

    public void print() {
        try {
            System.out.println(this);
            for (int i = 0; i < this.getNodesCount(); ++i) {
                this.getNode(i).print();
            }
        }
        catch (MalformedKeyOrNameException | XMLNodeNotFoundException ex) {
            XMLAdmin2.printException(ex);
        }
    }

    private XMLNode getNode(List<KeyNode> keys) throws XMLNodeNotFoundException {
        if (keys != null) {
            KeyNode tmp = keys.remove(0);
            List<XMLNode> filtered = XMLNode.filterNodes(this.children, tmp);
            if (filtered.isEmpty()) {
                throw new XMLNodeNotFoundException("[XMLReader] XMLNode '" + tmp.getName() + "' not found");
            }
            if (tmp.getOccurrence() > filtered.size() - 1) {
                throw new XMLNodeNotFoundException("[XMLReader] Occurrence " + tmp.getOccurrence() + " for " + tmp.getName() + " out of bounds");
            }
            XMLNode son = filtered.get(tmp.getOccurrence());
            if (keys.isEmpty()) {
                return son;
            }
            return son.getNode(keys);
        }
        return null;
    }

    public XMLNode getNode(String key) throws XMLNodeNotFoundException, MalformedKeyOrNameException {
        return this.getNode(key, 0);
    }

    public XMLNode getNode(String key, int occurrence) throws XMLNodeNotFoundException, MalformedKeyOrNameException {
        List<KeyNode> parsedKey = Tools.parseKey(key, occurrence);
        XMLNode node = this.getNode(parsedKey);
        if (node == null) {
            throw new XMLNodeNotFoundException("[XMLReader] " + key + " node could not be found");
        }
        return node;
    }

    public int getNodesCount(String key) throws MalformedKeyOrNameException, XMLNodeNotFoundException {
        List<KeyNode> parseKey = Tools.parseKey(key, 0);
        if (parseKey.size() == 1) {
            return XMLNode.filterNodes(this.children, parseKey.get(0)).size();
        }
        if (parseKey.size() > 1) {
            KeyNode removed = parseKey.remove(parseKey.size() - 1);
            XMLNode node = this.getNode(parseKey);
            return XMLNode.filterNodes(node.children, removed).size();
        }
        return 0;
    }

    public boolean hasNode(String key) throws MalformedKeyOrNameException {
        try {
            this.getNode(key);
            return true;
        }
        catch (XMLNodeNotFoundException ex) {
            return false;
        }
    }

    private static List<XMLNode> filterNodes(List<XMLNode> list, KeyNode keyNode) {
        ArrayList<XMLNode> temp = new ArrayList<XMLNode>();
        for (XMLNode ch : list) {
            if (!ch.equals(keyNode)) continue;
            temp.add(ch);
        }
        return temp;
    }

    boolean equals(KeyNode keyNode) {
        if (!keyNode.getName().isEmpty() && !keyNode.getName().trim().equals("*")) {
            if (!keyNode.getName().equals(this.getName())) {
                return false;
            }
            if (keyNode.getValue() != null && !keyNode.getValue().isEmpty() && !keyNode.getValue().equals(this.getValue())) {
                return false;
            }
        }
        if (keyNode.getAttributes().hasAttributes()) {
            for (int i = 0; i < keyNode.getAttributes().size(); ++i) {
                if (!(keyNode.getAttributes().get(i).getValue() != null && !keyNode.getAttributes().get(i).getValue().isEmpty() ? !this.attributes.hasAttribute(keyNode.getAttributes().get(i).getName(), keyNode.getAttributes().get(i).getValue()) : this.attributes.hasAttribute(keyNode.getAttributes().get(i).getName()))) continue;
                return false;
            }
        }
        return true;
    }

    public String toString() {
        try {
            StringBuilder sb = new StringBuilder(this.getName() + " - " + this.getValue() + " (" + this.getNodesCount() + ")");
            for (int i = 0; i < this.attributes.size(); ++i) {
                sb.append(System.lineSeparator());
                sb.append("\t");
                Attribute att = this.attributes.get(i);
                sb.append(att.getName());
                sb.append(" = ");
                sb.append(att.getValue());
            }
            return sb.toString();
        }
        catch (MalformedKeyOrNameException | XMLNodeNotFoundException ex) {
            XMLAdmin2.printException(ex);
            return "";
        }
    }
}

