/*
 * Decompiled with CFR 0.152.
 */
package de.dlr.ts.utils.xmladmin2;

import de.dlr.ts.utils.xmladmin2.Attributes;
import de.dlr.ts.utils.xmladmin2.MalformedKeyOrNameException;
import de.dlr.ts.utils.xmladmin2.Tools;
import de.dlr.ts.utils.xmladmin2.Value;
import de.dlr.ts.utils.xmladmin2.XMLNode;
import de.dlr.ts.utils.xmladmin2.XMLNodeNotFoundException;
import java.util.ArrayList;
import java.util.List;

class XMLNodeBase
extends Value {
    protected List<XMLNode> children = new ArrayList<XMLNode>();
    protected Attributes attributes = new Attributes();
    protected String name = null;

    public XMLNode addNode(String key) throws MalformedKeyOrNameException {
        XMLNode child = Tools.createNodes(key);
        this.children.add(child);
        return child;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public XMLNode addNode(XMLNode child) {
        this.children.add(child);
        return child;
    }

    public void addNode(String key, String value) throws MalformedKeyOrNameException {
        XMLNode child = Tools.createNodes(key, value);
        this.children.add(child);
    }

    public Attributes getAttributes() {
        return this.attributes;
    }

    public XMLNodeBase() {
    }

    public XMLNodeBase(String name) throws MalformedKeyOrNameException {
        if (!Tools.validateNodeName(name)) {
            throw new MalformedKeyOrNameException(name);
        }
        this.name = name;
    }

    public XMLNodeBase(String name, String value) throws MalformedKeyOrNameException {
        this(name);
        this.value = value;
    }

    public String getXML(int tab) {
        StringBuilder ret = new StringBuilder();
        ret.append(this.getTabs(tab));
        ret.append("<");
        ret.append(this.name);
        if (!this.attributes.isEmpty()) {
            ret.append(this.attributes.getXML());
        }
        ret.append(">");
        if (this.children.size() > 0) {
            for (XMLNode node : this.children) {
                if (tab >= 0) {
                    ret.append(System.lineSeparator());
                    ret.append(node.getXML(tab + 1));
                    continue;
                }
                ret.append(node.getXML(tab));
            }
            if (tab >= 0) {
                ret.append(System.lineSeparator());
            }
            ret.append(this.getTabs(tab));
            ret.append("</").append(this.name).append(">");
        } else if (this.value != null) {
            ret.append(this.value);
            ret.append("</").append(this.name).append(">");
        } else {
            ret.deleteCharAt(ret.length() - 1);
            ret.append("/>");
        }
        return ret.toString();
    }

    private String getTabs(int count) {
        if (count < 0) {
            return "";
        }
        String ret = "";
        for (int i = 0; i < count; ++i) {
            ret = ret + "\t";
        }
        return ret;
    }

    public XMLNode getNode(int index) {
        return this.children.get(index);
    }

    public int getNodesCount() throws MalformedKeyOrNameException, XMLNodeNotFoundException {
        return this.children.size();
    }
}

