/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sumo.libsumo;

import org.eclipse.sumo.libsumo.ContextSubscriptionResults;
import org.eclipse.sumo.libsumo.IntVector;
import org.eclipse.sumo.libsumo.StringStringPair;
import org.eclipse.sumo.libsumo.StringVector;
import org.eclipse.sumo.libsumo.SubscriptionResults;
import org.eclipse.sumo.libsumo.TraCIResults;
import org.eclipse.sumo.libsumo.libsumoJNI;

public class ChargingStation {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected ChargingStation(long cPtr, boolean cMemoryOwn) {
        this.swigCMemOwn = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(ChargingStation obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    protected static long swigRelease(ChargingStation obj) {
        long ptr = 0L;
        if (obj != null) {
            if (!obj.swigCMemOwn) {
                throw new RuntimeException("Cannot release ownership as memory is not owned");
            }
            ptr = obj.swigCPtr;
            obj.swigCMemOwn = false;
            obj.delete();
        }
        return ptr;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                libsumoJNI.delete_ChargingStation(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public static String getLaneID(String stopID) {
        return libsumoJNI.ChargingStation_getLaneID(stopID);
    }

    public static double getStartPos(String stopID) {
        return libsumoJNI.ChargingStation_getStartPos(stopID);
    }

    public static double getEndPos(String stopID) {
        return libsumoJNI.ChargingStation_getEndPos(stopID);
    }

    public static String getName(String stopID) {
        return libsumoJNI.ChargingStation_getName(stopID);
    }

    public static int getVehicleCount(String stopID) {
        return libsumoJNI.ChargingStation_getVehicleCount(stopID);
    }

    public static StringVector getVehicleIDs(String stopID) {
        return new StringVector(libsumoJNI.ChargingStation_getVehicleIDs(stopID), true);
    }

    public static double getChargingPower(String stopID) {
        return libsumoJNI.ChargingStation_getChargingPower(stopID);
    }

    public static double getEfficiency(String stopID) {
        return libsumoJNI.ChargingStation_getEfficiency(stopID);
    }

    public static double getChargeDelay(String stopID) {
        return libsumoJNI.ChargingStation_getChargeDelay(stopID);
    }

    public static int getChargeInTransit(String stopID) {
        return libsumoJNI.ChargingStation_getChargeInTransit(stopID);
    }

    public static StringVector getIDList() {
        return new StringVector(libsumoJNI.ChargingStation_getIDList(), true);
    }

    public static int getIDCount() {
        return libsumoJNI.ChargingStation_getIDCount();
    }

    public static String getParameter(String objectID, String key) {
        return libsumoJNI.ChargingStation_getParameter(objectID, key);
    }

    public static StringStringPair getParameterWithKey(String objectID, String key) {
        return new StringStringPair(libsumoJNI.ChargingStation_getParameterWithKey(objectID, key), true);
    }

    public static void setParameter(String objectID, String key, String value) {
        libsumoJNI.ChargingStation_setParameter(objectID, key, value);
    }

    public static void subscribe(String objectID, IntVector varIDs, double begin, double end, TraCIResults parameters) {
        libsumoJNI.ChargingStation_subscribe__SWIG_0(objectID, IntVector.getCPtr(varIDs), varIDs, begin, end, TraCIResults.getCPtr(parameters), parameters);
    }

    public static void subscribe(String objectID, IntVector varIDs, double begin, double end) {
        libsumoJNI.ChargingStation_subscribe__SWIG_1(objectID, IntVector.getCPtr(varIDs), varIDs, begin, end);
    }

    public static void subscribe(String objectID, IntVector varIDs, double begin) {
        libsumoJNI.ChargingStation_subscribe__SWIG_2(objectID, IntVector.getCPtr(varIDs), varIDs, begin);
    }

    public static void subscribe(String objectID, IntVector varIDs) {
        libsumoJNI.ChargingStation_subscribe__SWIG_3(objectID, IntVector.getCPtr(varIDs), varIDs);
    }

    public static void subscribe(String objectID) {
        libsumoJNI.ChargingStation_subscribe__SWIG_4(objectID);
    }

    public static void unsubscribe(String objectID) {
        libsumoJNI.ChargingStation_unsubscribe(objectID);
    }

    public static void subscribeContext(String objectID, int domain, double dist, IntVector varIDs, double begin, double end, TraCIResults parameters) {
        libsumoJNI.ChargingStation_subscribeContext__SWIG_0(objectID, domain, dist, IntVector.getCPtr(varIDs), varIDs, begin, end, TraCIResults.getCPtr(parameters), parameters);
    }

    public static void subscribeContext(String objectID, int domain, double dist, IntVector varIDs, double begin, double end) {
        libsumoJNI.ChargingStation_subscribeContext__SWIG_1(objectID, domain, dist, IntVector.getCPtr(varIDs), varIDs, begin, end);
    }

    public static void subscribeContext(String objectID, int domain, double dist, IntVector varIDs, double begin) {
        libsumoJNI.ChargingStation_subscribeContext__SWIG_2(objectID, domain, dist, IntVector.getCPtr(varIDs), varIDs, begin);
    }

    public static void subscribeContext(String objectID, int domain, double dist, IntVector varIDs) {
        libsumoJNI.ChargingStation_subscribeContext__SWIG_3(objectID, domain, dist, IntVector.getCPtr(varIDs), varIDs);
    }

    public static void subscribeContext(String objectID, int domain, double dist) {
        libsumoJNI.ChargingStation_subscribeContext__SWIG_4(objectID, domain, dist);
    }

    public static void unsubscribeContext(String objectID, int domain, double dist) {
        libsumoJNI.ChargingStation_unsubscribeContext(objectID, domain, dist);
    }

    public static SubscriptionResults getAllSubscriptionResults() {
        return new SubscriptionResults(libsumoJNI.ChargingStation_getAllSubscriptionResults(), true);
    }

    public static TraCIResults getSubscriptionResults(String objectID) {
        return new TraCIResults(libsumoJNI.ChargingStation_getSubscriptionResults(objectID), true);
    }

    public static ContextSubscriptionResults getAllContextSubscriptionResults() {
        return new ContextSubscriptionResults(libsumoJNI.ChargingStation_getAllContextSubscriptionResults(), true);
    }

    public static SubscriptionResults getContextSubscriptionResults(String objectID) {
        return new SubscriptionResults(libsumoJNI.ChargingStation_getContextSubscriptionResults(objectID), true);
    }

    public static void subscribeParameterWithKey(String objectID, String key, double beginTime, double endTime) {
        libsumoJNI.ChargingStation_subscribeParameterWithKey__SWIG_0(objectID, key, beginTime, endTime);
    }

    public static void subscribeParameterWithKey(String objectID, String key, double beginTime) {
        libsumoJNI.ChargingStation_subscribeParameterWithKey__SWIG_1(objectID, key, beginTime);
    }

    public static void subscribeParameterWithKey(String objectID, String key) {
        libsumoJNI.ChargingStation_subscribeParameterWithKey__SWIG_2(objectID, key);
    }

    public static int getDOMAIN_ID() {
        return libsumoJNI.ChargingStation_DOMAIN_ID_get();
    }

    public static int domainID() {
        return libsumoJNI.ChargingStation_domainID();
    }

    public static void setChargingPower(String stopID, double power) {
        libsumoJNI.ChargingStation_setChargingPower(stopID, power);
    }

    public static void setEfficiency(String stopID, double efficiency) {
        libsumoJNI.ChargingStation_setEfficiency(stopID, efficiency);
    }

    public static void setChargeDelay(String stopID, double delay) {
        libsumoJNI.ChargingStation_setChargeDelay(stopID, delay);
    }

    public static void setChargeInTransit(String stopID, boolean inTransit) {
        libsumoJNI.ChargingStation_setChargeInTransit(stopID, inTransit);
    }
}

