/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sumo.libsumo;

import java.util.AbstractList;
import java.util.RandomAccess;
import org.eclipse.sumo.libsumo.libsumoJNI;

public class DoubleVector
extends AbstractList<Double>
implements RandomAccess {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected DoubleVector(long cPtr, boolean cMemoryOwn) {
        this.swigCMemOwn = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(DoubleVector obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    protected static long swigRelease(DoubleVector obj) {
        long ptr = 0L;
        if (obj != null) {
            if (!obj.swigCMemOwn) {
                throw new RuntimeException("Cannot release ownership as memory is not owned");
            }
            ptr = obj.swigCPtr;
            obj.swigCMemOwn = false;
            obj.delete();
        }
        return ptr;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                libsumoJNI.delete_DoubleVector(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public DoubleVector(double[] initialElements) {
        this();
        this.reserve(initialElements.length);
        for (double element : initialElements) {
            this.add(element);
        }
    }

    public DoubleVector(Iterable<Double> initialElements) {
        this();
        for (double element : initialElements) {
            this.add(element);
        }
    }

    @Override
    public Double get(int index) {
        return this.doGet(index);
    }

    @Override
    public Double set(int index, Double e) {
        return this.doSet(index, e);
    }

    @Override
    public boolean add(Double e) {
        ++this.modCount;
        this.doAdd(e);
        return true;
    }

    @Override
    public void add(int index, Double e) {
        ++this.modCount;
        this.doAdd(index, e);
    }

    @Override
    public Double remove(int index) {
        ++this.modCount;
        return this.doRemove(index);
    }

    @Override
    protected void removeRange(int fromIndex, int toIndex) {
        ++this.modCount;
        this.doRemoveRange(fromIndex, toIndex);
    }

    @Override
    public int size() {
        return this.doSize();
    }

    public int capacity() {
        return this.doCapacity();
    }

    public void reserve(int n) {
        this.doReserve(n);
    }

    public DoubleVector() {
        this(libsumoJNI.new_DoubleVector__SWIG_0(), true);
    }

    public DoubleVector(DoubleVector other) {
        this(libsumoJNI.new_DoubleVector__SWIG_1(DoubleVector.getCPtr(other), other), true);
    }

    @Override
    public boolean isEmpty() {
        return libsumoJNI.DoubleVector_isEmpty(this.swigCPtr, this);
    }

    @Override
    public void clear() {
        libsumoJNI.DoubleVector_clear(this.swigCPtr, this);
    }

    public DoubleVector(int count, double value) {
        this(libsumoJNI.new_DoubleVector__SWIG_2(count, value), true);
    }

    private int doCapacity() {
        return libsumoJNI.DoubleVector_doCapacity(this.swigCPtr, this);
    }

    private void doReserve(int n) {
        libsumoJNI.DoubleVector_doReserve(this.swigCPtr, this, n);
    }

    private int doSize() {
        return libsumoJNI.DoubleVector_doSize(this.swigCPtr, this);
    }

    private void doAdd(double x) {
        libsumoJNI.DoubleVector_doAdd__SWIG_0(this.swigCPtr, this, x);
    }

    private void doAdd(int index, double x) {
        libsumoJNI.DoubleVector_doAdd__SWIG_1(this.swigCPtr, this, index, x);
    }

    private double doRemove(int index) {
        return libsumoJNI.DoubleVector_doRemove(this.swigCPtr, this, index);
    }

    private double doGet(int index) {
        return libsumoJNI.DoubleVector_doGet(this.swigCPtr, this, index);
    }

    private double doSet(int index, double val) {
        return libsumoJNI.DoubleVector_doSet(this.swigCPtr, this, index, val);
    }

    private void doRemoveRange(int fromIndex, int toIndex) {
        libsumoJNI.DoubleVector_doRemoveRange(this.swigCPtr, this, fromIndex, toIndex);
    }
}

