/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sumo.libsumo;

import org.eclipse.sumo.libsumo.ContextSubscriptionResults;
import org.eclipse.sumo.libsumo.IntVector;
import org.eclipse.sumo.libsumo.StringStringPair;
import org.eclipse.sumo.libsumo.StringVector;
import org.eclipse.sumo.libsumo.SubscriptionResults;
import org.eclipse.sumo.libsumo.TraCIResults;
import org.eclipse.sumo.libsumo.TraCIVehicleDataVector;
import org.eclipse.sumo.libsumo.libsumoJNI;

public class InductionLoop {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected InductionLoop(long cPtr, boolean cMemoryOwn) {
        this.swigCMemOwn = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(InductionLoop obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    protected static long swigRelease(InductionLoop obj) {
        long ptr = 0L;
        if (obj != null) {
            if (!obj.swigCMemOwn) {
                throw new RuntimeException("Cannot release ownership as memory is not owned");
            }
            ptr = obj.swigCPtr;
            obj.swigCMemOwn = false;
            obj.delete();
        }
        return ptr;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                libsumoJNI.delete_InductionLoop(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public static double getPosition(String loopID) {
        return libsumoJNI.InductionLoop_getPosition(loopID);
    }

    public static String getLaneID(String loopID) {
        return libsumoJNI.InductionLoop_getLaneID(loopID);
    }

    public static int getLastStepVehicleNumber(String loopID) {
        return libsumoJNI.InductionLoop_getLastStepVehicleNumber(loopID);
    }

    public static double getLastStepMeanSpeed(String loopID) {
        return libsumoJNI.InductionLoop_getLastStepMeanSpeed(loopID);
    }

    public static StringVector getLastStepVehicleIDs(String loopID) {
        return new StringVector(libsumoJNI.InductionLoop_getLastStepVehicleIDs(loopID), true);
    }

    public static double getLastStepOccupancy(String loopID) {
        return libsumoJNI.InductionLoop_getLastStepOccupancy(loopID);
    }

    public static double getLastStepMeanLength(String loopID) {
        return libsumoJNI.InductionLoop_getLastStepMeanLength(loopID);
    }

    public static double getTimeSinceDetection(String loopID) {
        return libsumoJNI.InductionLoop_getTimeSinceDetection(loopID);
    }

    public static TraCIVehicleDataVector getVehicleData(String loopID) {
        return new TraCIVehicleDataVector(libsumoJNI.InductionLoop_getVehicleData(loopID), true);
    }

    public static double getIntervalOccupancy(String loopID) {
        return libsumoJNI.InductionLoop_getIntervalOccupancy(loopID);
    }

    public static double getIntervalMeanSpeed(String loopID) {
        return libsumoJNI.InductionLoop_getIntervalMeanSpeed(loopID);
    }

    public static int getIntervalVehicleNumber(String loopID) {
        return libsumoJNI.InductionLoop_getIntervalVehicleNumber(loopID);
    }

    public static StringVector getIntervalVehicleIDs(String loopID) {
        return new StringVector(libsumoJNI.InductionLoop_getIntervalVehicleIDs(loopID), true);
    }

    public static double getLastIntervalOccupancy(String loopID) {
        return libsumoJNI.InductionLoop_getLastIntervalOccupancy(loopID);
    }

    public static double getLastIntervalMeanSpeed(String loopID) {
        return libsumoJNI.InductionLoop_getLastIntervalMeanSpeed(loopID);
    }

    public static int getLastIntervalVehicleNumber(String loopID) {
        return libsumoJNI.InductionLoop_getLastIntervalVehicleNumber(loopID);
    }

    public static StringVector getLastIntervalVehicleIDs(String loopID) {
        return new StringVector(libsumoJNI.InductionLoop_getLastIntervalVehicleIDs(loopID), true);
    }

    public static void overrideTimeSinceDetection(String loopID, double time) {
        libsumoJNI.InductionLoop_overrideTimeSinceDetection(loopID, time);
    }

    public static StringVector getIDList() {
        return new StringVector(libsumoJNI.InductionLoop_getIDList(), true);
    }

    public static int getIDCount() {
        return libsumoJNI.InductionLoop_getIDCount();
    }

    public static String getParameter(String objectID, String key) {
        return libsumoJNI.InductionLoop_getParameter(objectID, key);
    }

    public static StringStringPair getParameterWithKey(String objectID, String key) {
        return new StringStringPair(libsumoJNI.InductionLoop_getParameterWithKey(objectID, key), true);
    }

    public static void setParameter(String objectID, String key, String value) {
        libsumoJNI.InductionLoop_setParameter(objectID, key, value);
    }

    public static void subscribe(String objectID, IntVector varIDs, double begin, double end, TraCIResults parameters) {
        libsumoJNI.InductionLoop_subscribe__SWIG_0(objectID, IntVector.getCPtr(varIDs), varIDs, begin, end, TraCIResults.getCPtr(parameters), parameters);
    }

    public static void subscribe(String objectID, IntVector varIDs, double begin, double end) {
        libsumoJNI.InductionLoop_subscribe__SWIG_1(objectID, IntVector.getCPtr(varIDs), varIDs, begin, end);
    }

    public static void subscribe(String objectID, IntVector varIDs, double begin) {
        libsumoJNI.InductionLoop_subscribe__SWIG_2(objectID, IntVector.getCPtr(varIDs), varIDs, begin);
    }

    public static void subscribe(String objectID, IntVector varIDs) {
        libsumoJNI.InductionLoop_subscribe__SWIG_3(objectID, IntVector.getCPtr(varIDs), varIDs);
    }

    public static void subscribe(String objectID) {
        libsumoJNI.InductionLoop_subscribe__SWIG_4(objectID);
    }

    public static void unsubscribe(String objectID) {
        libsumoJNI.InductionLoop_unsubscribe(objectID);
    }

    public static void subscribeContext(String objectID, int domain, double dist, IntVector varIDs, double begin, double end, TraCIResults parameters) {
        libsumoJNI.InductionLoop_subscribeContext__SWIG_0(objectID, domain, dist, IntVector.getCPtr(varIDs), varIDs, begin, end, TraCIResults.getCPtr(parameters), parameters);
    }

    public static void subscribeContext(String objectID, int domain, double dist, IntVector varIDs, double begin, double end) {
        libsumoJNI.InductionLoop_subscribeContext__SWIG_1(objectID, domain, dist, IntVector.getCPtr(varIDs), varIDs, begin, end);
    }

    public static void subscribeContext(String objectID, int domain, double dist, IntVector varIDs, double begin) {
        libsumoJNI.InductionLoop_subscribeContext__SWIG_2(objectID, domain, dist, IntVector.getCPtr(varIDs), varIDs, begin);
    }

    public static void subscribeContext(String objectID, int domain, double dist, IntVector varIDs) {
        libsumoJNI.InductionLoop_subscribeContext__SWIG_3(objectID, domain, dist, IntVector.getCPtr(varIDs), varIDs);
    }

    public static void subscribeContext(String objectID, int domain, double dist) {
        libsumoJNI.InductionLoop_subscribeContext__SWIG_4(objectID, domain, dist);
    }

    public static void unsubscribeContext(String objectID, int domain, double dist) {
        libsumoJNI.InductionLoop_unsubscribeContext(objectID, domain, dist);
    }

    public static SubscriptionResults getAllSubscriptionResults() {
        return new SubscriptionResults(libsumoJNI.InductionLoop_getAllSubscriptionResults(), true);
    }

    public static TraCIResults getSubscriptionResults(String objectID) {
        return new TraCIResults(libsumoJNI.InductionLoop_getSubscriptionResults(objectID), true);
    }

    public static ContextSubscriptionResults getAllContextSubscriptionResults() {
        return new ContextSubscriptionResults(libsumoJNI.InductionLoop_getAllContextSubscriptionResults(), true);
    }

    public static SubscriptionResults getContextSubscriptionResults(String objectID) {
        return new SubscriptionResults(libsumoJNI.InductionLoop_getContextSubscriptionResults(objectID), true);
    }

    public static void subscribeParameterWithKey(String objectID, String key, double beginTime, double endTime) {
        libsumoJNI.InductionLoop_subscribeParameterWithKey__SWIG_0(objectID, key, beginTime, endTime);
    }

    public static void subscribeParameterWithKey(String objectID, String key, double beginTime) {
        libsumoJNI.InductionLoop_subscribeParameterWithKey__SWIG_1(objectID, key, beginTime);
    }

    public static void subscribeParameterWithKey(String objectID, String key) {
        libsumoJNI.InductionLoop_subscribeParameterWithKey__SWIG_2(objectID, key);
    }

    public static int getDOMAIN_ID() {
        return libsumoJNI.InductionLoop_DOMAIN_ID_get();
    }

    public static int domainID() {
        return libsumoJNI.InductionLoop_domainID();
    }
}

