/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sumo.libsumo;

import org.eclipse.sumo.libsumo.ContextSubscriptionResults;
import org.eclipse.sumo.libsumo.IntVector;
import org.eclipse.sumo.libsumo.StringStringPair;
import org.eclipse.sumo.libsumo.StringVector;
import org.eclipse.sumo.libsumo.SubscriptionResults;
import org.eclipse.sumo.libsumo.TraCIColor;
import org.eclipse.sumo.libsumo.TraCIPosition;
import org.eclipse.sumo.libsumo.TraCIResults;
import org.eclipse.sumo.libsumo.libsumoJNI;

public class POI {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected POI(long cPtr, boolean cMemoryOwn) {
        this.swigCMemOwn = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(POI obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    protected static long swigRelease(POI obj) {
        long ptr = 0L;
        if (obj != null) {
            if (!obj.swigCMemOwn) {
                throw new RuntimeException("Cannot release ownership as memory is not owned");
            }
            ptr = obj.swigCPtr;
            obj.swigCMemOwn = false;
            obj.delete();
        }
        return ptr;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                libsumoJNI.delete_POI(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public static String getType(String poiID) {
        return libsumoJNI.POI_getType(poiID);
    }

    public static TraCIPosition getPosition(String poiID, boolean includeZ) {
        return new TraCIPosition(libsumoJNI.POI_getPosition__SWIG_0(poiID, includeZ), true);
    }

    public static TraCIPosition getPosition(String poiID) {
        return new TraCIPosition(libsumoJNI.POI_getPosition__SWIG_1(poiID), true);
    }

    public static TraCIColor getColor(String poiID) {
        return new TraCIColor(libsumoJNI.POI_getColor(poiID), true);
    }

    public static double getWidth(String poiID) {
        return libsumoJNI.POI_getWidth(poiID);
    }

    public static double getHeight(String poiID) {
        return libsumoJNI.POI_getHeight(poiID);
    }

    public static double getAngle(String poiID) {
        return libsumoJNI.POI_getAngle(poiID);
    }

    public static String getImageFile(String poiID) {
        return libsumoJNI.POI_getImageFile(poiID);
    }

    public static StringVector getIDList() {
        return new StringVector(libsumoJNI.POI_getIDList(), true);
    }

    public static int getIDCount() {
        return libsumoJNI.POI_getIDCount();
    }

    public static String getParameter(String objectID, String key) {
        return libsumoJNI.POI_getParameter(objectID, key);
    }

    public static StringStringPair getParameterWithKey(String objectID, String key) {
        return new StringStringPair(libsumoJNI.POI_getParameterWithKey(objectID, key), true);
    }

    public static void setParameter(String objectID, String key, String value) {
        libsumoJNI.POI_setParameter(objectID, key, value);
    }

    public static void subscribe(String objectID, IntVector varIDs, double begin, double end, TraCIResults parameters) {
        libsumoJNI.POI_subscribe__SWIG_0(objectID, IntVector.getCPtr(varIDs), varIDs, begin, end, TraCIResults.getCPtr(parameters), parameters);
    }

    public static void subscribe(String objectID, IntVector varIDs, double begin, double end) {
        libsumoJNI.POI_subscribe__SWIG_1(objectID, IntVector.getCPtr(varIDs), varIDs, begin, end);
    }

    public static void subscribe(String objectID, IntVector varIDs, double begin) {
        libsumoJNI.POI_subscribe__SWIG_2(objectID, IntVector.getCPtr(varIDs), varIDs, begin);
    }

    public static void subscribe(String objectID, IntVector varIDs) {
        libsumoJNI.POI_subscribe__SWIG_3(objectID, IntVector.getCPtr(varIDs), varIDs);
    }

    public static void subscribe(String objectID) {
        libsumoJNI.POI_subscribe__SWIG_4(objectID);
    }

    public static void unsubscribe(String objectID) {
        libsumoJNI.POI_unsubscribe(objectID);
    }

    public static void subscribeContext(String objectID, int domain, double dist, IntVector varIDs, double begin, double end, TraCIResults parameters) {
        libsumoJNI.POI_subscribeContext__SWIG_0(objectID, domain, dist, IntVector.getCPtr(varIDs), varIDs, begin, end, TraCIResults.getCPtr(parameters), parameters);
    }

    public static void subscribeContext(String objectID, int domain, double dist, IntVector varIDs, double begin, double end) {
        libsumoJNI.POI_subscribeContext__SWIG_1(objectID, domain, dist, IntVector.getCPtr(varIDs), varIDs, begin, end);
    }

    public static void subscribeContext(String objectID, int domain, double dist, IntVector varIDs, double begin) {
        libsumoJNI.POI_subscribeContext__SWIG_2(objectID, domain, dist, IntVector.getCPtr(varIDs), varIDs, begin);
    }

    public static void subscribeContext(String objectID, int domain, double dist, IntVector varIDs) {
        libsumoJNI.POI_subscribeContext__SWIG_3(objectID, domain, dist, IntVector.getCPtr(varIDs), varIDs);
    }

    public static void subscribeContext(String objectID, int domain, double dist) {
        libsumoJNI.POI_subscribeContext__SWIG_4(objectID, domain, dist);
    }

    public static void unsubscribeContext(String objectID, int domain, double dist) {
        libsumoJNI.POI_unsubscribeContext(objectID, domain, dist);
    }

    public static SubscriptionResults getAllSubscriptionResults() {
        return new SubscriptionResults(libsumoJNI.POI_getAllSubscriptionResults(), true);
    }

    public static TraCIResults getSubscriptionResults(String objectID) {
        return new TraCIResults(libsumoJNI.POI_getSubscriptionResults(objectID), true);
    }

    public static ContextSubscriptionResults getAllContextSubscriptionResults() {
        return new ContextSubscriptionResults(libsumoJNI.POI_getAllContextSubscriptionResults(), true);
    }

    public static SubscriptionResults getContextSubscriptionResults(String objectID) {
        return new SubscriptionResults(libsumoJNI.POI_getContextSubscriptionResults(objectID), true);
    }

    public static void subscribeParameterWithKey(String objectID, String key, double beginTime, double endTime) {
        libsumoJNI.POI_subscribeParameterWithKey__SWIG_0(objectID, key, beginTime, endTime);
    }

    public static void subscribeParameterWithKey(String objectID, String key, double beginTime) {
        libsumoJNI.POI_subscribeParameterWithKey__SWIG_1(objectID, key, beginTime);
    }

    public static void subscribeParameterWithKey(String objectID, String key) {
        libsumoJNI.POI_subscribeParameterWithKey__SWIG_2(objectID, key);
    }

    public static int getDOMAIN_ID() {
        return libsumoJNI.POI_DOMAIN_ID_get();
    }

    public static int domainID() {
        return libsumoJNI.POI_domainID();
    }

    public static void setType(String poiID, String poiType) {
        libsumoJNI.POI_setType(poiID, poiType);
    }

    public static void setColor(String poiID, TraCIColor color) {
        libsumoJNI.POI_setColor(poiID, TraCIColor.getCPtr(color), color);
    }

    public static void setPosition(String poiID, double x, double y) {
        libsumoJNI.POI_setPosition(poiID, x, y);
    }

    public static void setWidth(String poiID, double width) {
        libsumoJNI.POI_setWidth(poiID, width);
    }

    public static void setHeight(String poiID, double height) {
        libsumoJNI.POI_setHeight(poiID, height);
    }

    public static void setAngle(String poiID, double angle) {
        libsumoJNI.POI_setAngle(poiID, angle);
    }

    public static void setImageFile(String poiID, String imageFile) {
        libsumoJNI.POI_setImageFile(poiID, imageFile);
    }

    public static boolean add(String poiID, double x, double y, TraCIColor color, String poiType, int layer, String imgFile, double width, double height, double angle, String icon) {
        return libsumoJNI.POI_add__SWIG_0(poiID, x, y, TraCIColor.getCPtr(color), color, poiType, layer, imgFile, width, height, angle, icon);
    }

    public static boolean add(String poiID, double x, double y, TraCIColor color, String poiType, int layer, String imgFile, double width, double height, double angle) {
        return libsumoJNI.POI_add__SWIG_1(poiID, x, y, TraCIColor.getCPtr(color), color, poiType, layer, imgFile, width, height, angle);
    }

    public static boolean add(String poiID, double x, double y, TraCIColor color, String poiType, int layer, String imgFile, double width, double height) {
        return libsumoJNI.POI_add__SWIG_2(poiID, x, y, TraCIColor.getCPtr(color), color, poiType, layer, imgFile, width, height);
    }

    public static boolean add(String poiID, double x, double y, TraCIColor color, String poiType, int layer, String imgFile, double width) {
        return libsumoJNI.POI_add__SWIG_3(poiID, x, y, TraCIColor.getCPtr(color), color, poiType, layer, imgFile, width);
    }

    public static boolean add(String poiID, double x, double y, TraCIColor color, String poiType, int layer, String imgFile) {
        return libsumoJNI.POI_add__SWIG_4(poiID, x, y, TraCIColor.getCPtr(color), color, poiType, layer, imgFile);
    }

    public static boolean add(String poiID, double x, double y, TraCIColor color, String poiType, int layer) {
        return libsumoJNI.POI_add__SWIG_5(poiID, x, y, TraCIColor.getCPtr(color), color, poiType, layer);
    }

    public static boolean add(String poiID, double x, double y, TraCIColor color, String poiType) {
        return libsumoJNI.POI_add__SWIG_6(poiID, x, y, TraCIColor.getCPtr(color), color, poiType);
    }

    public static boolean add(String poiID, double x, double y, TraCIColor color) {
        return libsumoJNI.POI_add__SWIG_7(poiID, x, y, TraCIColor.getCPtr(color), color);
    }

    public static boolean remove(String poiID, int layer) {
        return libsumoJNI.POI_remove__SWIG_0(poiID, layer);
    }

    public static boolean remove(String poiID) {
        return libsumoJNI.POI_remove__SWIG_1(poiID);
    }

    public static void highlight(String poiID, TraCIColor col, double size, int alphaMax, double duration, int type) {
        libsumoJNI.POI_highlight__SWIG_0(poiID, TraCIColor.getCPtr(col), col, size, alphaMax, duration, type);
    }

    public static void highlight(String poiID, TraCIColor col, double size, int alphaMax, double duration) {
        libsumoJNI.POI_highlight__SWIG_1(poiID, TraCIColor.getCPtr(col), col, size, alphaMax, duration);
    }

    public static void highlight(String poiID, TraCIColor col, double size, int alphaMax) {
        libsumoJNI.POI_highlight__SWIG_2(poiID, TraCIColor.getCPtr(col), col, size, alphaMax);
    }

    public static void highlight(String poiID, TraCIColor col, double size) {
        libsumoJNI.POI_highlight__SWIG_3(poiID, TraCIColor.getCPtr(col), col, size);
    }

    public static void highlight(String poiID, TraCIColor col) {
        libsumoJNI.POI_highlight__SWIG_4(poiID, TraCIColor.getCPtr(col), col);
    }

    public static void highlight(String poiID) {
        libsumoJNI.POI_highlight__SWIG_5(poiID);
    }
}

