/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sumo.libtraci;

import org.eclipse.sumo.libtraci.ContextSubscriptionResults;
import org.eclipse.sumo.libtraci.IntVector;
import org.eclipse.sumo.libtraci.StringStringPair;
import org.eclipse.sumo.libtraci.StringVector;
import org.eclipse.sumo.libtraci.SubscriptionResults;
import org.eclipse.sumo.libtraci.TraCIConnectionVector;
import org.eclipse.sumo.libtraci.TraCIPositionVector;
import org.eclipse.sumo.libtraci.TraCIResults;
import org.eclipse.sumo.libtraci.libtraciJNI;

public class Lane {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected Lane(long cPtr, boolean cMemoryOwn) {
        this.swigCMemOwn = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(Lane obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    protected static long swigRelease(Lane obj) {
        long ptr = 0L;
        if (obj != null) {
            if (!obj.swigCMemOwn) {
                throw new RuntimeException("Cannot release ownership as memory is not owned");
            }
            ptr = obj.swigCPtr;
            obj.swigCMemOwn = false;
            obj.delete();
        }
        return ptr;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                libtraciJNI.delete_Lane(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public static int getLinkNumber(String laneID) {
        return libtraciJNI.Lane_getLinkNumber(laneID);
    }

    public static String getEdgeID(String laneID) {
        return libtraciJNI.Lane_getEdgeID(laneID);
    }

    public static double getLength(String laneID) {
        return libtraciJNI.Lane_getLength(laneID);
    }

    public static double getMaxSpeed(String laneID) {
        return libtraciJNI.Lane_getMaxSpeed(laneID);
    }

    public static double getFriction(String laneID) {
        return libtraciJNI.Lane_getFriction(laneID);
    }

    public static StringVector getAllowed(String laneID) {
        return new StringVector(libtraciJNI.Lane_getAllowed(laneID), true);
    }

    public static StringVector getDisallowed(String laneID) {
        return new StringVector(libtraciJNI.Lane_getDisallowed(laneID), true);
    }

    public static StringVector getChangePermissions(String laneID, int direction) {
        return new StringVector(libtraciJNI.Lane_getChangePermissions(laneID, direction), true);
    }

    public static TraCIConnectionVector getLinks(String laneID) {
        return new TraCIConnectionVector(libtraciJNI.Lane_getLinks(laneID), true);
    }

    public static TraCIPositionVector getShape(String laneID) {
        return new TraCIPositionVector(libtraciJNI.Lane_getShape(laneID), true);
    }

    public static double getWidth(String laneID) {
        return libtraciJNI.Lane_getWidth(laneID);
    }

    public static double getCO2Emission(String laneID) {
        return libtraciJNI.Lane_getCO2Emission(laneID);
    }

    public static double getCOEmission(String laneID) {
        return libtraciJNI.Lane_getCOEmission(laneID);
    }

    public static double getHCEmission(String laneID) {
        return libtraciJNI.Lane_getHCEmission(laneID);
    }

    public static double getPMxEmission(String laneID) {
        return libtraciJNI.Lane_getPMxEmission(laneID);
    }

    public static double getNOxEmission(String laneID) {
        return libtraciJNI.Lane_getNOxEmission(laneID);
    }

    public static double getFuelConsumption(String laneID) {
        return libtraciJNI.Lane_getFuelConsumption(laneID);
    }

    public static double getNoiseEmission(String laneID) {
        return libtraciJNI.Lane_getNoiseEmission(laneID);
    }

    public static double getElectricityConsumption(String laneID) {
        return libtraciJNI.Lane_getElectricityConsumption(laneID);
    }

    public static double getLastStepMeanSpeed(String laneID) {
        return libtraciJNI.Lane_getLastStepMeanSpeed(laneID);
    }

    public static double getLastStepOccupancy(String laneID) {
        return libtraciJNI.Lane_getLastStepOccupancy(laneID);
    }

    public static double getLastStepLength(String laneID) {
        return libtraciJNI.Lane_getLastStepLength(laneID);
    }

    public static double getWaitingTime(String laneID) {
        return libtraciJNI.Lane_getWaitingTime(laneID);
    }

    public static double getTraveltime(String laneID) {
        return libtraciJNI.Lane_getTraveltime(laneID);
    }

    public static int getLastStepVehicleNumber(String laneID) {
        return libtraciJNI.Lane_getLastStepVehicleNumber(laneID);
    }

    public static int getLastStepHaltingNumber(String laneID) {
        return libtraciJNI.Lane_getLastStepHaltingNumber(laneID);
    }

    public static StringVector getLastStepVehicleIDs(String laneID) {
        return new StringVector(libtraciJNI.Lane_getLastStepVehicleIDs(laneID), true);
    }

    public static StringVector getFoes(String laneID, String toLaneID) {
        return new StringVector(libtraciJNI.Lane_getFoes(laneID, toLaneID), true);
    }

    public static StringVector getInternalFoes(String laneID) {
        return new StringVector(libtraciJNI.Lane_getInternalFoes(laneID), true);
    }

    public static StringVector getPendingVehicles(String laneID) {
        return new StringVector(libtraciJNI.Lane_getPendingVehicles(laneID), true);
    }

    public static double getAngle(String laneID, double relativePosition) {
        return libtraciJNI.Lane_getAngle__SWIG_0(laneID, relativePosition);
    }

    public static double getAngle(String laneID) {
        return libtraciJNI.Lane_getAngle__SWIG_1(laneID);
    }

    public static String getBidiLane(String laneID) {
        return libtraciJNI.Lane_getBidiLane(laneID);
    }

    public static StringVector getIDList() {
        return new StringVector(libtraciJNI.Lane_getIDList(), true);
    }

    public static int getIDCount() {
        return libtraciJNI.Lane_getIDCount();
    }

    public static String getParameter(String objectID, String key) {
        return libtraciJNI.Lane_getParameter(objectID, key);
    }

    public static StringStringPair getParameterWithKey(String objectID, String key) {
        return new StringStringPair(libtraciJNI.Lane_getParameterWithKey(objectID, key), true);
    }

    public static void setParameter(String objectID, String key, String value) {
        libtraciJNI.Lane_setParameter(objectID, key, value);
    }

    public static void subscribe(String objectID, IntVector varIDs, double begin, double end, TraCIResults parameters) {
        libtraciJNI.Lane_subscribe__SWIG_0(objectID, IntVector.getCPtr(varIDs), varIDs, begin, end, TraCIResults.getCPtr(parameters), parameters);
    }

    public static void subscribe(String objectID, IntVector varIDs, double begin, double end) {
        libtraciJNI.Lane_subscribe__SWIG_1(objectID, IntVector.getCPtr(varIDs), varIDs, begin, end);
    }

    public static void subscribe(String objectID, IntVector varIDs, double begin) {
        libtraciJNI.Lane_subscribe__SWIG_2(objectID, IntVector.getCPtr(varIDs), varIDs, begin);
    }

    public static void subscribe(String objectID, IntVector varIDs) {
        libtraciJNI.Lane_subscribe__SWIG_3(objectID, IntVector.getCPtr(varIDs), varIDs);
    }

    public static void subscribe(String objectID) {
        libtraciJNI.Lane_subscribe__SWIG_4(objectID);
    }

    public static void unsubscribe(String objectID) {
        libtraciJNI.Lane_unsubscribe(objectID);
    }

    public static void subscribeContext(String objectID, int domain, double dist, IntVector varIDs, double begin, double end, TraCIResults parameters) {
        libtraciJNI.Lane_subscribeContext__SWIG_0(objectID, domain, dist, IntVector.getCPtr(varIDs), varIDs, begin, end, TraCIResults.getCPtr(parameters), parameters);
    }

    public static void subscribeContext(String objectID, int domain, double dist, IntVector varIDs, double begin, double end) {
        libtraciJNI.Lane_subscribeContext__SWIG_1(objectID, domain, dist, IntVector.getCPtr(varIDs), varIDs, begin, end);
    }

    public static void subscribeContext(String objectID, int domain, double dist, IntVector varIDs, double begin) {
        libtraciJNI.Lane_subscribeContext__SWIG_2(objectID, domain, dist, IntVector.getCPtr(varIDs), varIDs, begin);
    }

    public static void subscribeContext(String objectID, int domain, double dist, IntVector varIDs) {
        libtraciJNI.Lane_subscribeContext__SWIG_3(objectID, domain, dist, IntVector.getCPtr(varIDs), varIDs);
    }

    public static void subscribeContext(String objectID, int domain, double dist) {
        libtraciJNI.Lane_subscribeContext__SWIG_4(objectID, domain, dist);
    }

    public static void unsubscribeContext(String objectID, int domain, double dist) {
        libtraciJNI.Lane_unsubscribeContext(objectID, domain, dist);
    }

    public static SubscriptionResults getAllSubscriptionResults() {
        return new SubscriptionResults(libtraciJNI.Lane_getAllSubscriptionResults(), true);
    }

    public static TraCIResults getSubscriptionResults(String objectID) {
        return new TraCIResults(libtraciJNI.Lane_getSubscriptionResults(objectID), true);
    }

    public static ContextSubscriptionResults getAllContextSubscriptionResults() {
        return new ContextSubscriptionResults(libtraciJNI.Lane_getAllContextSubscriptionResults(), true);
    }

    public static SubscriptionResults getContextSubscriptionResults(String objectID) {
        return new SubscriptionResults(libtraciJNI.Lane_getContextSubscriptionResults(objectID), true);
    }

    public static void subscribeParameterWithKey(String objectID, String key, double beginTime, double endTime) {
        libtraciJNI.Lane_subscribeParameterWithKey__SWIG_0(objectID, key, beginTime, endTime);
    }

    public static void subscribeParameterWithKey(String objectID, String key, double beginTime) {
        libtraciJNI.Lane_subscribeParameterWithKey__SWIG_1(objectID, key, beginTime);
    }

    public static void subscribeParameterWithKey(String objectID, String key) {
        libtraciJNI.Lane_subscribeParameterWithKey__SWIG_2(objectID, key);
    }

    public static int getDOMAIN_ID() {
        return libtraciJNI.Lane_DOMAIN_ID_get();
    }

    public static int domainID() {
        return libtraciJNI.Lane_domainID();
    }

    public static void setAllowed(String laneID, String allowedClasses) {
        libtraciJNI.Lane_setAllowed__SWIG_0(laneID, allowedClasses);
    }

    public static void setAllowed(String laneID, StringVector allowedClasses) {
        libtraciJNI.Lane_setAllowed__SWIG_1(laneID, StringVector.getCPtr(allowedClasses), allowedClasses);
    }

    public static void setDisallowed(String laneID, String disallowedClasses) {
        libtraciJNI.Lane_setDisallowed__SWIG_0(laneID, disallowedClasses);
    }

    public static void setDisallowed(String laneID, StringVector disallowedClasses) {
        libtraciJNI.Lane_setDisallowed__SWIG_1(laneID, StringVector.getCPtr(disallowedClasses), disallowedClasses);
    }

    public static void setChangePermissions(String laneID, StringVector allowedClasses, int direction) {
        libtraciJNI.Lane_setChangePermissions(laneID, StringVector.getCPtr(allowedClasses), allowedClasses, direction);
    }

    public static void setMaxSpeed(String laneID, double speed) {
        libtraciJNI.Lane_setMaxSpeed(laneID, speed);
    }

    public static void setLength(String laneID, double length) {
        libtraciJNI.Lane_setLength(laneID, length);
    }

    public static void setFriction(String laneID, double friction) {
        libtraciJNI.Lane_setFriction(laneID, friction);
    }
}

